/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPoolHeap;
import org.gudy.azureus2.core3.util.DirectByteBufferPoolReal;

public abstract class DirectByteBufferPool {
    private static final DirectByteBufferPool impl;

    public static DirectByteBuffer getBuffer(byte by, int n) {
        return impl.getBufferSupport(by, n);
    }

    protected abstract DirectByteBuffer getBufferSupport(byte var1, int var2);

    protected abstract void returnBufferSupport(DirectByteBuffer var1);

    static {
        if (System.getProperty("use.heap.buffers") != null) {
            impl = new DirectByteBufferPoolHeap();
            Debug.outNoStack("******** USE_HEAP_BUFFERS MODE ENABLED ********");
        } else {
            impl = new DirectByteBufferPoolReal();
        }
    }
}

