/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util.test;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Random;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SHA1;

public class SHA1Verification {
    public static final String dirname = "D:" + System.getProperty("file.separator") + "testdir";

    public static void main(String[] stringArray) {
        if (!new File(dirname).exists()) {
            SHA1Verification.createTestFiles();
        }
        SHA1Verification.runTests();
    }

    public static void createTestFiles() {
        try {
            System.out.println("Creating test files ... ");
            Random random = new Random();
            String string = "f-";
            long[] lArray = new long[]{0L, 1L, 50000000L};
            File file = new File(dirname);
            FileUtil.mkdirs(file);
            for (int i = 0; i < lArray.length; ++i) {
                ByteBuffer byteBuffer;
                long l = lArray[i];
                File file2 = new File(file, string + String.valueOf(l));
                System.out.println(file2.getName() + "...");
                FileChannel fileChannel = new RandomAccessFile(file2, "rw").getChannel();
                for (long j = 0L; j < l; j += (long)fileChannel.write(byteBuffer)) {
                    long l2 = l - j;
                    if (l2 > 1024000L) {
                        l2 = 1024000L;
                    }
                    byte[] byArray = new byte[new Long(l2).intValue()];
                    random.nextBytes(byArray);
                    byteBuffer = ByteBuffer.wrap(byArray);
                }
                fileChannel.close();
            }
            System.out.println("DONE\n");
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
        }
    }

    public static void runTests() {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            SHA1 sHA1 = new SHA1();
            ByteBuffer byteBuffer = ByteBuffer.allocate(0x100000);
            File file = new File(dirname);
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                Object object;
                byte[] byArray;
                FileChannel fileChannel = new RandomAccessFile(fileArray[i], "r").getChannel();
                System.out.println("Testing " + fileArray[i].getName() + " ...");
                while (fileChannel.position() < fileChannel.size()) {
                    fileChannel.read(byteBuffer);
                    byteBuffer.flip();
                    byArray = new byte[byteBuffer.limit()];
                    System.arraycopy(byteBuffer.array(), 0, byArray, 0, byArray.length);
                    sHA1.update(byteBuffer);
                    sHA1.saveState();
                    object = ByteBuffer.wrap(new byte[56081]);
                    sHA1.digest((ByteBuffer)object);
                    sHA1.restoreState();
                    messageDigest.update(byArray);
                    byteBuffer.clear();
                }
                byArray = messageDigest.digest();
                messageDigest.reset();
                object = sHA1.digest();
                sHA1.reset();
                if (Arrays.equals(byArray, object)) {
                    System.out.println("  SHA1-Gudy: OK");
                } else {
                    System.out.println("  SHA1-Gudy: FAILED");
                }
                byteBuffer.clear();
                fileChannel.close();
                System.out.println();
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }
}

