/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.macosx;

import com.aelitis.azureus.core.AzureusCore;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerListener;
import org.gudy.azureus2.platform.PlatformManagerPingCallback;
import org.gudy.azureus2.platform.macosx.NativeInvocationBridge;
import org.gudy.azureus2.platform.macosx.PListEditor;
import org.gudy.azureus2.platform.macosx.access.jnilib.OSXAccess;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;

public class PlatformManagerImpl
implements PlatformManager,
AEDiagnosticsEvidenceGenerator {
    private static final LogIDs LOGID = LogIDs.CORE;
    protected static PlatformManagerImpl singleton;
    protected static AEMonitor class_mon;
    private static String fileBrowserName;
    private final HashSet capabilitySet = new HashSet();
    private volatile String computer_name;
    private volatile boolean computer_name_tried;
    private Class<?> claFileManager;

    public static PlatformManagerImpl getSingleton() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeSingleton() {
        try {
            class_mon.enter();
            singleton = new PlatformManagerImpl();
        }
        catch (Throwable throwable) {
            Logger.log(new LogEvent(LOGID, "Failed to initialize platform manager for Mac OS X", throwable));
        }
        finally {
            class_mon.exit();
        }
        COConfigurationManager.addAndFireParameterListener("FileBrowse.usePathFinder", new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                fileBrowserName = COConfigurationManager.getBooleanParameter("FileBrowse.usePathFinder") ? "Path Finder" : "Finder";
            }
        });
    }

    public PlatformManagerImpl() {
        this.capabilitySet.add(PlatformManagerCapabilities.RecoverableFileDelete);
        this.capabilitySet.add(PlatformManagerCapabilities.ShowFileInBrowser);
        this.capabilitySet.add(PlatformManagerCapabilities.ShowPathInCommandLine);
        this.capabilitySet.add(PlatformManagerCapabilities.CreateCommandLineProcess);
        this.capabilitySet.add(PlatformManagerCapabilities.GetUserDataDirectory);
        this.capabilitySet.add(PlatformManagerCapabilities.UseNativeScripting);
        this.capabilitySet.add(PlatformManagerCapabilities.PlaySystemAlert);
        this.capabilitySet.add(PlatformManagerCapabilities.RequestUserAttention);
        if (OSXAccess.isLoaded()) {
            this.capabilitySet.add(PlatformManagerCapabilities.GetVersion);
        }
        AEDiagnostics.addEvidenceGenerator(this);
        if (this.checkPList()) {
            // empty if block
        }
        this.capabilitySet.add(PlatformManagerCapabilities.RunAtLogin);
    }

    @Override
    public int getPlatformType() {
        return 3;
    }

    @Override
    public String getVersion() throws PlatformManagerException {
        if (!OSXAccess.isLoaded()) {
            throw new PlatformManagerException("Unsupported capability called on platform manager");
        }
        return OSXAccess.getVersion();
    }

    protected PListEditor getPList() throws IOException {
        String string = System.getProperty("user.dir") + SystemProperties.SEP + SystemProperties.getApplicationName() + ".app/Contents/Info.plist";
        if (!new File(string).exists()) {
            Debug.out("WARNING: plist not found: " + string);
            return null;
        }
        PListEditor pListEditor = new PListEditor(string);
        return pListEditor;
    }

    protected boolean checkPList() {
        try {
            PListEditor pListEditor = this.getPList();
            if (pListEditor == null) {
                return false;
            }
            pListEditor.setFileTypeExtensions(new String[]{"torrent", "tor", "vuze", "vuz"});
            pListEditor.setSimpleStringValue("CFBundleName", "Vuze");
            pListEditor.setSimpleStringValue("CFBundleTypeName", "Vuze Download");
            pListEditor.setSimpleStringValue("CFBundleGetInfoString", "Vuze");
            pListEditor.setSimpleStringValue("CFBundleShortVersionString", "4.5.0.4");
            pListEditor.setSimpleStringValue("CFBundleVersion", "4.5.0.4");
            pListEditor.setArrayValues("CFBundleURLSchemes", "string", new String[]{"magnet", "dht", "vuze", "bc", "bctp"});
            pListEditor.touchFile();
            return true;
        }
        catch (Throwable throwable) {
            Debug.out("Failed to update plist", throwable);
            return false;
        }
    }

    protected void touchPList() {
        try {
            PListEditor pListEditor = this.getPList();
            pListEditor.touchFile();
        }
        catch (Throwable throwable) {
            Debug.out("Failed to touch plist", throwable);
        }
    }

    @Override
    public File getVMOptionFile() throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public String[] getExplicitVMOptions() throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void setExplicitVMOptions(String[] stringArray) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void startup(AzureusCore azureusCore) throws PlatformManagerException {
    }

    @Override
    public int getShutdownTypes() {
        return 0;
    }

    @Override
    public void shutdown(int n) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean getRunAtLogin() throws PlatformManagerException {
        File file = this.getLoginPList();
        if (!file.exists()) {
            return false;
        }
        File file2 = this.getAbsoluteBundleFile();
        if (!file2.exists()) {
            return false;
        }
        try {
            this.convertToXML(file);
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            boolean bl = false;
            String string = file2.getAbsolutePath();
            try {
                while (true) {
                    String string2;
                    if ((string2 = lineNumberReader.readLine()) == null) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    if (!bl) {
                        if (!this.containsTag(string2, "AutoLaunchedApplicationDictionary")) continue;
                        bl = true;
                        continue;
                    }
                    if (string2.contains(string)) break;
                }
                boolean bl3 = true;
                return bl3;
            }
            finally {
                lineNumberReader.close();
            }
        }
        catch (Throwable throwable) {
            throw new PlatformManagerException("Failed to read input file", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRunAtLogin(boolean bl) throws PlatformManagerException {
        Object object;
        if (this.getRunAtLogin() == bl) {
            return;
        }
        File file = this.getAbsoluteBundleFile();
        if (!file.exists()) {
            throw new PlatformManagerException("Failed to write set run-at-login, bundle not found");
        }
        File file2 = this.getLoginPList();
        if (file2.exists()) {
            this.convertToXML(file2);
        } else {
            try {
                object = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8"));
                try {
                    ((PrintWriter)object).println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    ((PrintWriter)object).println("<!DOCTYPE plist PUBLIC \"-//Apple Computer//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">");
                    ((PrintWriter)object).println("<plist version=\"1.0\">");
                    ((PrintWriter)object).println("<dict>");
                    ((PrintWriter)object).println("</dict>");
                    ((PrintWriter)object).println("</plist>");
                }
                finally {
                    ((PrintWriter)object).close();
                }
            }
            catch (Throwable throwable) {
                throw new PlatformManagerException("Failed to write output file", throwable);
            }
        }
        try {
            Object object2;
            object = new ArrayList();
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file2), "UTF-8"));
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            String string = file.getAbsolutePath();
            try {
                while ((object2 = lineNumberReader.readLine()) != null) {
                    object.add(object2);
                    if (n == -1 && this.containsTag((String)object2, "<dict>")) {
                        n = object.size();
                    }
                    if (n2 == -1 && this.containsTag((String)object2, "AutoLaunchedApplicationDictionary")) {
                        n2 = object.size();
                    }
                    if (!((String)object2).contains(string)) continue;
                    n3 = object.size();
                }
                if (n == -1) {
                    throw new PlatformManagerException("Malformed plist - no 'dict' entry");
                }
                if (n2 == -1) {
                    object.add(n, "\t<key>AutoLaunchedApplicationDictionary</key>");
                    n2 = n + 1;
                    object.add(n2, "\t<array>");
                    object.add(n2 + 1, "\t</array>");
                }
            }
            finally {
                lineNumberReader.close();
            }
            if (bl) {
                if (n3 != -1 || n2 == -1) {
                    return;
                }
                n3 = n2 + 1;
                object.add(n3++, "\t\t<dict>");
                object.add(n3++, "\t\t\t<key>Path</key>");
                object.add(n3++, "\t\t\t<string>" + string + "</string>");
                object.add(n3++, "\t\t</dict>");
            } else {
                if (n3 == -1) {
                    return;
                }
                while (!this.containsTag((String)object.get(n3), "</dict>")) {
                    object.remove(n3);
                }
                object.remove(n3);
                --n3;
                while (!this.containsTag((String)object.get(n3), "<dict>")) {
                    object.remove(n3);
                    --n3;
                }
                object.remove(n3);
            }
            object2 = new File(file2.getParentFile(), file2.getName() + ".bak");
            if (((File)object2).exists()) {
                ((File)object2).delete();
            }
            if (!file2.renameTo((File)object2)) {
                throw new PlatformManagerException("Failed to backup " + file2);
            }
            boolean bl2 = false;
            try {
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8"));
                try {
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        printWriter.println(string2);
                    }
                }
                finally {
                    printWriter.close();
                    if (printWriter.checkError()) {
                        throw new PlatformManagerException("Failed to write output file");
                    }
                    bl2 = true;
                }
            }
            finally {
                if (!bl2) {
                    ((File)object2).renameTo(file2);
                }
            }
        }
        catch (PlatformManagerException platformManagerException) {
            throw platformManagerException;
        }
        catch (Throwable throwable) {
            throw new PlatformManagerException("Failed to write output file", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertToXML(File file) throws PlatformManagerException {
        try {
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            try {
                String string = lineNumberReader.readLine();
                if (string == null) {
                    return;
                }
                if (string.trim().toLowerCase().startsWith("<?xml")) {
                    return;
                }
                Runtime.getRuntime().exec(new String[]{this.findCommand("plutil"), "-convert", "xml1", file.getAbsolutePath()}).waitFor();
            }
            finally {
                lineNumberReader.close();
            }
        }
        catch (Throwable throwable) {
            throw new PlatformManagerException("Failed to convert plist to xml");
        }
    }

    private String findCommand(String string) {
        String[] stringArray;
        for (String string2 : stringArray = new String[]{"/bin", "/usr/bin"}) {
            File file = new File(string2, string);
            if (!file.exists() || !file.canRead()) continue;
            return file.getAbsolutePath();
        }
        return string;
    }

    private boolean containsTag(String string, String string2) {
        string = string.trim().toLowerCase(Locale.US);
        string2 = string2.toLowerCase(Locale.US);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (char c : string.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString().contains(string2);
    }

    private File getLoginPList() throws PlatformManagerException {
        return new File(System.getProperty("user.home"), "/Library/Preferences/loginwindow.plist");
    }

    @Override
    public String getUserDataDirectory() throws PlatformManagerException {
        return new File(System.getProperty("user.home") + "/Library/Application Support/" + SystemProperties.APPLICATION_NAME).getPath() + SystemProperties.SEP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getComputerName() {
        if (this.computer_name_tried) {
            return this.computer_name;
        }
        try {
            String[] stringArray;
            Object object = null;
            String[] stringArray2 = System.getenv("HOSTNAME");
            if (stringArray2 != null && stringArray2.length() > 0) {
                object = stringArray2;
            }
            if (object == null && (stringArray = System.getenv("HOST")) != null && stringArray.length() > 0) {
                object = stringArray;
            }
            if (object == null) {
                try {
                    stringArray = new String[]{"/bin/sh", "-c", "echo $HOSTNAME"};
                    Process process = Runtime.getRuntime().exec(stringArray);
                    if (process.waitFor() == 0) {
                        int n;
                        byte[] byArray;
                        int n2;
                        String string = "";
                        InputStream inputStream = process.getInputStream();
                        while ((n2 = inputStream.read(byArray = new byte[1024])) > 0 && (string = string + new String(byArray, 0, n2)).length() <= 64) {
                        }
                        if (string.length() > 0 && (n = ((String)(object = string.trim())).indexOf(32)) != -1) {
                            object = ((String)object).substring(0, n).trim();
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (object != null) {
                int n = ((String)object).lastIndexOf(46);
                if (n != -1) {
                    object = ((String)object).substring(0, n);
                }
                if (((String)object).length() > 0) {
                    if (((String)object).length() > 32) {
                        object = ((String)object).substring(0, 32);
                    }
                    this.computer_name = object;
                }
            }
            String string = this.computer_name;
            return string;
        }
        finally {
            this.computer_name_tried = true;
        }
    }

    @Override
    public File getLocation(long l) throws PlatformManagerException {
        switch ((int)l) {
            case 1: {
                return new File(this.getUserDataDirectory());
            }
            case 3: {
                try {
                    return new File(OSXAccess.getDocDir());
                }
                catch (Throwable throwable) {
                    return new File(System.getProperty("user.home"), "Documents");
                }
            }
        }
        return null;
    }

    @Override
    public boolean isApplicationRegistered() throws PlatformManagerException {
        return true;
    }

    private String getBundlePath() {
        return System.getProperty("user.dir") + SystemProperties.SEP + SystemProperties.getApplicationName() + ".app";
    }

    private File getAbsoluteBundleFile() {
        return new File(this.getBundlePath()).getAbsoluteFile();
    }

    @Override
    public String getApplicationCommandLine() throws PlatformManagerException {
        try {
            File file = this.getAbsoluteBundleFile();
            if (!file.exists()) {
                String string = "OSX app bundle not found: [" + file.toString() + "]";
                System.out.println(string);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, string));
                }
                throw new PlatformManagerException(string);
            }
            return "open -a \"" + file.toString() + "\"";
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isAdditionalFileTypeRegistered(String string, String string2) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void unregisterAdditionalFileType(String string, String string2) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void registerAdditionalFileType(String string, String string2, String string3, String string4) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void registerApplication() throws PlatformManagerException {
        this.touchPList();
    }

    @Override
    public void createProcess(String string, boolean bl) throws PlatformManagerException {
        try {
            PlatformManagerImpl.performRuntimeExec(string.split(" "));
        }
        catch (Throwable throwable) {
            throw new PlatformManagerException("Failed to create process", throwable);
        }
    }

    private Class<?> getFileManagerClass() {
        if (this.claFileManager != null) {
            return this.claFileManager;
        }
        try {
            Class<?> clazz = Class.forName("org.gudy.azureus2.ui.swt.osx.CocoaUIEnhancer");
            if (((Boolean)clazz.getMethod("isInitialized", new Class[0]).invoke(null, new Object[0])).booleanValue()) {
                this.claFileManager = Class.forName("com.apple.eio.FileManager");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.claFileManager;
    }

    @Override
    public void performRecoverableFileDelete(String string) throws PlatformManagerException {
        boolean bl;
        Object object;
        File file = new File(string);
        if (!file.exists()) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 1, "Cannot find " + file.getName()));
            }
            return;
        }
        try {
            Object object2;
            Class<?> clazz = this.getFileManagerClass();
            if (clazz != null && (object = clazz.getMethod("moveToTrash", File.class)) != null && (object2 = ((Method)object).invoke(null, file)) instanceof Boolean && ((Boolean)object2).booleanValue()) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean bl2 = bl = !NativeInvocationBridge.sharedInstance().isEnabled() || !NativeInvocationBridge.sharedInstance().performRecoverableFileDelete(file);
        if (bl) {
            try {
                object = new StringBuffer();
                ((StringBuffer)object).append("tell application \"");
                ((StringBuffer)object).append("Finder");
                ((StringBuffer)object).append("\" to move (posix file \"");
                ((StringBuffer)object).append(string);
                ((StringBuffer)object).append("\" as alias) to the trash");
                PlatformManagerImpl.performOSAScript((CharSequence)object);
            }
            catch (Throwable throwable) {
                throw new PlatformManagerException("Failed to move file", throwable);
            }
        }
    }

    @Override
    public boolean hasCapability(PlatformManagerCapabilities platformManagerCapabilities) {
        return this.capabilitySet.contains(platformManagerCapabilities);
    }

    @Override
    public void dispose() {
        try {
            if (NativeInvocationBridge.hasSharedInstance()) {
                NativeInvocationBridge.sharedInstance().dispose();
            }
        }
        catch (Throwable throwable) {
            Debug.out("Problem disposing NativeInvocationBridge", throwable);
        }
    }

    @Override
    public void setTCPTOSEnabled(boolean bl) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void copyFilePermissions(String string, String string2) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void showFile(String string) throws PlatformManagerException {
        File file = new File(string);
        if (!file.exists()) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 1, "Cannot find " + file.getName()));
            }
            throw new PlatformManagerException("File not found");
        }
        this.showInFinder(file);
    }

    public void playSystemAlert() {
        try {
            PlatformManagerImpl.performRuntimeExec(new String[]{"beep"});
        }
        catch (IOException iOException) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 1, "Cannot play system alert"));
            }
            Logger.log(new LogEvent(LOGID, "", iOException));
        }
    }

    public void showInFinder(File file) {
        boolean bl;
        Object object;
        try {
            Object object2;
            Class<?> clazz = this.getFileManagerClass();
            if (clazz != null && PlatformManagerImpl.getFileBrowserName().equals("Finder") && (object = clazz.getMethod("revealInFinder", File.class)) != null && (object2 = ((Method)object).invoke(null, file)) instanceof Boolean && ((Boolean)object2).booleanValue()) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean bl2 = bl = !NativeInvocationBridge.sharedInstance().isEnabled() || !NativeInvocationBridge.sharedInstance().showInFinder(file, fileBrowserName);
        if (bl) {
            object = new StringBuffer();
            ((StringBuffer)object).append("tell application \"");
            ((StringBuffer)object).append(PlatformManagerImpl.getFileBrowserName());
            ((StringBuffer)object).append("\"\n");
            ((StringBuffer)object).append("reveal (posix file \"");
            ((StringBuffer)object).append(file);
            ((StringBuffer)object).append("\" as alias)\n");
            ((StringBuffer)object).append("activate\n");
            ((StringBuffer)object).append("end tell\n");
            try {
                PlatformManagerImpl.performOSAScript((CharSequence)object);
            }
            catch (IOException iOException) {
                Logger.log(new LogAlert(false, 3, iOException.getMessage()));
            }
        }
    }

    public void showInTerminal(String string) {
        this.showInTerminal(new File(string));
    }

    public void showInTerminal(File file) {
        if (file.isFile()) {
            file = file.getParentFile();
        }
        if (file != null && file.isDirectory()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("tell application \"");
            stringBuffer.append("Terminal");
            stringBuffer.append("\" to do script \"cd ");
            stringBuffer.append(file.getAbsolutePath().replaceAll(" ", "\\ "));
            stringBuffer.append("\"");
            try {
                PlatformManagerImpl.performOSAScript(stringBuffer);
            }
            catch (IOException iOException) {
                Logger.log(new LogAlert(false, 3, iOException.getMessage()));
            }
        } else if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, 1, "Cannot find " + file.getName()));
        }
    }

    protected static String performOSAScript(CharSequence charSequence) throws IOException {
        return PlatformManagerImpl.performOSAScript(new CharSequence[]{charSequence});
    }

    protected static String performOSAScript(CharSequence[] charSequenceArray) throws IOException {
        long l = System.currentTimeMillis();
        Debug.outNoStack("Executing OSAScript: ");
        for (int i = 0; i < charSequenceArray.length; ++i) {
            Debug.outNoStack("\t" + charSequenceArray[i]);
        }
        String[] stringArray = new String[2 * charSequenceArray.length + 1];
        stringArray[0] = "osascript";
        for (int i = 0; i < charSequenceArray.length; ++i) {
            stringArray[i * 2 + 1] = "-e";
            stringArray[i * 2 + 2] = String.valueOf(charSequenceArray[i]);
        }
        Process process = PlatformManagerImpl.performRuntimeExec(stringArray);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String string = bufferedReader.readLine();
        bufferedReader.close();
        Debug.outNoStack("OSAScript Output: " + string);
        bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        String string2 = bufferedReader.readLine();
        bufferedReader.close();
        Debug.outNoStack("OSAScript Error (if any): " + string2);
        Debug.outNoStack(MessageFormat.format("OSAScript execution ended ({0}ms)", String.valueOf(System.currentTimeMillis() - l)));
        try {
            process.destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string2 != null) {
            throw new IOException(string2);
        }
        return string;
    }

    protected static String performOSAScript(File file) throws IOException {
        long l = System.currentTimeMillis();
        Debug.outNoStack("Executing OSAScript from file: " + file.getPath());
        Process process = PlatformManagerImpl.performRuntimeExec(new String[]{"osascript", file.getPath()});
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String string = bufferedReader.readLine();
        bufferedReader.close();
        Debug.outNoStack("OSAScript Output: " + string);
        bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        String string2 = bufferedReader.readLine();
        bufferedReader.close();
        Debug.outNoStack("OSAScript Error (if any): " + string2);
        Debug.outNoStack(MessageFormat.format("OSAScript execution ended ({0}ms)", String.valueOf(System.currentTimeMillis() - l)));
        try {
            process.destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string2 != null) {
            throw new IOException(string2);
        }
        return string;
    }

    protected static boolean compileOSAScript(CharSequence charSequence, File file) {
        return PlatformManagerImpl.compileOSAScript(new CharSequence[]{charSequence}, file);
    }

    protected static boolean compileOSAScript(CharSequence[] charSequenceArray, File file) {
        String string;
        long l = System.currentTimeMillis();
        Debug.outNoStack("Compiling OSAScript: " + file.getPath());
        for (int i = 0; i < charSequenceArray.length; ++i) {
            Debug.outNoStack("\t" + charSequenceArray[i]);
        }
        String[] stringArray = new String[2 * charSequenceArray.length + 3];
        stringArray[0] = "osacompile";
        for (int i = 0; i < charSequenceArray.length; ++i) {
            stringArray[i * 2 + 1] = "-e";
            stringArray[i * 2 + 2] = String.valueOf(charSequenceArray[i]);
        }
        stringArray[stringArray.length - 2] = "-o";
        stringArray[stringArray.length - 1] = file.getPath();
        try {
            Process process = PlatformManagerImpl.performRuntimeExec(stringArray);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            string = bufferedReader.readLine();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            Debug.outNoStack("OSACompile Execution Failed: " + iOException.getMessage());
            Debug.printStackTrace(iOException);
            return false;
        }
        Debug.outNoStack("OSACompile Error (if any): " + string);
        Debug.outNoStack(MessageFormat.format("OSACompile execution ended ({0}ms)", String.valueOf(System.currentTimeMillis() - l)));
        return string == null;
    }

    protected static Process performRuntimeExec(String[] stringArray) throws IOException {
        try {
            return Runtime.getRuntime().exec(stringArray);
        }
        catch (IOException iOException) {
            Logger.log(new LogAlert(false, iOException.getMessage(), iOException));
            throw iOException;
        }
    }

    private static String getFileBrowserName() {
        return fileBrowserName;
    }

    @Override
    public boolean testNativeAvailability(String string) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void traceRoute(InetAddress inetAddress, InetAddress inetAddress2, PlatformManagerPingCallback platformManagerPingCallback) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void ping(InetAddress inetAddress, InetAddress inetAddress2, PlatformManagerPingCallback platformManagerPingCallback) throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void addListener(PlatformManagerListener platformManagerListener) {
    }

    @Override
    public void removeListener(PlatformManagerListener platformManagerListener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter indentWriter) {
        indentWriter.println("PlatformManager: MacOSX");
        try {
            indentWriter.indent();
            if (OSXAccess.isLoaded()) {
                try {
                    indentWriter.println("Version " + this.getVersion());
                    indentWriter.println("User Data Dir: " + this.getLocation(1L));
                    indentWriter.println("User Doc Dir: " + this.getLocation(3L));
                }
                catch (PlatformManagerException platformManagerException) {}
            } else {
                indentWriter.println("Not loaded");
            }
            indentWriter.println("Computer Name: " + this.getComputerName());
        }
        finally {
            indentWriter.exdent();
        }
    }

    public String getAzComputerID() throws PlatformManagerException {
        throw new PlatformManagerException("Unsupported capability called on platform manager");
    }

    @Override
    public void requestUserAttention(int n, Object object) throws PlatformManagerException {
        if (n == 3) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("com.apple.eawt.Application");
            Method method = clazz.getMethod("getApplication", new Class[0]);
            Object object2 = method.invoke(null, new Object[0]);
            Method method2 = clazz.getMethod("requestUserAttention", Boolean.class);
            if (n == 1) {
                method2.invoke(object2, false);
            } else if (n == 2) {
                method2.invoke(object2, true);
            }
        }
        catch (Exception exception) {
            throw new PlatformManagerException("Failed to request user attention", exception);
        }
    }

    static {
        class_mon = new AEMonitor("PlatformManager");
        fileBrowserName = "Finder";
        PlatformManagerImpl.initializeSingleton();
    }
}

