/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local;

import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginState;
import org.gudy.azureus2.plugins.UnloadablePlugin;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.PluginInterfaceImpl;
import org.gudy.azureus2.pluginsimpl.local.installer.PluginInstallerImpl;

public class PluginStateImpl
implements PluginState {
    private PluginInterfaceImpl pi;
    private PluginInitializer initialiser;
    private boolean disabled;
    boolean operational;
    boolean failed;

    public PluginStateImpl(PluginInterfaceImpl pluginInterfaceImpl, PluginInitializer pluginInitializer) {
        this.pi = pluginInterfaceImpl;
        this.initialiser = pluginInitializer;
    }

    @Override
    public void setLoadedAtStartup(boolean bl) {
        String string = "PluginInfo." + this.pi.getPluginID() + ".enabled";
        COConfigurationManager.setParameter(string, bl);
    }

    @Override
    public boolean isLoadedAtStartup() {
        String string = "PluginInfo." + this.pi.getPluginID() + ".enabled";
        if (!COConfigurationManager.hasParameter(string, false)) {
            return true;
        }
        return COConfigurationManager.getBooleanParameter(string);
    }

    @Override
    public boolean hasFailed() {
        return this.failed;
    }

    @Override
    public void setDisabled(boolean bl) {
        this.disabled = bl;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public boolean isBuiltIn() {
        String string = this.pi.getPluginDirectoryName();
        if (string == null) {
            return PluginInitializer.isLoadingBuiltin();
        }
        return string.length() == 0;
    }

    @Override
    public boolean isMandatory() {
        String string = this.pi.getPluginProperties().getProperty("plugin.mandatory");
        return string != null && string.trim().toLowerCase().equals("true");
    }

    void setOperational(boolean bl, boolean bl2) {
        this.operational = bl;
        if (!bl2) {
            this.initialiser.fireOperational(this.pi, this.operational);
        }
    }

    @Override
    public boolean isOperational() {
        return this.operational;
    }

    @Override
    public boolean isShared() {
        String string = FileUtil.getApplicationFile("plugins").toString();
        String string2 = this.pi.getPluginDirectoryName();
        return string2.startsWith(string);
    }

    @Override
    public boolean isInitialisationComplete() {
        return this.initialiser.isInitialisationComplete();
    }

    @Override
    public void reload() throws PluginException {
        if (this.isUnloadable() || this.isOperational()) {
            this.unload(true);
        }
        this.initialiser.reloadPlugin(this.pi);
    }

    @Override
    public void uninstall() throws PluginException {
        PluginInstallerImpl.getSingleton(this.pi.getPluginManager()).uninstall(this.pi);
    }

    @Override
    public boolean isUnloaded() {
        return this.pi.class_loader == null;
    }

    @Override
    public void unload() throws PluginException {
        this.unload(false);
    }

    protected void unload(boolean bl) throws PluginException {
        if (!this.isUnloadable()) {
            throw new PluginException("Plugin isn't unloadable");
        }
        String string = this.pi.getPluginDirectoryName();
        if (string == null || string.length() == 0) {
            try {
                ((UnloadablePlugin)this.pi.getPlugin()).unload();
            }
            catch (Throwable throwable) {
                Debug.out("Plugin unload operation failed", throwable);
            }
            this.initialiser.unloadPlugin(this.pi);
        } else {
            ArrayList arrayList = new ArrayList(PluginInitializer.getPluginInterfaces());
            for (int i = 0; i < arrayList.size(); ++i) {
                PluginInterfaceImpl pluginInterfaceImpl = (PluginInterfaceImpl)arrayList.get(i);
                String string2 = pluginInterfaceImpl.getPluginDirectoryName();
                if (string2 == null || string2.length() == 0 || !string.equals(string2)) continue;
                try {
                    ((UnloadablePlugin)pluginInterfaceImpl.getPlugin()).unload();
                }
                catch (Throwable throwable) {
                    Debug.out("Plugin unload operation failed", throwable);
                }
                this.initialiser.unloadPlugin(pluginInterfaceImpl);
            }
        }
        for (int i = 0; i < this.pi.children.size(); ++i) {
            ((PluginStateImpl)((PluginInterface)this.pi.children.get(i)).getPluginState()).unload(bl);
        }
        this.setOperational(false, bl);
        this.pi.destroy();
    }

    @Override
    public boolean isUnloadable() {
        int n;
        String string = this.pi.getPluginDirectoryName();
        boolean bl = this.pi.getPluginProperties().getProperty("plugin.unload.disabled", "").equalsIgnoreCase("true");
        if (bl) {
            return false;
        }
        if (string == null || string.length() == 0) {
            return this.pi.getPlugin() instanceof UnloadablePlugin;
        }
        List list = PluginInitializer.getPluginInterfaces();
        for (n = 0; n < list.size(); ++n) {
            PluginInterface pluginInterface = (PluginInterface)list.get(n);
            String string2 = pluginInterface.getPluginDirectoryName();
            if (string2 == null || string2.length() == 0 || !string.equals(string2) || pluginInterface.getPlugin() instanceof UnloadablePlugin) continue;
            return false;
        }
        for (n = 0; n < this.pi.children.size(); ++n) {
            if (((PluginInterface)this.pi.children.get(n)).getPluginState().isUnloadable()) continue;
            return false;
        }
        return true;
    }
}

