/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.clientid;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.ThreadPoolTask;
import org.gudy.azureus2.plugins.clientid.ClientIDException;
import org.gudy.azureus2.plugins.clientid.ClientIDGenerator;
import org.gudy.azureus2.plugins.clientid.ClientIDManager;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;

public class ClientIDManagerImpl
implements ClientIDManager {
    private static final LogIDs LOGID = LogIDs.PLUGIN;
    protected static ClientIDManagerImpl singleton = new ClientIDManagerImpl();
    protected static final char CR = '\r';
    protected static final char FF = '\n';
    protected static final String NL = "\r\n";
    private ClientIDGenerator generator_user_accessor;
    private boolean use_filter;
    private boolean filter_override;
    private ThreadPool thread_pool;
    private int filter_port;

    public static ClientIDManagerImpl getSingleton() {
        return singleton;
    }

    public void setGenerator(ClientIDGenerator clientIDGenerator, boolean bl) {
        Object object;
        String string;
        String string2;
        this.checkGenerator(clientIDGenerator);
        this.generator_user_accessor = clientIDGenerator;
        this.use_filter = bl;
        if (!this.use_filter) {
            string2 = System.getProperty("http.proxyHost");
            string = System.getProperty("socksProxyHost");
            InetAddress inetAddress = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress();
            if (!(string2 != null && string2.trim().length() != 0 || string != null && string.trim().length() != 0 || inetAddress == null || inetAddress.isAnyLocalAddress())) {
                int n = 0;
                try {
                    object = NetworkInterface.getNetworkInterfaces();
                    while (object.hasMoreElements()) {
                        NetworkInterface networkInterface2 = object.nextElement();
                        Enumeration<InetAddress> enumeration = networkInterface2.getInetAddresses();
                        while (enumeration.hasMoreElements()) {
                            InetAddress inetAddress2 = enumeration.nextElement();
                            if (inetAddress2.isLoopbackAddress()) continue;
                            ++n;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Logger.log(new LogEvent(LOGID, "", throwable));
                }
                if (n > 1) {
                    this.filter_override = true;
                    this.use_filter = true;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "ClientIDManager: overriding filter option to support local bind IP"));
                    }
                }
            }
        }
        if (this.use_filter) {
            try {
                this.thread_pool = new ThreadPool("ClientIDManager", 32);
                string2 = System.getProperty("sun.net.client.defaultConnectTimeout");
                string = System.getProperty("sun.net.client.defaultReadTimeout");
                int n = Integer.parseInt(string2) + Integer.parseInt(string);
                this.thread_pool.setExecutionLimit(n);
                final ServerSocket serverSocket = new ServerSocket(0, 1024, InetAddress.getByName("127.0.0.1"));
                this.filter_port = serverSocket.getLocalPort();
                serverSocket.setReuseAddress(true);
                object = new AEThread("ClientIDManager::filterloop"){

                    @Override
                    public void runSupport() {
                        long l = 0L;
                        long l2 = 0L;
                        while (true) {
                            try {
                                while (true) {
                                    Socket socket = serverSocket.accept();
                                    ++l;
                                    ClientIDManagerImpl.this.thread_pool.run(new httpFilter(socket));
                                }
                            }
                            catch (Throwable throwable) {
                                ++l2;
                                if (!Logger.isEnabled()) continue;
                                Logger.log(new LogEvent(LOGID, "ClientIDManager: listener failed on port " + ClientIDManagerImpl.this.filter_port, throwable));
                                if (l2 <= 100L || l != 0L) continue;
                                Logger.logTextResource(new LogAlert(false, 3, "Network.alert.acceptfail"), new String[]{"" + ClientIDManagerImpl.this.filter_port, "TCP"});
                                ClientIDManagerImpl.this.use_filter = false;
                                return;
                            }
                            break;
                        }
                    }
                };
                ((Thread)object).setDaemon(true);
                ((Thread)object).start();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "ClientIDManager: listener established on port " + this.filter_port));
                }
            }
            catch (Throwable throwable) {
                Logger.logTextResource(new LogAlert(false, 3, "Tracker.alert.listenfail"), new String[]{"" + this.filter_port});
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "ClientIDManager: listener failed on port " + this.filter_port, throwable));
                }
                this.use_filter = false;
            }
        }
    }

    @Override
    public ClientIDGenerator getGenerator() {
        this.checkGenerator(this.generator_user_accessor);
        return this.generator_user_accessor;
    }

    protected void checkGenerator(ClientIDGenerator clientIDGenerator) {
        ClassLoader classLoader = clientIDGenerator.getClass().getClassLoader();
        if (classLoader != null && classLoader != ClientIDManager.class.getClassLoader()) {
            Debug.out("Generator isn't trusted - " + clientIDGenerator);
            throw new RuntimeException("Generator isn't trusted");
        }
    }

    public byte[] generatePeerID(TOTorrent tOTorrent, boolean bl) throws ClientIDException {
        return this.getGenerator().generatePeerID(new TorrentImpl(tOTorrent), bl);
    }

    public void generateHTTPProperties(Properties properties) throws ClientIDException {
        if (this.use_filter) {
            URL uRL = (URL)properties.get("URL");
            if (!uRL.getProtocol().toLowerCase().equals("http")) {
                Logger.log(new LogAlert(false, 3, "ClientIDManager only supports filtering of http, not https"));
                return;
            }
            try {
                String string = uRL.toString();
                String string2 = uRL.getHost();
                int n = uRL.getPort();
                if (n == -1) {
                    n = uRL.getDefaultPort();
                }
                int n2 = string.indexOf(string2);
                String string3 = string.substring(0, n2) + "127.0.0.1:" + this.filter_port;
                String string4 = string.substring(n2 + string2.length());
                if (string4.charAt(0) == ':') {
                    string4 = string4.substring(("" + n).length() + 1);
                }
                int n3 = string4.indexOf(63);
                string3 = string3 + string4.substring(0, n3 + 1) + "cid=" + string2 + ":" + n + "&" + string4.substring(n3 + 1);
                properties.put("URL", new URL(string3));
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        } else {
            this.getGenerator().generateHTTPProperties(properties);
        }
    }

    static /* synthetic */ boolean access$400(ClientIDManagerImpl clientIDManagerImpl) {
        return clientIDManagerImpl.filter_override;
    }

    protected class httpFilter
    extends ThreadPoolTask {
        private Socket socket;

        protected httpFilter(Socket socket) {
            this.socket = socket;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void runSupport() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void interruptTask() {
            try {
                this.socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

