/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.launch;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.plugins.LaunchablePlugin;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.pluginsimpl.PluginUtils;
import org.gudy.azureus2.pluginsimpl.local.launch.PluginSingleInstanceHandler;

public class PluginLauncherImpl {
    private static Map preloaded_plugins = new HashMap();

    private static void main(String[] stringArray) {
        PluginLauncherImpl.launch(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void launch(String[] stringArray) {
        COConfigurationManager.preInitialise();
        final LoggerChannelListener loggerChannelListener = new LoggerChannelListener(){

            @Override
            public void messageLogged(int n, String string) {
                this.log(string, false);
            }

            @Override
            public void messageLogged(String string, Throwable throwable) {
                this.log(string, true);
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                throwable.printStackTrace(printWriter);
                printWriter.flush();
                this.log(stringWriter.toString(), true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected synchronized void log(String string, boolean bl) {
                File file = PluginLauncherImpl.getApplicationFile("launch.log");
                PrintWriter printWriter = null;
                try {
                    printWriter = new PrintWriter(new FileWriter(file, true));
                    if (string.endsWith("\n")) {
                        if (bl) {
                            System.err.print("PluginLauncher: " + string);
                        }
                        printWriter.print(string);
                    } else {
                        if (bl) {
                            System.err.println("PluginLauncher: " + string);
                        }
                        printWriter.println(string);
                    }
                }
                catch (Throwable throwable) {
                }
                finally {
                    if (printWriter != null) {
                        printWriter.close();
                    }
                }
            }
        };
        LaunchablePlugin[] launchablePluginArray = PluginLauncherImpl.findLaunchablePlugins(loggerChannelListener);
        if (launchablePluginArray.length == 0) {
            loggerChannelListener.messageLogged(3, "No launchable plugins found");
            return;
        }
        if (launchablePluginArray.length > 1) {
            loggerChannelListener.messageLogged(3, "Multiple launchable plugins found, running first");
        }
        try {
            SystemProperties.setApplicationEntryPoint("org.gudy.azureus2.plugins.PluginLauncher");
            launchablePluginArray[0].setDefaults(stringArray);
            if (PluginSingleInstanceHandler.process(loggerChannelListener, stringArray)) {
                return;
            }
            Thread thread = new Thread("PluginLauncher"){

                @Override
                public void run() {
                    try {
                        Thread.sleep(500L);
                        AzureusCore azureusCore = AzureusCoreFactory.create();
                        azureusCore.start();
                    }
                    catch (Throwable throwable) {
                        loggerChannelListener.messageLogged("PluginLauncher: launch fails", throwable);
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
            boolean bl = false;
            boolean bl2 = false;
            try {
                bl = launchablePluginArray[0].process();
                bl2 = true;
            }
            finally {
                block15: {
                    try {
                        if (bl) {
                            AzureusCoreFactory.getSingleton().restart();
                        } else {
                            AzureusCoreFactory.getSingleton().stop();
                        }
                    }
                    catch (Throwable throwable) {
                        if (!bl2) break block15;
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            loggerChannelListener.messageLogged("PluginLauncher: launch fails", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LaunchablePlugin[] findLaunchablePlugins(LoggerChannelListener loggerChannelListener) {
        ArrayList<Plugin> arrayList = new ArrayList<Plugin>();
        File file = PluginLauncherImpl.getApplicationFile("plugins");
        if (!file.exists() && file.isDirectory()) {
            loggerChannelListener.messageLogged(3, "Application dir '" + file + "' not found");
            return new LaunchablePlugin[0];
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            loggerChannelListener.messageLogged(3, "Application dir '" + file + "' empty");
            return new LaunchablePlugin[0];
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (!file2.isDirectory()) continue;
            try {
                Plugin plugin;
                Serializable serializable;
                Object object;
                ClassLoader classLoader;
                ClassLoader classLoader2 = classLoader = PluginLauncherImpl.class.getClassLoader();
                File[] fileArray2 = file2.listFiles();
                if (fileArray2 == null || fileArray2.length == 0) continue;
                String[] stringArray = new String[]{null};
                String[] stringArray2 = new String[]{null};
                fileArray2 = PluginLauncherImpl.getHighestJarVersions(fileArray2, stringArray, stringArray2, true);
                for (int j = 0; j < fileArray2.length; ++j) {
                    classLoader = PluginLauncherImpl.addFileToClassPath(classLoader2, classLoader, fileArray2[j]);
                }
                Properties properties = new Properties();
                File file3 = new File(file2, "plugin.properties");
                if (file3.exists()) {
                    object = null;
                    try {
                        object = new FileInputStream(file3);
                        properties.load((InputStream)object);
                    }
                    finally {
                        if (object != null) {
                            ((FileInputStream)object).close();
                        }
                    }
                } else if (classLoader instanceof URLClassLoader && (serializable = ((URLClassLoader)(object = (URLClassLoader)classLoader)).findResource("plugin.properties")) != null) {
                    properties.load(((URL)serializable).openStream());
                }
                if ((object = (String)properties.get("plugin.class")) == null || ((String)object).indexOf(59) != -1 || !((plugin = (Plugin)((Class)(serializable = classLoader.loadClass((String)object))).newInstance()) instanceof LaunchablePlugin)) continue;
                preloaded_plugins.put(object, plugin);
                arrayList.add(plugin);
                continue;
            }
            catch (Throwable throwable) {
                loggerChannelListener.messageLogged("Load of plugin in '" + file2 + "' fails", throwable);
            }
        }
        LaunchablePlugin[] launchablePluginArray = new LaunchablePlugin[arrayList.size()];
        arrayList.toArray(launchablePluginArray);
        return launchablePluginArray;
    }

    public static Plugin getPreloadedPlugin(String string) {
        return (Plugin)preloaded_plugins.get(string);
    }

    private static File getApplicationFile(String string) {
        String string2 = SystemProperties.getApplicationPath();
        if (Constants.isOSX) {
            string2 = string2 + "/" + SystemProperties.getApplicationName() + ".app/Contents/";
        }
        return new File(string2, string);
    }

    public static File[] getHighestJarVersions(File[] fileArray, String[] stringArray, String[] stringArray2, boolean bl) {
        String string;
        Object object;
        int n;
        String string2;
        Object object22;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        for (int i = 0; i < fileArray.length; ++i) {
            object22 = fileArray[i];
            string2 = object22.getName().toLowerCase();
            if (!string2.endsWith(".jar")) continue;
            int n2 = string2.lastIndexOf("_cvs");
            n = n2 <= 0 ? string2.lastIndexOf("_") : string2.lastIndexOf("_", n2 - 1);
            if (n == -1 || n == string2.length() - 1 || !Character.isDigit(string2.charAt(n + 1))) {
                arrayList.add(object22);
                continue;
            }
            object = string2.substring(0, n);
            string = string2.substring(n + 1, n2 <= 0 ? string2.length() - 4 : n2);
            String string3 = (String)hashMap.get(object);
            if (string3 == null) {
                hashMap.put(object, string);
                continue;
            }
            if (PluginUtils.comparePluginVersions(string3, string) >= 0) continue;
            hashMap.put(object, string);
        }
        if (hashMap.size() > 0 && bl) {
            arrayList.clear();
        }
        if (hashMap.containsKey("azrating")) {
            hashMap.remove("rating");
        }
        block1: for (Object object22 : hashMap.keySet()) {
            string2 = (String)hashMap.get(object22);
            String string4 = (String)object22 + "_" + string2;
            stringArray[0] = string2;
            stringArray2[0] = object22;
            for (n = 0; n < fileArray.length; ++n) {
                object = fileArray[n];
                string = ((File)object).getName().toLowerCase();
                if (!string.equals(string4 + ".jar") && !string.equals(string4 + "_cvs.jar")) continue;
                arrayList.add(object);
                continue block1;
            }
        }
        object22 = new File[arrayList.size()];
        arrayList.toArray((T[])object22);
        return object22;
    }

    public static ClassLoader addFileToClassPath(ClassLoader classLoader, ClassLoader classLoader2, File file) {
        if (file.exists() && !file.isDirectory() && file.getName().endsWith(".jar")) {
            try {
                if (classLoader2 instanceof URLClassLoader) {
                    URL[] uRLArray = ((URLClassLoader)classLoader2).getURLs();
                    URL[] uRLArray2 = new URL[uRLArray.length + 1];
                    System.arraycopy(uRLArray, 0, uRLArray2, 1, uRLArray.length);
                    uRLArray2[0] = file.toURL();
                    classLoader2 = new URLClassLoader(uRLArray2, classLoader2 == classLoader ? classLoader2 : classLoader2.getParent());
                } else {
                    classLoader2 = new URLClassLoader(new URL[]{file.toURL()}, classLoader2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return classLoader2;
    }
}

