/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.sharing;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareItem;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareResourceImpl;

public class ShareItemImpl
implements ShareItem {
    protected ShareResourceImpl resource;
    protected byte[] fingerprint;
    protected Torrent torrent;
    protected String torrent_save_location;

    protected ShareItemImpl(ShareResourceImpl shareResourceImpl, byte[] byArray, Torrent torrent) throws ShareException {
        this.resource = shareResourceImpl;
        this.fingerprint = byArray;
        this.torrent = torrent;
        this.writeTorrent();
    }

    protected ShareItemImpl(ShareResourceImpl shareResourceImpl, byte[] byArray, String string) throws ShareException {
        this.resource = shareResourceImpl;
        this.fingerprint = byArray;
        this.torrent_save_location = string;
    }

    @Override
    public Torrent getTorrent() throws ShareException {
        if (this.torrent == null) {
            this.resource.readTorrent(this);
        }
        return this.torrent;
    }

    protected void writeTorrent() throws ShareException {
        if (this.torrent_save_location == null) {
            this.torrent_save_location = this.resource.getNewTorrentLocation();
        }
        this.resource.writeTorrent(this);
    }

    protected void setTorrent(Torrent torrent) {
        this.torrent = torrent;
    }

    @Override
    public File getTorrentFile() {
        return this.resource.getTorrentFile(this);
    }

    protected String getTorrentLocation() {
        return this.torrent_save_location;
    }

    public byte[] getFingerPrint() {
        return this.fingerprint;
    }

    protected void delete() {
        this.resource.deleteTorrent(this);
    }

    protected void serialiseItem(Map map) {
        map.put("ihash", this.fingerprint);
        try {
            map.put("ifile", this.torrent_save_location.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Debug.printStackTrace(unsupportedEncodingException);
        }
    }

    protected static ShareItemImpl deserialiseItem(ShareResourceImpl shareResourceImpl, Map map) throws ShareException {
        try {
            byte[] byArray = (byte[])map.get("ihash");
            String string = new String((byte[])map.get("ifile"), "UTF8");
            return new ShareItemImpl(shareResourceImpl, byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ShareException("internal error", unsupportedEncodingException);
        }
    }
}

