/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.config;

import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.plugins.ui.config.ColorParameter;
import org.gudy.azureus2.pluginsimpl.local.PluginConfigImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterImpl;

public class ColorParameterImpl
extends ParameterImpl
implements ColorParameter {
    private int r;
    private int g;
    private int b;
    private final int orig_r;
    private final int orig_g;
    private final int orig_b;

    public ColorParameterImpl(PluginConfigImpl pluginConfigImpl, String string, String string2, int n, int n2, int n3) {
        super(pluginConfigImpl, string, string2);
        pluginConfigImpl.notifyRGBParamExists(this.getKey());
        COConfigurationManager.setIntDefault(this.getKey() + ".red", this.r);
        COConfigurationManager.setIntDefault(this.getKey() + ".green", this.g);
        COConfigurationManager.setIntDefault(this.getKey() + ".blue", this.b);
        COConfigurationManager.setBooleanDefault(this.getKey() + ".override", false);
        this.orig_r = this.r = n;
        this.orig_g = this.g = n2;
        this.orig_b = this.b = n3;
    }

    @Override
    public int getRedValue() {
        return this.r;
    }

    @Override
    public int getGreenValue() {
        return this.g;
    }

    @Override
    public int getBlueValue() {
        return this.b;
    }

    public void reloadParamDataFromConfig(boolean bl) {
        int[] nArray = this.config.getUnsafeColorParameter(this.getKey());
        this.r = nArray[0];
        this.g = nArray[1];
        this.b = nArray[2];
        this.config.setUnsafeBooleanParameter(this.getKey() + ".override", bl);
    }

    @Override
    public void setRGBValue(int n, int n2, int n3) {
        this.r = n;
        this.g = n2;
        this.b = n3;
        this.config.setUnsafeColorParameter(this.getKey(), new int[]{n, n2, n3}, true);
    }

    public void resetToDefault() {
        this.config.setUnsafeColorParameter(this.getKey(), new int[]{this.orig_r, this.orig_g, this.orig_b}, false);
    }

    public boolean isOverridden() {
        return this.config.getUnsafeBooleanParameter(this.getKey() + ".override");
    }
}

