/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote;

import java.util.Properties;
import java.util.Random;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginEventListener;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.PluginState;
import org.gudy.azureus2.plugins.PluginView;
import org.gudy.azureus2.plugins.clientid.ClientIDManager;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.dht.mainline.MainlineDHTManager;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.ipc.IPCInterface;
import org.gudy.azureus2.plugins.ipfilter.IPFilter;
import org.gudy.azureus2.plugins.logging.Logger;
import org.gudy.azureus2.plugins.messaging.MessageManager;
import org.gudy.azureus2.plugins.network.ConnectionManager;
import org.gudy.azureus2.plugins.platform.PlatformManager;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.plugins.torrent.TorrentManager;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.ConfigSection;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.PluginConfigUIFactory;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.utils.ShortCuts;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPPluginConfig;
import org.gudy.azureus2.pluginsimpl.remote.RPReply;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;
import org.gudy.azureus2.pluginsimpl.remote.download.RPDownloadManager;
import org.gudy.azureus2.pluginsimpl.remote.ipfilter.RPIPFilter;
import org.gudy.azureus2.pluginsimpl.remote.torrent.RPTorrentManager;
import org.gudy.azureus2.pluginsimpl.remote.tracker.RPTracker;
import org.gudy.azureus2.pluginsimpl.remote.utils.RPShortCuts;

public class RPPluginInterface
extends RPObject
implements PluginInterface {
    protected static long connection_id_next = new Random().nextLong();
    protected transient PluginInterface delegate;
    protected transient long request_id_next;
    public String azureus_name = "Azureus";
    public String azureus_version = "4.5.0.4";
    public long _connection_id;

    public static RPPluginInterface create(PluginInterface pluginInterface) {
        RPPluginInterface rPPluginInterface = (RPPluginInterface)RPPluginInterface._lookupLocal(pluginInterface);
        if (rPPluginInterface == null) {
            rPPluginInterface = new RPPluginInterface(pluginInterface);
        }
        return rPPluginInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RPPluginInterface(PluginInterface pluginInterface) {
        super(pluginInterface);
        Class<RPPluginInterface> clazz = RPPluginInterface.class;
        synchronized (RPPluginInterface.class) {
            this._connection_id = connection_id_next++;
            if (this._connection_id == 0L) {
                this._connection_id = connection_id_next++;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected long _getConectionId() {
        return this._connection_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long _getNextRequestId() {
        RPPluginInterface rPPluginInterface = this;
        synchronized (rPPluginInterface) {
            return this.request_id_next++;
        }
    }

    @Override
    protected void _setDelegate(Object object) {
        this.delegate = (PluginInterface)object;
    }

    @Override
    public Object _setLocal() throws RPException {
        return this._fixupLocal();
    }

    @Override
    public RPReply _process(RPRequest rPRequest) {
        String string = rPRequest.getMethod();
        if (string.equals("getPluginProperties")) {
            Properties properties = new Properties();
            Properties properties2 = this.delegate.getPluginProperties();
            for (Object object : properties2.keySet()) {
                properties.put(object, properties2.get(object));
            }
            return new RPReply(properties);
        }
        if (string.equals("getDownloadManager")) {
            return new RPReply(RPDownloadManager.create(this.delegate.getDownloadManager()));
        }
        if (string.equals("getTorrentManager")) {
            return new RPReply(RPTorrentManager.create(this.delegate.getTorrentManager()));
        }
        if (string.equals("getPluginconfig")) {
            return new RPReply(RPPluginConfig.create(this.delegate.getPluginconfig()));
        }
        if (string.equals("getIPFilter")) {
            return new RPReply(RPIPFilter.create(this.delegate.getIPFilter()));
        }
        if (string.equals("getShortCuts")) {
            return new RPReply(RPShortCuts.create(this.delegate.getShortCuts()));
        }
        if (string.equals("getTracker")) {
            return new RPReply(RPTracker.create(this.delegate.getTracker()));
        }
        throw new RPException("Unknown method: " + string);
    }

    @Override
    public PluginManager getPluginManager() {
        this.notSupported();
        return null;
    }

    @Override
    public Plugin getPlugin() {
        this.notSupported();
        return null;
    }

    @Override
    public String getAzureusName() {
        return this.azureus_name;
    }

    @Override
    public String getAzureusVersion() {
        return this.azureus_version;
    }

    @Override
    public String getApplicationName() {
        return Constants.APP_NAME;
    }

    @Override
    public void addView(PluginView pluginView) {
        this.notSupported();
    }

    @Override
    public void addConfigUIParameters(Parameter[] parameterArray, String string) {
        this.notSupported();
    }

    @Override
    public void addConfigSection(ConfigSection configSection) {
        this.notSupported();
    }

    @Override
    public void removeConfigSection(ConfigSection configSection) {
        this.notSupported();
    }

    @Override
    public Tracker getTracker() {
        RPTracker rPTracker = (RPTracker)this._dispatcher.dispatch(new RPRequest(this, "getTracker", null)).getResponse();
        rPTracker._setRemote(this._dispatcher);
        return rPTracker;
    }

    @Override
    public Logger getLogger() {
        this.notSupported();
        return null;
    }

    @Override
    public IPFilter getIPFilter() {
        RPIPFilter rPIPFilter = (RPIPFilter)this._dispatcher.dispatch(new RPRequest(this, "getIPFilter", null)).getResponse();
        rPIPFilter._setRemote(this._dispatcher);
        return rPIPFilter;
    }

    @Override
    public DownloadManager getDownloadManager() {
        RPDownloadManager rPDownloadManager = (RPDownloadManager)this._dispatcher.dispatch(new RPRequest(this, "getDownloadManager", null)).getResponse();
        rPDownloadManager._setRemote(this._dispatcher);
        return rPDownloadManager;
    }

    @Override
    public ShareManager getShareManager() throws ShareException {
        this.notSupported();
        return null;
    }

    @Override
    public Utilities getUtilities() {
        this.notSupported();
        return null;
    }

    @Override
    public ShortCuts getShortCuts() {
        RPShortCuts rPShortCuts = (RPShortCuts)this._dispatcher.dispatch(new RPRequest(this, "getShortCuts", null)).getResponse();
        rPShortCuts._setRemote(this._dispatcher);
        return rPShortCuts;
    }

    @Override
    public UIManager getUIManager() {
        this.notSupported();
        return null;
    }

    @Override
    public TorrentManager getTorrentManager() {
        RPTorrentManager rPTorrentManager = (RPTorrentManager)this._dispatcher.dispatch(new RPRequest(this, "getTorrentManager", null)).getResponse();
        rPTorrentManager._setRemote(this._dispatcher);
        return rPTorrentManager;
    }

    @Override
    public void openTorrentFile(String string) {
        this.notSupported();
    }

    @Override
    public void openTorrentURL(String string) {
        this.notSupported();
    }

    @Override
    public Properties getPluginProperties() {
        return (Properties)this._dispatcher.dispatch(new RPRequest(this, "getPluginProperties", null)).getResponse();
    }

    @Override
    public String getPluginDirectoryName() {
        this.notSupported();
        return null;
    }

    @Override
    public String getPerUserPluginDirectoryName() {
        this.notSupported();
        return null;
    }

    @Override
    public boolean isShared() {
        this.notSupported();
        return false;
    }

    @Override
    public String getPluginName() {
        this.notSupported();
        return null;
    }

    @Override
    public String getPluginID() {
        this.notSupported();
        return null;
    }

    @Override
    public boolean isMandatory() {
        this.notSupported();
        return false;
    }

    @Override
    public boolean isBuiltIn() {
        this.notSupported();
        return false;
    }

    public boolean isSigned() {
        this.notSupported();
        return false;
    }

    @Override
    public boolean isOperational() {
        this.notSupported();
        return false;
    }

    @Override
    public void setDisabled(boolean bl) {
        this.notSupported();
    }

    @Override
    public boolean isDisabled() {
        this.notSupported();
        return false;
    }

    @Override
    public String getPluginVersion() {
        this.notSupported();
        return null;
    }

    @Override
    public PluginConfig getPluginconfig() {
        RPPluginConfig rPPluginConfig = (RPPluginConfig)this._dispatcher.dispatch(new RPRequest(this, "getPluginconfig", null)).getResponse();
        rPPluginConfig._setRemote(this._dispatcher);
        return rPPluginConfig;
    }

    @Override
    public PluginConfigUIFactory getPluginConfigUIFactory() {
        this.notSupported();
        return null;
    }

    @Override
    public ClassLoader getPluginClassLoader() {
        this.notSupported();
        return null;
    }

    @Override
    public PluginInterface getLocalPluginInterface(Class clazz, String string) {
        this.notSupported();
        return null;
    }

    @Override
    public IPCInterface getIPC() {
        this.notSupported();
        return null;
    }

    @Override
    public UpdateManager getUpdateManager() {
        this.notSupported();
        return null;
    }

    @Override
    public boolean isUnloadable() {
        this.notSupported();
        return false;
    }

    @Override
    public void unload() throws PluginException {
        this.notSupported();
    }

    @Override
    public void reload() throws PluginException {
        this.notSupported();
    }

    @Override
    public void uninstall() throws PluginException {
        this.notSupported();
    }

    @Override
    public boolean isInitialisationThread() {
        this.notSupported();
        return false;
    }

    @Override
    public ClientIDManager getClientIDManager() {
        this.notSupported();
        return null;
    }

    @Override
    public ConnectionManager getConnectionManager() {
        this.notSupported();
        return null;
    }

    @Override
    public MessageManager getMessageManager() {
        this.notSupported();
        return null;
    }

    @Override
    public DistributedDatabase getDistributedDatabase() {
        this.notSupported();
        return null;
    }

    @Override
    public PlatformManager getPlatformManager() {
        this.notSupported();
        return null;
    }

    @Override
    public void addListener(PluginListener pluginListener) {
        this.notSupported();
    }

    @Override
    public void removeListener(PluginListener pluginListener) {
        this.notSupported();
    }

    @Override
    public void firePluginEvent(PluginEvent pluginEvent) {
        this.notSupported();
    }

    @Override
    public void addEventListener(PluginEventListener pluginEventListener) {
        this.notSupported();
    }

    @Override
    public void removeEventListener(PluginEventListener pluginEventListener) {
        this.notSupported();
    }

    @Override
    public ConfigSection[] getConfigSections() {
        return null;
    }

    @Override
    public MainlineDHTManager getMainlineDHTManager() {
        this.notSupported();
        return null;
    }

    @Override
    public PluginState getPluginState() {
        this.notSupported();
        return null;
    }
}

