/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote.download;

import java.io.File;
import java.util.Map;
import org.gudy.azureus2.plugins.disk.DiskManager;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadActivationEvent;
import org.gudy.azureus2.plugins.download.DownloadActivationListener;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadAttributeListener;
import org.gudy.azureus2.plugins.download.DownloadCompletionListener;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.download.DownloadPropertyListener;
import org.gudy.azureus2.plugins.download.DownloadRemovalVetoException;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadStats;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.download.DownloadWillBeRemovedListener;
import org.gudy.azureus2.plugins.download.savelocation.SaveLocationChange;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPReply;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;
import org.gudy.azureus2.pluginsimpl.remote.RPRequestDispatcher;
import org.gudy.azureus2.pluginsimpl.remote.disk.RPDiskManagerFileInfo;
import org.gudy.azureus2.pluginsimpl.remote.download.RPDownloadAnnounceResult;
import org.gudy.azureus2.pluginsimpl.remote.download.RPDownloadScrapeResult;
import org.gudy.azureus2.pluginsimpl.remote.download.RPDownloadStats;
import org.gudy.azureus2.pluginsimpl.remote.torrent.RPTorrent;

public class RPDownload
extends RPObject
implements Download {
    protected transient Download delegate;
    public RPTorrent torrent;
    public RPDownloadStats stats;
    public RPDownloadAnnounceResult announce_result;
    public RPDownloadScrapeResult scrape_result;
    public int position;
    public boolean force_start;

    public static RPDownload create(Download download) {
        RPDownload rPDownload = (RPDownload)RPDownload._lookupLocal(download);
        if (rPDownload == null) {
            rPDownload = new RPDownload(download);
        }
        return rPDownload;
    }

    protected RPDownload(Download download) {
        super(download);
        if (this.delegate.getTorrent() != null) {
            this.torrent = (RPTorrent)RPDownload._lookupLocal(this.delegate.getTorrent());
            if (this.torrent == null) {
                this.torrent = RPTorrent.create(this.delegate.getTorrent());
            }
        }
        this.stats = (RPDownloadStats)RPDownload._lookupLocal(this.delegate.getStats());
        if (this.stats == null) {
            this.stats = RPDownloadStats.create(this.delegate.getStats());
        }
        this.announce_result = (RPDownloadAnnounceResult)RPDownload._lookupLocal(this.delegate.getLastAnnounceResult());
        if (this.announce_result == null) {
            this.announce_result = RPDownloadAnnounceResult.create(this.delegate.getLastAnnounceResult());
        }
        this.scrape_result = (RPDownloadScrapeResult)RPDownload._lookupLocal(this.delegate.getLastScrapeResult());
        if (this.scrape_result == null) {
            this.scrape_result = RPDownloadScrapeResult.create(this.delegate.getLastScrapeResult());
        }
    }

    @Override
    protected void _setDelegate(Object object) {
        this.delegate = (Download)object;
        this.position = this.delegate.getPosition();
        this.force_start = this.delegate.isForceStart();
    }

    @Override
    public Object _setLocal() throws RPException {
        Object object = this._fixupLocal();
        if (this.torrent != null) {
            this.torrent._setLocal();
        }
        this.stats._setLocal();
        this.announce_result._setLocal();
        this.scrape_result._setLocal();
        return object;
    }

    @Override
    public void _setRemote(RPRequestDispatcher rPRequestDispatcher) {
        super._setRemote(rPRequestDispatcher);
        if (this.torrent != null) {
            this.torrent._setRemote(rPRequestDispatcher);
        }
        this.stats._setRemote(rPRequestDispatcher);
        this.announce_result._setRemote(rPRequestDispatcher);
        this.scrape_result._setRemote(rPRequestDispatcher);
    }

    @Override
    public RPReply _process(RPRequest rPRequest) {
        String string = rPRequest.getMethod();
        if (string.equals("initialize")) {
            try {
                this.delegate.initialize();
            }
            catch (DownloadException downloadException) {
                return new RPReply(downloadException);
            }
            return null;
        }
        if (string.equals("start")) {
            try {
                this.delegate.start();
            }
            catch (DownloadException downloadException) {
                return new RPReply(downloadException);
            }
            return null;
        }
        if (string.equals("restart")) {
            try {
                this.delegate.restart();
            }
            catch (DownloadException downloadException) {
                return new RPReply(downloadException);
            }
            return null;
        }
        if (string.equals("stop")) {
            try {
                this.delegate.stop();
            }
            catch (DownloadException downloadException) {
                return new RPReply(downloadException);
            }
            return null;
        }
        if (string.equals("remove")) {
            try {
                this.delegate.remove();
            }
            catch (Throwable throwable) {
                return new RPReply(throwable);
            }
            return null;
        }
        if (string.equals("setForceStart[boolean]")) {
            boolean bl = (Boolean)rPRequest.getParams()[0];
            this.delegate.setForceStart(bl);
            return null;
        }
        if (string.equals("setPosition[int]")) {
            int n = (Integer)rPRequest.getParams()[0];
            this.delegate.setPosition(n);
            return null;
        }
        if (string.equals("moveUp")) {
            this.delegate.moveUp();
            return null;
        }
        if (string.equals("moveDown")) {
            this.delegate.moveDown();
            return null;
        }
        if (string.equals("moveTo[int]")) {
            int n = (Integer)rPRequest.getParams()[0];
            this.delegate.setPosition(n);
            return null;
        }
        if (string.equals("setPriority[int]")) {
            this.delegate.setPriority((Integer)rPRequest.getParams()[0]);
            return null;
        }
        if (string.equals("requestTrackerAnnounce")) {
            this.delegate.requestTrackerAnnounce();
            return null;
        }
        if (string.equals("getDiskManagerFileInfo")) {
            DiskManagerFileInfo[] diskManagerFileInfoArray = this.delegate.getDiskManagerFileInfo();
            RPDiskManagerFileInfo[] rPDiskManagerFileInfoArray = new RPDiskManagerFileInfo[diskManagerFileInfoArray.length];
            for (int i = 0; i < rPDiskManagerFileInfoArray.length; ++i) {
                rPDiskManagerFileInfoArray[i] = RPDiskManagerFileInfo.create(diskManagerFileInfoArray[i]);
            }
            return new RPReply(rPDiskManagerFileInfoArray);
        }
        throw new RPException("Unknown method: " + string);
    }

    @Override
    public int getState() {
        this.notSupported();
        return 0;
    }

    @Override
    public int getSubState() {
        this.notSupported();
        return 0;
    }

    @Override
    public String getErrorStateDetails() {
        this.notSupported();
        return null;
    }

    @Override
    public boolean getFlag(long l) {
        this.notSupported();
        return false;
    }

    @Override
    public long getFlags() {
        this.notSupported();
        return 0L;
    }

    @Override
    public int getIndex() {
        this.notSupported();
        return 0;
    }

    @Override
    public Torrent getTorrent() {
        return this.torrent;
    }

    @Override
    public byte[] getDownloadPeerId() {
        return this.delegate.getDownloadPeerId();
    }

    @Override
    public boolean isMessagingEnabled() {
        return this.delegate.isMessagingEnabled();
    }

    @Override
    public void setMessagingEnabled(boolean bl) {
        this.delegate.setMessagingEnabled(bl);
    }

    @Override
    public void initialize() throws DownloadException {
        try {
            this._dispatcher.dispatch(new RPRequest(this, "initialize", null)).getResponse();
        }
        catch (RPException rPException) {
            if (rPException.getCause() instanceof DownloadException) {
                throw (DownloadException)rPException.getCause();
            }
            throw rPException;
        }
    }

    @Override
    public void start() throws DownloadException {
        try {
            this._dispatcher.dispatch(new RPRequest(this, "start", null)).getResponse();
        }
        catch (RPException rPException) {
            if (rPException.getCause() instanceof DownloadException) {
                throw (DownloadException)rPException.getCause();
            }
            throw rPException;
        }
    }

    @Override
    public void stop() throws DownloadException {
        try {
            this._dispatcher.dispatch(new RPRequest(this, "stop", null)).getResponse();
        }
        catch (RPException rPException) {
            if (rPException.getCause() instanceof DownloadException) {
                throw (DownloadException)rPException.getCause();
            }
            throw rPException;
        }
    }

    @Override
    public void restart() throws DownloadException {
        try {
            this._dispatcher.dispatch(new RPRequest(this, "restart", null)).getResponse();
        }
        catch (RPException rPException) {
            if (rPException.getCause() instanceof DownloadException) {
                throw (DownloadException)rPException.getCause();
            }
            throw rPException;
        }
    }

    @Override
    public boolean isStartStopLocked() {
        this.notSupported();
        return false;
    }

    @Override
    public boolean isPaused() {
        this.notSupported();
        return false;
    }

    @Override
    public void pause() {
        this.notSupported();
    }

    @Override
    public void resume() {
        this.notSupported();
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public void setPriority(int n) {
    }

    @Override
    public boolean isPriorityLocked() {
        return false;
    }

    @Override
    public void remove() throws DownloadException, DownloadRemovalVetoException {
        try {
            this._dispatcher.dispatch(new RPRequest(this, "remove", null)).getResponse();
        }
        catch (RPException rPException) {
            Throwable throwable = rPException.getCause();
            if (throwable instanceof DownloadException) {
                throw (DownloadException)throwable;
            }
            if (throwable instanceof DownloadRemovalVetoException) {
                throw (DownloadRemovalVetoException)throwable;
            }
            throw rPException;
        }
    }

    @Override
    public void remove(boolean bl, boolean bl2) throws DownloadException, DownloadRemovalVetoException {
        this.notSupported();
    }

    @Override
    public boolean canBeRemoved() throws DownloadRemovalVetoException {
        this.notSupported();
        return false;
    }

    @Override
    public DownloadAnnounceResult getLastAnnounceResult() {
        return this.announce_result;
    }

    @Override
    public DownloadScrapeResult getLastScrapeResult() {
        return this.scrape_result;
    }

    @Override
    public DownloadStats getStats() {
        return this.stats;
    }

    @Override
    public void addListener(DownloadListener downloadListener2) {
        this.notSupported();
    }

    @Override
    public void removeListener(DownloadListener downloadListener2) {
        this.notSupported();
    }

    @Override
    public void addPropertyListener(DownloadPropertyListener downloadPropertyListener) {
        this.notSupported();
    }

    @Override
    public void removePropertyListener(DownloadPropertyListener downloadPropertyListener) {
        this.notSupported();
    }

    @Override
    public void addTrackerListener(DownloadTrackerListener downloadTrackerListener) {
        this.notSupported();
    }

    @Override
    public void removeTrackerListener(DownloadTrackerListener downloadTrackerListener) {
        this.notSupported();
    }

    @Override
    public void addDownloadWillBeRemovedListener(DownloadWillBeRemovedListener downloadWillBeRemovedListener) {
        this.notSupported();
    }

    @Override
    public void removeDownloadWillBeRemovedListener(DownloadWillBeRemovedListener downloadWillBeRemovedListener) {
        this.notSupported();
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public boolean isForceStart() {
        return this.force_start;
    }

    @Override
    public void setForceStart(boolean bl) {
        this.force_start = bl;
        this._dispatcher.dispatch(new RPRequest(this, "setForceStart[boolean]", new Object[]{new Boolean(this.force_start)})).getResponse();
    }

    @Override
    public void setPosition(int n) {
        this._dispatcher.dispatch(new RPRequest(this, "setPosition[int]", new Object[]{new Integer(n)})).getResponse();
    }

    @Override
    public void moveUp() {
        this._dispatcher.dispatch(new RPRequest(this, "moveUp", null)).getResponse();
    }

    @Override
    public void moveDown() {
        this._dispatcher.dispatch(new RPRequest(this, "moveDown", null)).getResponse();
    }

    @Override
    public void moveTo(int n) {
        this._dispatcher.dispatch(new RPRequest(this, "moveTo[int]", new Object[]{new Integer(n)})).getResponse();
    }

    @Override
    public void stopAndQueue() throws DownloadException {
        this.notSupported();
    }

    @Override
    public void recheckData() throws DownloadException {
        this.notSupported();
    }

    @Override
    public String getName() {
        this.notSupported();
        return "";
    }

    public void addListener(DownloadPeerListener downloadPeerListener) {
        this.notSupported(downloadPeerListener);
    }

    public void removeListener(DownloadPeerListener downloadPeerListener) {
        this.notSupported(downloadPeerListener);
    }

    @Override
    public void addPeerListener(DownloadPeerListener downloadPeerListener) {
        this.notSupported();
    }

    @Override
    public void removePeerListener(DownloadPeerListener downloadPeerListener) {
        this.notSupported();
    }

    @Override
    public String getTorrentFileName() {
        this.notSupported();
        return "";
    }

    @Override
    public String getAttribute(TorrentAttribute torrentAttribute) {
        this.notSupported();
        return null;
    }

    @Override
    public void setAttribute(TorrentAttribute torrentAttribute, String string) {
        this.notSupported();
    }

    @Override
    public String[] getListAttribute(TorrentAttribute torrentAttribute) {
        this.notSupported();
        return null;
    }

    @Override
    public void setMapAttribute(TorrentAttribute torrentAttribute, Map map) {
        this.notSupported();
    }

    @Override
    public Map getMapAttribute(TorrentAttribute torrentAttribute) {
        this.notSupported();
        return null;
    }

    @Override
    public String getCategoryName() {
        this.notSupported();
        return "";
    }

    @Override
    public void setCategory(String string) {
        this.notSupported();
    }

    @Override
    public boolean isPersistent() {
        this.notSupported();
        return false;
    }

    @Override
    public void setMaximumDownloadKBPerSecond(int n) {
        this.notSupported();
    }

    @Override
    public int getUploadRateLimitBytesPerSecond() {
        this.notSupported();
        return 0;
    }

    @Override
    public void setUploadRateLimitBytesPerSecond(int n) {
        this.notSupported();
    }

    @Override
    public int getDownloadRateLimitBytesPerSecond() {
        this.notSupported();
        return 0;
    }

    @Override
    public void setDownloadRateLimitBytesPerSecond(int n) {
        this.notSupported();
    }

    @Override
    public int getMaximumDownloadKBPerSecond() {
        this.notSupported();
        return 0;
    }

    @Override
    public boolean isComplete() {
        this.notSupported();
        return false;
    }

    @Override
    public boolean isComplete(boolean bl) {
        this.notSupported();
        return false;
    }

    @Override
    public boolean isChecking() {
        this.notSupported();
        return false;
    }

    @Override
    public PeerManager getPeerManager() {
        this.notSupported();
        return null;
    }

    @Override
    public DiskManager getDiskManager() {
        this.notSupported();
        return null;
    }

    @Override
    public DiskManagerFileInfo[] getDiskManagerFileInfo() {
        DiskManagerFileInfo[] diskManagerFileInfoArray = (RPDiskManagerFileInfo[])this._dispatcher.dispatch(new RPRequest(this, "getDiskManagerFileInfo", null)).getResponse();
        for (int i = 0; i < diskManagerFileInfoArray.length; ++i) {
            ((RPObject)((Object)diskManagerFileInfoArray[i]))._setRemote(this._dispatcher);
        }
        return diskManagerFileInfoArray;
    }

    @Override
    public DiskManagerFileInfo getDiskManagerFileInfo(int n) {
        RPDiskManagerFileInfo[] rPDiskManagerFileInfoArray = (RPDiskManagerFileInfo[])this._dispatcher.dispatch(new RPRequest(this, "getDiskManagerFileInfo", null)).getResponse();
        if (n >= 0 && n < rPDiskManagerFileInfoArray.length) {
            rPDiskManagerFileInfoArray[n]._setRemote(this._dispatcher);
            return rPDiskManagerFileInfoArray[n];
        }
        return null;
    }

    @Override
    public long getCreationTime() {
        this.notSupported();
        return 0L;
    }

    @Override
    public int getSeedingRank() {
        this.notSupported();
        return 0;
    }

    @Override
    public String getSavePath() {
        this.notSupported();
        return null;
    }

    @Override
    public void moveDataFiles(File file) throws DownloadException {
        this.notSupported();
    }

    @Override
    public void moveDataFiles(File file, String string) throws DownloadException {
        this.notSupported();
    }

    @Override
    public void moveTorrentFile(File file) {
        this.notSupported();
    }

    @Override
    public void requestTrackerAnnounce() {
        this._dispatcher.dispatch(new RPRequest(this, "requestTrackerAnnounce", null)).getResponse();
    }

    @Override
    public void requestTrackerAnnounce(boolean bl) {
        this.notSupported();
    }

    @Override
    public void requestTrackerScrape(boolean bl) {
        this.notSupported();
    }

    @Override
    public void setAnnounceResult(DownloadAnnounceResult downloadAnnounceResult) {
        this.notSupported();
    }

    @Override
    public void setScrapeResult(DownloadScrapeResult downloadScrapeResult) {
        this.notSupported();
    }

    @Override
    public DownloadActivationEvent getActivationState() {
        this.notSupported();
        return null;
    }

    @Override
    public void addActivationListener(DownloadActivationListener downloadActivationListener) {
        this.notSupported();
    }

    @Override
    public void removeActivationListener(DownloadActivationListener downloadActivationListener) {
        this.notSupported();
    }

    @Override
    public void setSeedingRank(int n) {
    }

    @Override
    public void addTrackerListener(DownloadTrackerListener downloadTrackerListener, boolean bl) {
        this.notSupported();
    }

    @Override
    public void renameDownload(String string) {
        this.notSupported();
    }

    @Override
    public File[] calculateDefaultPaths(boolean bl) {
        this.notSupported();
        return null;
    }

    @Override
    public boolean isInDefaultSaveDir() {
        this.notSupported();
        return false;
    }

    @Override
    public boolean getBooleanAttribute(TorrentAttribute torrentAttribute) {
        this.notSupported();
        return false;
    }

    @Override
    public int getIntAttribute(TorrentAttribute torrentAttribute) {
        this.notSupported();
        return 0;
    }

    @Override
    public long getLongAttribute(TorrentAttribute torrentAttribute) {
        this.notSupported();
        return 0L;
    }

    @Override
    public boolean hasAttribute(TorrentAttribute torrentAttribute) {
        this.notSupported();
        return false;
    }

    @Override
    public void setBooleanAttribute(TorrentAttribute torrentAttribute, boolean bl) {
        this.notSupported();
    }

    @Override
    public void setIntAttribute(TorrentAttribute torrentAttribute, int n) {
        this.notSupported();
    }

    @Override
    public void setListAttribute(TorrentAttribute torrentAttribute, String[] stringArray) {
        this.notSupported();
    }

    @Override
    public void setLongAttribute(TorrentAttribute torrentAttribute, long l) {
        this.notSupported();
    }

    @Override
    public void setFlag(long l, boolean bl) {
        this.notSupported();
    }

    @Override
    public void addAttributeListener(DownloadAttributeListener downloadAttributeListener, TorrentAttribute torrentAttribute, int n) {
        this.notSupported();
    }

    @Override
    public void removeAttributeListener(DownloadAttributeListener downloadAttributeListener, TorrentAttribute torrentAttribute, int n) {
        this.notSupported();
    }

    @Override
    public void addCompletionListener(DownloadCompletionListener downloadCompletionListener) {
        this.notSupported();
    }

    @Override
    public void removeCompletionListener(DownloadCompletionListener downloadCompletionListener) {
        this.notSupported();
    }

    @Override
    public boolean isRemoved() {
        this.notSupported();
        return false;
    }

    @Override
    public boolean canMoveDataFiles() {
        this.notSupported();
        return false;
    }

    @Override
    public SaveLocationChange calculateDefaultDownloadLocation() {
        this.notSupported();
        return null;
    }

    @Override
    public Object getUserData(Object object) {
        this.notSupported();
        return null;
    }

    @Override
    public void setUserData(Object object, Object object2) {
        this.notSupported();
    }

    @Override
    public void startDownload(boolean bl) {
        this.notSupported();
    }

    @Override
    public void stopDownload() {
        this.notSupported();
    }

    @Override
    public void changeLocation(SaveLocationChange saveLocationChange) {
        this.notSupported();
    }
}

