/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote.download;

import java.io.File;
import java.net.URL;
import java.util.Map;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadEventNotifier;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadManagerStats;
import org.gudy.azureus2.plugins.download.DownloadWillBeAddedListener;
import org.gudy.azureus2.plugins.download.savelocation.DefaultSaveLocationManager;
import org.gudy.azureus2.plugins.download.savelocation.SaveLocationManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPReply;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;
import org.gudy.azureus2.pluginsimpl.remote.download.RPDownload;
import org.gudy.azureus2.pluginsimpl.remote.torrent.RPTorrent;

public class RPDownloadManager
extends RPObject
implements DownloadManager {
    protected transient DownloadManager delegate;

    public static RPDownloadManager create(DownloadManager downloadManager) {
        RPDownloadManager rPDownloadManager = (RPDownloadManager)RPDownloadManager._lookupLocal(downloadManager);
        if (rPDownloadManager == null) {
            rPDownloadManager = new RPDownloadManager(downloadManager);
        }
        return rPDownloadManager;
    }

    protected RPDownloadManager(DownloadManager downloadManager) {
        super(downloadManager);
    }

    @Override
    protected void _setDelegate(Object object) {
        this.delegate = (DownloadManager)object;
    }

    @Override
    public Object _setLocal() throws RPException {
        return this._fixupLocal();
    }

    @Override
    public RPReply _process(RPRequest rPRequest) {
        String string = rPRequest.getMethod();
        Object[] objectArray = rPRequest.getParams();
        if (string.equals("getDownloads")) {
            Download[] downloadArray = this.delegate.getDownloads();
            RPDownload[] rPDownloadArray = new RPDownload[downloadArray.length];
            for (int i = 0; i < rPDownloadArray.length; ++i) {
                rPDownloadArray[i] = RPDownload.create(downloadArray[i]);
            }
            return new RPReply(rPDownloadArray);
        }
        if (string.equals("getDownloads[boolean]")) {
            Download[] downloadArray = this.delegate.getDownloads((Boolean)rPRequest.getParams()[0]);
            RPDownload[] rPDownloadArray = new RPDownload[downloadArray.length];
            for (int i = 0; i < rPDownloadArray.length; ++i) {
                rPDownloadArray[i] = RPDownload.create(downloadArray[i]);
            }
            return new RPReply(rPDownloadArray);
        }
        if (string.equals("addDownload[Torrent]")) {
            try {
                RPTorrent rPTorrent = (RPTorrent)rPRequest.getParams()[0];
                Download download = this.delegate.addDownload((Torrent)rPTorrent._setLocal());
                return new RPReply(RPDownload.create(download));
            }
            catch (DownloadException downloadException) {
                throw new RPException("DownloadManager::addDownload failed", downloadException);
            }
        }
        if (string.equals("addDownload[Torrent,String,String]")) {
            try {
                RPTorrent rPTorrent = (RPTorrent)rPRequest.getParams()[0];
                File file = objectArray[1] == null ? null : new File((String)objectArray[1]);
                File file2 = objectArray[2] == null ? null : new File((String)objectArray[2]);
                Download download = this.delegate.addDownload((Torrent)rPTorrent._setLocal(), file, file2);
                return new RPReply(RPDownload.create(download));
            }
            catch (DownloadException downloadException) {
                throw new RPException("DownloadManager::addDownload failed", downloadException);
            }
        }
        if (string.equals("addDownload[URL]")) {
            try {
                this.delegate.addDownload((URL)rPRequest.getParams()[0]);
            }
            catch (DownloadException downloadException) {
                throw new RPException("DownloadManager::addDownload failed", downloadException);
            }
            return new RPReply(null);
        }
        if (string.equals("pauseDownloads")) {
            this.delegate.pauseDownloads();
            return null;
        }
        if (string.equals("resumeDownloads")) {
            this.delegate.resumeDownloads();
            return null;
        }
        if (string.equals("stopAllDownloads")) {
            this.delegate.stopAllDownloads();
            return null;
        }
        if (string.equals("startAllDownloads")) {
            this.delegate.startAllDownloads();
            return null;
        }
        throw new RPException("Unknown method: " + string);
    }

    @Override
    public void addDownload(File file) throws DownloadException {
        this.notSupported();
    }

    @Override
    public void addDownload(URL uRL, URL uRL2) {
        this.notSupported();
    }

    @Override
    public void addDownload(URL uRL) throws DownloadException {
        this._dispatcher.dispatch(new RPRequest(this, "addDownload[URL]", new Object[]{uRL})).getResponse();
    }

    @Override
    public void addDownload(URL uRL, boolean bl) throws DownloadException {
        this.notSupported();
    }

    @Override
    public void addDownload(URL uRL, Map map) {
        this.notSupported();
    }

    @Override
    public Download addDownload(Torrent torrent) throws DownloadException {
        try {
            RPDownload rPDownload = (RPDownload)this._dispatcher.dispatch(new RPRequest(this, "addDownload[Torrent]", new Object[]{torrent})).getResponse();
            rPDownload._setRemote(this._dispatcher);
            return rPDownload;
        }
        catch (RPException rPException) {
            if (rPException.getCause() instanceof DownloadException) {
                throw (DownloadException)rPException.getCause();
            }
            throw rPException;
        }
    }

    @Override
    public Download addDownload(Torrent torrent, File file, File file2) throws DownloadException {
        try {
            RPDownload rPDownload = (RPDownload)this._dispatcher.dispatch(new RPRequest(this, "addDownload[Torrent,String,String]", new Object[]{torrent, file == null ? null : file.toString(), file2 == null ? null : file2.toString()})).getResponse();
            rPDownload._setRemote(this._dispatcher);
            return rPDownload;
        }
        catch (RPException rPException) {
            if (rPException.getCause() instanceof DownloadException) {
                throw (DownloadException)rPException.getCause();
            }
            throw rPException;
        }
    }

    @Override
    public Download addDownloadStopped(Torrent torrent, File file, File file2) throws DownloadException {
        this.notSupported();
        return null;
    }

    @Override
    public Download addNonPersistentDownload(Torrent torrent, File file, File file2) throws DownloadException {
        this.notSupported();
        return null;
    }

    @Override
    public Download getDownload(Torrent torrent) {
        this.notSupported();
        return null;
    }

    @Override
    public Download getDownload(byte[] byArray) {
        this.notSupported();
        return null;
    }

    @Override
    public Download[] getDownloads() {
        Download[] downloadArray = (RPDownload[])this._dispatcher.dispatch(new RPRequest(this, "getDownloads", null)).getResponse();
        for (int i = 0; i < downloadArray.length; ++i) {
            ((RPDownload)downloadArray[i])._setRemote(this._dispatcher);
        }
        return downloadArray;
    }

    @Override
    public Download[] getDownloads(boolean bl) {
        Download[] downloadArray = (RPDownload[])this._dispatcher.dispatch(new RPRequest(this, "getDownloads[boolean]", new Object[]{new Boolean(bl)})).getResponse();
        for (int i = 0; i < downloadArray.length; ++i) {
            ((RPDownload)downloadArray[i])._setRemote(this._dispatcher);
        }
        return downloadArray;
    }

    @Override
    public void pauseDownloads() {
        this._dispatcher.dispatch(new RPRequest(this, "pauseDownloads", null)).getResponse();
    }

    @Override
    public boolean canPauseDownloads() {
        this.notSupported();
        return false;
    }

    @Override
    public void resumeDownloads() {
        this._dispatcher.dispatch(new RPRequest(this, "resumeDownloads", null)).getResponse();
    }

    @Override
    public boolean canResumeDownloads() {
        this.notSupported();
        return false;
    }

    @Override
    public void startAllDownloads() {
        this._dispatcher.dispatch(new RPRequest(this, "startAllDownloads", null)).getResponse();
    }

    @Override
    public void stopAllDownloads() {
        this._dispatcher.dispatch(new RPRequest(this, "stopAllDownloads", null)).getResponse();
    }

    @Override
    public DownloadManagerStats getStats() {
        this.notSupported();
        return null;
    }

    @Override
    public boolean isSeedingOnly() {
        this.notSupported();
        return false;
    }

    @Override
    public void addListener(DownloadManagerListener downloadManagerListener) {
        this.notSupported();
    }

    @Override
    public void addListener(DownloadManagerListener downloadManagerListener, boolean bl) {
        this.notSupported();
    }

    @Override
    public void removeListener(DownloadManagerListener downloadManagerListener) {
        this.notSupported();
    }

    @Override
    public void removeListener(DownloadManagerListener downloadManagerListener, boolean bl) {
        this.notSupported();
    }

    @Override
    public void addDownloadWillBeAddedListener(DownloadWillBeAddedListener downloadWillBeAddedListener) {
        this.notSupported();
    }

    @Override
    public void removeDownloadWillBeAddedListener(DownloadWillBeAddedListener downloadWillBeAddedListener) {
        this.notSupported();
    }

    @Override
    public DownloadEventNotifier getGlobalDownloadEventNotifier() {
        this.notSupported();
        return null;
    }

    @Override
    public void setSaveLocationManager(SaveLocationManager saveLocationManager) {
        this.notSupported();
    }

    @Override
    public SaveLocationManager getSaveLocationManager() {
        this.notSupported();
        return null;
    }

    @Override
    public DefaultSaveLocationManager getDefaultSaveLocationManager() {
        this.notSupported();
        return null;
    }
}

