/*
 * Decompiled with CFR 0.152.
 */
package de.http;

import de.http.HTML;
import de.http.ProxyDefintion;
import de.http.SED;
import de.http.SimpleAuthenticator;
import de.http.URLUtil;
import de.log.Category;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class WGet {
    static Category log = Category.getInstance(WGet.class);
    String directory_prefix = System.getProperty("user.dir");

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage: org.apache.lenya.net.WGet [URL] -P/home/lenya/download");
            return;
        }
        try {
            WGet wGet = new WGet();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].indexOf("-P") != 0) continue;
                wGet.setDirectoryPrefix(stringArray[i].substring(2));
            }
            byte[] byArray = wGet.download(new URL(stringArray[0]), "s/\\/lenya\\/oscom//g", "");
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println(malformedURLException);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public void setDirectoryPrefix(String string) {
        this.directory_prefix = string;
    }

    public byte[] download(URL uRL, String string, String string2) throws IOException {
        log.debug(".download(): " + uRL + " " + string + " " + string2);
        return this.downloadUsingHttpClient(uRL, string, string2);
    }

    public byte[] downloadUsingHttpClient(URL uRL, String string, String string2) {
        Object object;
        log.debug(".downloadUsingHttpClient(): " + uRL);
        byte[] byArray = null;
        try {
            byArray = this.getResource(uRL);
            object = new File(this.createFileName(uRL, string, string2));
            this.saveToFile(((File)object).getAbsolutePath(), byArray);
            this.substitutePrefix(((File)object).getAbsolutePath(), string, string2);
        }
        catch (MalformedURLException malformedURLException) {
            log.error(".downloadUsingHttpClient(): ", malformedURLException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error(".downloadUsingHttpClient(): ", fileNotFoundException);
        }
        catch (IOException iOException) {
            log.error(".downloadUsingHttpClient(): ", iOException);
        }
        object = null;
        try {
            object = this.getLinks(uRL);
        }
        catch (IOException iOException) {
            log.error(".downloadUsingHttpClient(): ", iOException);
        }
        if (object != null) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                try {
                    URL uRL2 = new URL(URLUtil.complete(uRL.toString(), string3));
                    byte[] byArray2 = this.getResource(uRL2);
                    this.saveToFile(this.createFileName(uRL2, string, string2), byArray2);
                }
                catch (Exception exception) {
                    log.error(".downloadUsingHttpClient(): ", exception);
                }
            }
        }
        return byArray;
    }

    public byte[] getResource(URL uRL) throws IOException {
        int n;
        log.debug(".getResource(): " + uRL);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        InputStream inputStream = httpURLConnection.getInputStream();
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        httpURLConnection.disconnect();
        return byArray2;
    }

    public byte[] getResourceProxy(URL uRL, ProxyDefintion proxyDefintion) throws IOException {
        int n;
        log.debug(".getResource() with Proxy " + proxyDefintion.toString() + ": " + uRL);
        Authenticator.setDefault(new SimpleAuthenticator(proxyDefintion.getUser(), proxyDefintion.getPassword()));
        Properties properties = System.getProperties();
        properties.setProperty("http.proxyHost", proxyDefintion.getProxy());
        properties.setProperty("http.proxyPort", proxyDefintion.getPort());
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        InputStream inputStream = httpURLConnection.getInputStream();
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        httpURLConnection.disconnect();
        return byArray2;
    }

    public List getLinks(URL uRL) throws IOException {
        log.debug(".getLinks(): Get links from " + uRL);
        List list = null;
        try {
            HTML hTML = new HTML(uRL.toString());
            list = hTML.getImageSrcs(false);
            list.addAll(hTML.getLinkHRefs(false));
        }
        catch (Exception exception) {
            log.error(".getLinks() Exception 423432: ", exception);
        }
        if (list != null) {
            log.debug(".getLinks(): Number of links found: " + list.size());
        }
        return list;
    }

    public void substitutePrefix(String string, String string2, String string3) throws IOException {
        log.debug("Replace " + string2 + " by " + string3);
        SED.replaceAll(new File(string), this.escapeSlashes(string2), this.escapeSlashes(string3));
    }

    public String escapeSlashes(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '/') {
                stringBuffer.append("\\/");
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "-P: " + this.directory_prefix;
    }

    public void saveToFile(String string, byte[] byArray) throws FileNotFoundException, IOException {
        File file = new File(string);
        File file2 = new File(file.getParent());
        if (!file2.exists()) {
            log.warn(".saveToFile(): Directory will be created: " + file2.getAbsolutePath());
            file2.mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsolutePath());
        fileOutputStream.write(byArray);
        fileOutputStream.close();
    }

    public String createFileName(URL uRL, String string, String string2) {
        File file = new File(this.directory_prefix + File.separator + uRL.getFile());
        return file.getAbsolutePath().replaceAll(string, string2);
    }

    public byte[] runProcess(String string) throws Exception {
        Process process = Runtime.getRuntime().exec(string);
        InputStream inputStream = process.getInputStream();
        byte[] byArray = new byte[1024];
        int n = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        if (byteArrayOutputStream.toString().length() > 0) {
            log.debug(".runProcess(): %%%InputStream:START" + byteArrayOutputStream.toString() + "END:InputStream%%%");
        }
        InputStream inputStream2 = process.getErrorStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        while ((n = inputStream2.read(byArray)) != -1) {
            byteArrayOutputStream2.write(byArray, 0, n);
        }
        if (byteArrayOutputStream2.toString().length() > 0) {
            log.error(".runProcess(): ###ErrorStream:START" + byteArrayOutputStream2.toString() + "END:ErrorStream###");
        }
        return byteArrayOutputStream.toByteArray();
    }
}

