/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.proxy;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import jd.controlling.proxy.ProxyBlock;
import jd.controlling.proxy.ProxyData;
import jd.plugins.DownloadLink;
import org.appwork.utils.net.httpconnection.HTTPProxy;

public class ProxyInfo
extends HTTPProxy {
    private static final AtomicLong IDs = new AtomicLong(0L);
    private boolean proxyRotationEnabled = true;
    private String ID = null;
    private final HashMap<String, Integer> activeHosts = new HashMap();
    private final HashMap<String, ProxyBlock> unavailBlocks = new HashMap();
    private final HashMap<String, ProxyBlock> ipBlocks = new HashMap();

    public boolean isProxyRotationEnabled() {
        return this.proxyRotationEnabled;
    }

    protected void setProxyRotationEnabled(boolean bl) {
        this.proxyRotationEnabled = bl;
    }

    public ProxyData toProxyData() {
        ProxyData proxyData = new ProxyData();
        proxyData.setProxyRotationEnabled(this.isProxyRotationEnabled());
        proxyData.setProxy(HTTPProxy.getStorable(this));
        proxyData.setID(this.ID);
        return proxyData;
    }

    public ProxyInfo(ProxyData proxyData) {
        this.cloneProxy(HTTPProxy.getHTTPProxy(proxyData.getProxy()));
        this.proxyRotationEnabled = proxyData.isProxyRotationEnabled();
        this.ID = proxyData.getID();
        if (this.ID == null) {
            this.ID = this.isNone() ? "NONE" : this.getType().name() + IDs.incrementAndGet() + "_" + System.currentTimeMillis();
        }
    }

    public ProxyInfo(HTTPProxy hTTPProxy) {
        this.cloneProxy(hTTPProxy);
        this.ID = hTTPProxy.isNone() ? "NONE" : hTTPProxy.getType().name() + IDs.incrementAndGet() + "_" + System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProxyBlock getHostIPBlockTimeout(String string) {
        HashMap<String, ProxyBlock> hashMap = this.ipBlocks;
        synchronized (hashMap) {
            ProxyBlock proxyBlock = this.ipBlocks.get(string);
            if (proxyBlock != null && proxyBlock.getBlockedTimeout() <= 0L) {
                this.ipBlocks.remove(string);
                proxyBlock = null;
            }
            return proxyBlock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProxyBlock getHostBlockedTimeout(String string) {
        HashMap<String, ProxyBlock> hashMap = this.unavailBlocks;
        synchronized (hashMap) {
            ProxyBlock proxyBlock = this.unavailBlocks.get(string);
            if (proxyBlock != null && proxyBlock.getBlockedTimeout() <= 0L) {
                this.unavailBlocks.remove(string);
                proxyBlock = null;
            }
            return proxyBlock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyBlock setHostBlockedTimeout(DownloadLink downloadLink, long l) {
        HashMap<String, ProxyBlock> hashMap = this.unavailBlocks;
        synchronized (hashMap) {
            if (l <= 0L) {
                this.unavailBlocks.remove(downloadLink.getHost());
                return null;
            }
            ProxyBlock proxyBlock = this.unavailBlocks.get(downloadLink.getHost());
            if (proxyBlock == null || proxyBlock.getBlockedUntil() > System.currentTimeMillis() + l) {
                proxyBlock = new ProxyBlock(downloadLink, System.currentTimeMillis() + l, ProxyBlock.REASON.UNAVAIL);
                this.unavailBlocks.put(downloadLink.getHost(), proxyBlock);
            }
            return proxyBlock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyBlock setHostIPBlockTimeout(DownloadLink downloadLink, long l) {
        HashMap<String, ProxyBlock> hashMap = this.ipBlocks;
        synchronized (hashMap) {
            if (l <= 0L) {
                this.ipBlocks.remove(downloadLink.getHost());
                return null;
            }
            ProxyBlock proxyBlock = this.ipBlocks.get(downloadLink.getHost());
            if (proxyBlock == null || proxyBlock.getBlockedUntil() > System.currentTimeMillis() + l) {
                proxyBlock = new ProxyBlock(downloadLink, System.currentTimeMillis() + l, ProxyBlock.REASON.IP);
                this.ipBlocks.put(downloadLink.getHost(), proxyBlock);
            }
            return proxyBlock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeHostIPBlockTimeout(String string) {
        HashMap<String, ProxyBlock> hashMap = this.ipBlocks;
        synchronized (hashMap) {
            if (string == null) {
                this.ipBlocks.clear();
            } else {
                this.ipBlocks.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHostBlockedWaittime(String string) {
        HashMap<String, ProxyBlock> hashMap = this.unavailBlocks;
        synchronized (hashMap) {
            if (string == null) {
                this.unavailBlocks.clear();
            } else {
                this.unavailBlocks.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int activeDownloadsbyHosts(String string) {
        HashMap<String, Integer> hashMap = this.activeHosts;
        synchronized (hashMap) {
            Integer n = this.activeHosts.get(string);
            if (n != null) {
                return n;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseActiveDownloads(String string) {
        HashMap<String, Integer> hashMap = this.activeHosts;
        synchronized (hashMap) {
            Integer n = this.activeHosts.get(string);
            if (n == null) {
                n = 1;
            } else {
                Integer n2 = n;
                Integer n3 = n = Integer.valueOf(n + 1);
            }
            this.activeHosts.put(string, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decreaseActiveDownloads(String string) {
        HashMap<String, Integer> hashMap = this.activeHosts;
        synchronized (hashMap) {
            Integer n = this.activeHosts.get(string);
            if (n == null || n == 0) {
                throw new RuntimeException("How could this happen?");
            }
            Integer n2 = n;
            Integer n3 = n = Integer.valueOf(n - 1);
            if (n == 0) {
                this.activeHosts.remove(string);
            } else {
                this.activeHosts.put(string, n);
            }
        }
    }
}

