/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.ipcheck;

import java.net.InetAddress;
import java.net.UnknownHostException;
import jd.controlling.JDLogger;
import jd.controlling.reconnect.ipcheck.ForbiddenIPException;
import jd.controlling.reconnect.ipcheck.IPCheckException;
import jd.controlling.reconnect.ipcheck.InvalidIPException;
import jd.controlling.reconnect.ipcheck.InvalidIPRangeException;
import jd.controlling.reconnect.ipcheck.OfflineException;

public class IP {
    public static final String IP_PATTERN = "\\b(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?).){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b";
    protected String ip = null;

    public static IP getInstance(String string) throws IPCheckException {
        String[] stringArray;
        if (string.matches("^\\d+\\.\\d+\\.\\d+\\.\\d+$") && (stringArray = string.split("\\.")).length == 4) {
            int n = Integer.parseInt(stringArray[0]);
            if (n == 10) {
                throw new InvalidIPRangeException(string);
            }
            int n2 = Integer.parseInt(stringArray[1]);
            if (n == 192 && n2 == 168) {
                throw new InvalidIPRangeException(string);
            }
            if (n == 172 && n2 >= 16 && n2 <= 31) {
                throw new InvalidIPRangeException(string);
            }
            int n3 = Integer.parseInt(stringArray[2]);
            int n4 = Integer.parseInt(stringArray[3]);
            if (n == 0 && n2 == 0 && n3 == 0 && n4 == 0) {
                throw new OfflineException(string);
            }
            if (n >= 0 && n <= 255 && n2 >= 0 && n2 <= 255 && n3 >= 0 && n3 <= 255 && n4 >= 0 && n4 <= 255) {
                if (!IP.validateIP(string)) {
                    throw new ForbiddenIPException(string);
                }
                return new IP(string);
            }
            throw new InvalidIPException(string);
        }
        throw new InvalidIPException(string);
    }

    public static boolean validateIP(String string) {
        if (string == null) {
            return false;
        }
        try {
            return true;
        }
        catch (Exception exception) {
            JDLogger.getLogger().severe("Could not validate IP! " + exception);
            return true;
        }
    }

    private IP(String string) {
        this.ip = string;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof IP) {
            IP iP = (IP)object;
            return iP.ip.equals(this.ip);
        }
        return false;
    }

    public int hashCode() {
        return this.ip.hashCode();
    }

    public String toString() {
        return this.ip != null ? this.ip : "unknown";
    }

    public static boolean isValidRouterIP(String string) {
        boolean bl = IP.isLocalIP(string);
        if (!bl) {
            try {
                bl = IP.isLocalIP(InetAddress.getByName(string).getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (!bl) {
            return false;
        }
        return false;
    }

    public static boolean isLocalIP(String string) {
        String[] stringArray;
        if (string == null) {
            return false;
        }
        if (string.matches("^\\d+\\.\\d+\\.\\d+\\.\\d+$") && (stringArray = string.split("\\.")).length == 4) {
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            if (n == 10) {
                return true;
            }
            if (n == 192 && n2 == 168) {
                return true;
            }
            if (n == 172 && n2 >= 16 && n2 <= 31) {
                return true;
            }
        }
        return false;
    }
}

