/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.rmi.ConnectException;
import java.util.StringTokenizer;
import jd.controlling.JDLogger;
import jd.nutils.FtpEvent;
import jd.nutils.FtpListener;
import jd.nutils.JDHash;
import org.appwork.utils.Regex;
import org.appwork.utils.event.Eventsender;
import org.appwork.utils.net.throttledconnection.MeteredThrottledInputStream;
import org.appwork.utils.net.throttledconnection.ThrottledConnectionHandler;
import org.appwork.utils.net.throttledconnection.ThrottledInputStream;
import org.appwork.utils.speedmeter.AverageSpeedMeter;

public class SimpleFTP {
    private static final int TIMEOUT = 20000;
    private boolean binarymode = false;
    private static boolean DEBUG = true;
    private BufferedReader reader = null;
    private Socket socket = null;
    private BufferedWriter writer = null;
    private String dir = "/";
    private String host;
    private Eventsender<FtpListener, FtpEvent> broadcaster;
    private ThrottledConnectionHandler cmanager = null;

    public ThrottledConnectionHandler getCmanager() {
        return this.cmanager;
    }

    public void setCmanager(ThrottledConnectionHandler throttledConnectionHandler) {
        this.cmanager = throttledConnectionHandler;
    }

    public Eventsender<FtpListener, FtpEvent> getBroadcaster() {
        return this.broadcaster;
    }

    public SimpleFTP() {
        this.initBroadcaster();
    }

    private void initBroadcaster() {
        this.broadcaster = new Eventsender<FtpListener, FtpEvent>(){

            @Override
            protected void fireEvent(FtpListener ftpListener, FtpEvent ftpEvent) {
                if (ftpEvent.getEventID() == 0) {
                    ftpListener.onDownloadProgress(ftpEvent);
                }
            }
        };
    }

    public synchronized boolean ascii() throws IOException {
        this.sendLine("TYPE A");
        try {
            this.readLines(new int[]{200}, "could not enter ascii mode");
            if (this.binarymode) {
                this.binarymode = false;
            }
            return true;
        }
        catch (IOException iOException) {
            if (iOException.getMessage().contains("ascii")) {
                JDLogger.exception(iOException);
                return false;
            }
            throw iOException;
        }
    }

    public synchronized boolean bin() throws IOException {
        this.sendLine("TYPE I");
        try {
            this.readLines(new int[]{200}, "could not enter binary mode");
            if (!this.binarymode) {
                this.binarymode = true;
            }
            return true;
        }
        catch (IOException iOException) {
            if (iOException.getMessage().contains("binary")) {
                JDLogger.exception(iOException);
                return false;
            }
            throw iOException;
        }
    }

    public synchronized void connect(String string) throws IOException {
        this.connect(string, 21);
    }

    public synchronized void connect(String string, int n) throws IOException {
        this.connect(string, n, "anonymous", "anonymous");
    }

    public synchronized void connect(String string, int n, String string2, String string3) throws IOException {
        if (this.socket != null) {
            throw new IOException("SimpleFTP is already connected. Disconnect first.");
        }
        this.socket = new Socket(string, n);
        this.host = string;
        this.socket.setSoTimeout(20000);
        this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
        String string4 = this.readLines(new int[]{220}, "SimpleFTP received an unknown response when connecting to the FTP server: ");
        this.sendLine("USER " + string2);
        string4 = this.readLines(new int[]{230, 331}, "SimpleFTP received an unknown response after sending the user: ");
        this.sendLine("PASS " + string3);
        string4 = this.readLines(new int[]{230}, "SimpleFTP was unable to log in with the supplied password: ");
        this.sendLine("PWD");
        while ((string4 = this.readLine()).startsWith("230") || string4.charAt(0) >= '9' || string4.charAt(0) <= '0') {
        }
        if (!string4.startsWith("257 ")) {
            throw new IOException("PWD COmmand not understood " + string4);
        }
        this.dir = new Regex(string4, "\"(.*)\"").getMatch(0);
    }

    public synchronized boolean cwd(String string) throws IOException {
        if ((string = string.replaceAll("[\\\\|//]+?", "/")).equals(this.dir)) {
            return true;
        }
        this.sendLine("CWD " + string);
        try {
            this.readLines(new int[]{250}, "SimpleFTP was unable to change directory");
            if (!string.endsWith("/") && !string.endsWith("\\")) {
                string = string + "/";
            }
            this.dir = string.startsWith("/") ? string : this.dir + string;
            return true;
        }
        catch (IOException iOException) {
            if (iOException.getMessage().contains("was unable to change")) {
                JDLogger.exception(iOException);
                return false;
            }
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect() throws IOException {
        try {
            this.sendLine("QUIT");
        }
        finally {
            try {
                this.socket.close();
            }
            catch (Throwable throwable) {}
            this.socket = null;
        }
    }

    public synchronized String pwd() throws IOException {
        int n;
        int n2;
        this.sendLine("PWD");
        String string = null;
        String string2 = this.readLines(new int[]{257}, null);
        if (string2.startsWith("257 ") && (n2 = string2.indexOf(34, (n = string2.indexOf(34)) + 1)) > 0) {
            string = string2.substring(n + 1, n2);
        }
        return string;
    }

    private String readLine() throws IOException {
        String string = this.reader.readLine();
        if (DEBUG) {
            System.out.println(this.host + " < " + string);
        }
        return string;
    }

    private String readLines(int[] nArray, String string) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = null;
        boolean bl = false;
        boolean bl2 = true;
        int n = 0;
        block0: do {
            if ((string2 = this.readLine()) == null) {
                return stringBuilder.toString();
            }
            stringBuilder.append(string2 + "\r\n");
            bl2 = true;
            for (int n2 : nArray) {
                if (string2.startsWith("" + n2 + "-")) {
                    n = n2;
                    bl2 = false;
                    bl = true;
                    continue block0;
                }
                if (bl && string2.startsWith("" + n + " ")) {
                    return stringBuilder.toString();
                }
                if (!bl && string2.startsWith("" + n2 + " ")) {
                    return stringBuilder.toString();
                }
                if (!string2.startsWith("" + n2)) continue;
                bl2 = false;
                continue block0;
            }
        } while (!bl2 || bl);
        throw new IOException((string != null ? string : "revieved unexpected responsecode ") + stringBuilder.toString());
    }

    public boolean remove(String string) throws IOException {
        this.sendLine("DELE " + string);
        try {
            this.readLines(new int[]{250}, "could not remove file");
            return true;
        }
        catch (IOException iOException) {
            if (iOException.getMessage().contains("could not remove file")) {
                JDLogger.exception(iOException);
                return false;
            }
            throw iOException;
        }
    }

    public boolean rename(String string, String string2) throws IOException {
        block5: {
            block4: {
                this.sendLine("RNFR " + string);
                try {
                    this.readLines(new int[]{350}, "RNFR failed");
                }
                catch (IOException iOException) {
                    if (!iOException.getMessage().contains("RNFR")) break block4;
                    JDLogger.exception(iOException);
                    return false;
                }
            }
            this.sendLine("RNTO " + string2);
            try {
                this.readLines(new int[]{250}, "RNTO failed");
            }
            catch (IOException iOException) {
                if (!iOException.getMessage().contains("RNTO")) break block5;
                JDLogger.exception(iOException);
                return false;
            }
        }
        return true;
    }

    public long getSize(String string) throws IOException {
        String string2;
        block2: {
            this.sendLine("SIZE " + string);
            string2 = null;
            try {
                string2 = this.readLines(new int[]{213}, "SIZE failed");
            }
            catch (IOException iOException) {
                if (!iOException.getMessage().contains("SIZE") && !iOException.getMessage().contains("550")) break block2;
                return -1L;
            }
        }
        String[] stringArray = string2.split(" ");
        return Long.parseLong(stringArray[1].trim());
    }

    private void sendLine(String string) throws IOException {
        if (this.socket == null) {
            throw new IOException("SimpleFTP is not connected.");
        }
        try {
            this.writer.write(string + "\r\n");
            this.writer.flush();
            if (DEBUG) {
                System.out.println(this.host + " > " + string);
            }
        }
        catch (IOException iOException) {
            this.disconnect();
            throw iOException;
        }
    }

    public synchronized boolean stor(File file) throws IOException {
        if (file.isDirectory()) {
            throw new IOException("SimpleFTP cannot upload a directory.");
        }
        String string = file.getName();
        return this.stor(new FileInputStream(file), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean stor(InputStream inputStream, String string) throws IOException {
        Socket socket = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            InetSocketAddress inetSocketAddress = this.pasv();
            this.sendLine("STOR " + string);
            String string2 = null;
            try {
                socket = new Socket(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
                string2 = this.readLine();
                if (!string2.startsWith("150 ") && !string2.startsWith("125 ")) {
                    throw new IOException("SimpleFTP was not allowed to send the file: " + string2);
                }
                bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream());
                byte[] byArray = new byte[4096];
                int n = 0;
                while ((n = inputStream.read(byArray)) != -1) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
                inputStream.close();
            }
            finally {
                try {
                    bufferedOutputStream.flush();
                }
                catch (Throwable throwable) {}
                try {
                    bufferedOutputStream.close();
                }
                catch (Throwable throwable) {}
                this.shutDownSocket(socket);
            }
            string2 = this.readLine();
            boolean bl = string2.startsWith("226 ");
            return bl;
        }
        catch (ConnectException connectException) {
            connectException.printStackTrace();
            this.cancelTransfer();
            boolean bl = this.stor(inputStream, string);
            return bl;
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
            this.cancelTransfer();
            boolean bl = this.stor(inputStream, string);
            return bl;
        }
        finally {
            inputStream.close();
        }
    }

    private void cancelTransfer() {
        try {
            this.sendLine("ABOR");
            this.readLine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private InetSocketAddress pasv() throws IOException {
        this.sendLine("PASV");
        String string = this.readLines(new int[]{227}, "SimpleFTP could not request passive mode:");
        String string2 = null;
        int n = -1;
        int n2 = string.indexOf(40);
        int n3 = string.indexOf(41, n2 + 1);
        if (n3 > 0) {
            String string3 = string.substring(n2 + 1, n3);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            try {
                string2 = stringTokenizer.nextToken() + "." + stringTokenizer.nextToken() + "." + stringTokenizer.nextToken() + "." + stringTokenizer.nextToken();
                n = Integer.parseInt(stringTokenizer.nextToken()) * 256 + Integer.parseInt(stringTokenizer.nextToken());
                return new InetSocketAddress(string2, n);
            }
            catch (Exception exception) {
                throw new IOException("SimpleFTP received bad data link information: " + string);
            }
        }
        throw new IOException("SimpleFTP received bad data link information: " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mkdir(String string) throws IOException {
        String string2 = this.dir;
        String string3 = string;
        try {
            string3 = string3.replace("\\", "/");
            String[] stringArray = string3.split("[\\\\|/]{1}");
            String[] stringArray2 = this.dir.split("[\\\\|/]{1}");
            int n = 0;
            String string4 = "";
            for (int i = 0; i < Math.min(stringArray.length, stringArray2.length); ++i) {
                if (!stringArray[i].equals(stringArray2[i])) continue;
                n += stringArray[i].length() + 1;
                string4 = string4 + stringArray[i] + "/";
            }
            string3 = string3.substring(n);
            String[] stringArray3 = string3.split("[\\\\|/]{1}");
            if (string4.length() > 0) {
                this.cwd(string4);
            }
            for (String string5 : stringArray3) {
                if (string5 == null || string5.trim().length() == 0) {
                    this.cwd("/");
                    continue;
                }
                this.sendLine("MKD " + string5);
                String string6 = this.readLine();
                if (!string6.startsWith("257 ") && !string6.startsWith("550 ")) {
                    boolean bl = false;
                    return bl;
                }
                this.cwd(string5);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.cwd(string2);
        }
    }

    public boolean cwdAdd(String string) throws IOException {
        if (string.startsWith("/") || string.startsWith("\\")) {
            string = string.substring(1);
        }
        return this.cwd(this.dir + string);
    }

    public String getDir() {
        return this.dir;
    }

    public static void upload(String string, int n, String string2, String string3, String string4, File ... fileArray) throws IOException {
        SimpleFTP simpleFTP = new SimpleFTP();
        simpleFTP.connect(string, n, string2, string3);
        simpleFTP.bin();
        simpleFTP.cwd(string4);
        for (File file : fileArray) {
            simpleFTP.stor(file);
        }
        simpleFTP.disconnect();
    }

    public static void uploadtoFolderSecure(String string, int n, String string2, String string3, String string4, File ... fileArray) throws IOException {
        SimpleFTP simpleFTP = new SimpleFTP();
        simpleFTP.connect(string, n, string2, string3);
        simpleFTP.bin();
        simpleFTP.cwd(string4);
        for (File file : fileArray) {
            simpleFTP.stor(file);
            File file2 = File.createTempFile("simpleftp_secure", null);
            simpleFTP.download(file.getName(), file2);
            if (!JDHash.getMD5(file2).equalsIgnoreCase(JDHash.getMD5(file))) {
                throw new IOException("MD5 check failed for: " + file);
            }
            if (DEBUG) {
                System.out.println("---- MD5 OK: /" + simpleFTP.getDir() + "" + file.getName() + " -----" + JDHash.getMD5(file2));
            }
            file2.delete();
        }
        simpleFTP.disconnect();
    }

    public static void uploadSecure(String string, int n, String string2, String string3, String string4, File file, File ... fileArray) throws IOException {
        SimpleFTP simpleFTP = new SimpleFTP();
        simpleFTP.connect(string, n, string2, string3);
        simpleFTP.bin();
        long l = 0L;
        long l2 = 0L;
        for (File file2 : fileArray) {
            l += file2.length();
        }
        for (File file2 : fileArray) {
            if (!file2.getAbsolutePath().startsWith(file.getAbsolutePath())) {
                throw new IOException(file2 + " is not part of " + file);
            }
            String string5 = file2.isDirectory() ? file2.getAbsolutePath().substring(file.getAbsolutePath().length()) : file2.getParent().substring(file.getAbsolutePath().length());
            if (!simpleFTP.cwd(SimpleFTP.mergeFolders(string4, string5))) {
                simpleFTP.mkdir(SimpleFTP.mergeFolders(string4, string5));
                if (!simpleFTP.cwd(SimpleFTP.mergeFolders(string4, string5))) {
                    throw new IOException("Unexpected error");
                }
            }
            if (!file2.isDirectory()) {
                File file3 = File.createTempFile("simpleftp_secure", null);
                try {
                    simpleFTP.download(file2.getName(), file3);
                    if (JDHash.getMD5(file3).equalsIgnoreCase(JDHash.getMD5(file2))) {
                        if (!DEBUG) continue;
                        System.out.println("---- Skip .MD5 ok: " + simpleFTP.getDir() + "" + file2.getName() + " -----" + JDHash.getMD5(file3));
                        continue;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                file3.delete();
                simpleFTP.stor(file2);
                simpleFTP.download(file2.getName(), file3);
                if (!JDHash.getMD5(file3).equalsIgnoreCase(JDHash.getMD5(file2))) {
                    throw new IOException("MD5 check failed for: " + file2);
                }
                if (DEBUG) {
                    System.out.println("---- MD5 OK: /" + simpleFTP.getDir() + "" + file2.getName() + " -----" + JDHash.getMD5(file3));
                }
                file3.delete();
            }
            l2 += file2.length();
            if (!DEBUG) continue;
            System.out.println(simpleFTP.host + ": " + l2 * 100L / l + "%");
        }
        simpleFTP.disconnect();
    }

    private static String mergeFolders(String ... stringArray) {
        String string = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            while (string.endsWith("/") || string.endsWith("\\")) {
                string = string.substring(0, string.length() - 1);
            }
            while (stringArray[i].startsWith("/") || stringArray[i].startsWith("\\")) {
                stringArray[i] = stringArray[i].substring(1);
            }
            string = string + "/" + stringArray[i];
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(String string, File file, boolean bl) throws IOException {
        long l = 0L;
        if (!this.binarymode) {
            System.out.println("Warning: Download in ASCII mode may fail!");
        }
        InetSocketAddress inetSocketAddress = this.pasv();
        if (bl && (l = file.length()) > 0L) {
            this.sendLine("REST " + l);
            this.readLines(new int[]{350}, "Resume not supported");
        }
        this.sendLine("RETR " + string);
        ThrottledInputStream throttledInputStream = null;
        RandomAccessFile randomAccessFile = null;
        Socket socket = null;
        try {
            ThrottledConnectionHandler throttledConnectionHandler;
            socket = new Socket();
            socket.setSoTimeout(30000);
            socket.connect(new InetSocketAddress(inetSocketAddress.getHostName(), inetSocketAddress.getPort()), 30000);
            throttledInputStream = new MeteredThrottledInputStream(socket.getInputStream(), new AverageSpeedMeter());
            randomAccessFile = new RandomAccessFile(file, "rw");
            if (l > 0L) {
                randomAccessFile.seek(l);
            }
            if ((throttledConnectionHandler = this.cmanager) != null) {
                throttledConnectionHandler.addThrottledConnection(throttledInputStream);
            }
            String string2 = this.readLines(new int[]{150, 125}, null);
            byte[] byArray = new byte[Short.MAX_VALUE];
            int n = 0;
            long l2 = l;
            while ((n = throttledInputStream.read(byArray)) != -1) {
                if (Thread.currentThread().isInterrupted()) {
                    this.socket.setSoTimeout(20000);
                    this.shutDownSocket(socket);
                    throttledInputStream.close();
                    try {
                        string2 = this.readLine();
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        string2 = "SocketTimeout because of buggy Server";
                    }
                    this.shutDownSocket(socket);
                    throttledInputStream.close();
                    throw new InterruptedIOException();
                }
                l2 += (long)n;
                if (n > 0) {
                    randomAccessFile.write(byArray, 0, n);
                }
                this.broadcaster.fireEvent(new FtpEvent(this, 0, l2));
            }
            this.socket.setSoTimeout(20000);
            this.shutDownSocket(socket);
            throttledInputStream.close();
            try {
                string2 = this.readLine();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                string2 = "SocketTimeout because of buggy Server";
            }
            if (!string2.startsWith("226")) {
                throw new IOException("Download failed: " + string2);
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            socketTimeoutException.printStackTrace();
            this.sendLine("ABOR");
            this.readLine();
            this.download(string, file);
            return;
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
            this.sendLine("ABOR");
            this.readLine();
            this.download(string, file);
            return;
        }
        catch (ConnectException connectException) {
            connectException.printStackTrace();
            this.sendLine("ABOR");
            this.readLine();
            this.download(string, file);
            return;
        }
        finally {
            try {
                throttledInputStream.close();
            }
            catch (Throwable throwable) {}
            try {
                randomAccessFile.close();
            }
            catch (Throwable throwable) {}
            this.shutDownSocket(socket);
        }
    }

    public void download(String string, File file) throws IOException {
        this.download(string, file, false);
    }

    private void shutDownSocket(Socket socket) {
        try {
            socket.shutdownOutput();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            socket.shutdownInput();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            socket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void download(String string, int n, String string2, String string3, String string4, String string5, File file) throws IOException {
        SimpleFTP simpleFTP = new SimpleFTP();
        simpleFTP.connect(string, n, string2, string3);
        simpleFTP.bin();
        simpleFTP.cwd(string4);
        simpleFTP.download(string5, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] list() throws IOException {
        Object object;
        InetSocketAddress inetSocketAddress = this.pasv();
        this.sendLine("LIST");
        Socket socket = null;
        InputStreamReader inputStreamReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            socket = new Socket(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
            inputStreamReader = new InputStreamReader(socket.getInputStream(), "UTF8");
            this.readLines(new int[]{125, 150}, null);
            object = new char[4096];
            int n = 0;
            while ((n = inputStreamReader.read((char[])object)) != -1) {
                if (n <= 0) continue;
                stringBuilder.append((char[])object, 0, n);
            }
        }
        finally {
            try {
                inputStreamReader.close();
            }
            catch (Throwable throwable) {}
            this.shutDownSocket(socket);
        }
        this.readLines(new int[]{226}, null);
        object = new Regex(stringBuilder.toString(), "([-dxrw]+)\\s+(\\d+)\\s+(\\S+)\\s+(\\S+)\\s+(\\d+)\\s+(\\S+\\s+\\S+\\s+\\S+)\\s+(.*?)[$\r\n]+").getMatches();
        if (object == null || ((char[])object).length == 0) {
            object = new Regex(stringBuilder.toString(), "(\\S+)\\s+(\\S+)\\s+(\\d+)\\s+(.*?)[$\r\n]+").getMatches();
        }
        return object;
    }

    public String[] getFileInfo(String string) throws IOException {
        String string2 = string.substring(string.lastIndexOf("/") + 1);
        if (!this.cwd(string = string.substring(0, string.lastIndexOf("/")))) {
            return null;
        }
        for (String[] stringArray : this.list()) {
            if (stringArray.length == 4 && stringArray[3].equals(string2)) {
                return stringArray;
            }
            if (stringArray.length != 7 || !stringArray[6].equals(string2)) continue;
            return stringArray;
        }
        return null;
    }

    public void connect(URL uRL) throws IOException {
        String string = uRL.getHost();
        int n = uRL.getPort();
        if (n <= 0) {
            n = 21;
        }
        if (uRL.getUserInfo() != null) {
            String[] stringArray = uRL.getUserInfo().split(":");
            this.connect(string, n, stringArray[0], stringArray[1]);
        } else {
            this.connect(string, n);
        }
    }
}

