/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils.encoding;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import jd.nutils.encoding.Base64;
import jd.nutils.encoding.HTMLEntities;
import org.appwork.utils.logging.Log;

public class Encoding {
    public static byte[] base16Decode(String string) {
        while (string.length() % 2 > 0) {
            string = string + "0";
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < string.length(); i += 2) {
            byArray[i / 2] = (byte)Integer.parseInt(string.substring(i, i + 2), 16);
        }
        return byArray;
    }

    public static String Base64Decode(String string) {
        if (string == null) {
            return null;
        }
        try {
            byte[] byArray = Base64.decode(string);
            String string2 = new String(byArray);
            if ((double)Encoding.filterString(string2).length() < (double)byArray.length / 1.5) {
                return string;
            }
            return new String(byArray);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String Base64Encode(String string) {
        if (string == null) {
            return null;
        }
        String string2 = new String(Base64.encodeToByte(string.getBytes(), false));
        return string2;
    }

    public static String deepHtmlDecode(String string) {
        String string2;
        String string3 = Encoding.htmlDecode(string);
        int n = 50;
        while (!string3.equals(string2 = Encoding.htmlDecode(string3))) {
            string3 = string2;
            if (n-- > 0) continue;
            System.err.println("Max Decodeingloop 50 reached!!!");
            return string3;
        }
        return string3;
    }

    public static String filterString(String string) {
        return Encoding.filterString(string, "QWERTZUIOP\u00c3\u009cASDFGHJKL\u00c3\u0096\u00c3\u0084YXCVBNMqwertzuiopasdfghjklyxcvbnm\u00c3\u00b6\u00c3\u00a4\u00c3\u00bc;:,._-&$%(){}#~+ 1234567890<>='\"/");
    }

    public static String filterString(String string, String string2) {
        if (string == null || string2 == null) {
            return "";
        }
        byte[] byArray = string.getBytes();
        byte[] byArray2 = string2.getBytes();
        byte[] byArray3 = new byte[byArray.length];
        int n = 0;
        block0: for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            for (byte by2 : byArray2) {
                if (by != by2) continue;
                byArray3[n] = by;
                ++n;
                continue block0;
            }
        }
        return new String(byArray3).trim();
    }

    public static String formEncoding(String string) {
        if (string == null) {
            return null;
        }
        if (Encoding.isUrlCoded(string)) {
            return string.replaceAll(" ", "+");
        }
        return Encoding.urlEncode(string);
    }

    public static String htmlDecode(String string) {
        if (string == null) {
            return null;
        }
        try {
            string = URLDecoder.decode(string, "UTF-8");
        }
        catch (Throwable throwable) {
            Log.exception(throwable);
        }
        return Encoding.htmlOnlyDecode(string);
    }

    public static String htmlOnlyDecode(String string) {
        if (string == null) {
            return null;
        }
        string = HTMLEntities.unhtmlentities(string);
        string = HTMLEntities.unhtmlAmpersand(string);
        string = HTMLEntities.unhtmlAngleBrackets(string);
        string = HTMLEntities.unhtmlDoubleQuotes(string);
        string = HTMLEntities.unhtmlQuotes(string);
        string = HTMLEntities.unhtmlSingleQuotes(string);
        return string;
    }

    public static String cdataEncode(String string) {
        if (string == null) {
            return null;
        }
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        return string;
    }

    public static void main(String[] stringArray) {
        String string = "new encoding &#39";
        System.out.println(string);
    }

    public static boolean isUrlCoded(String string) {
        if (string == null) {
            return false;
        }
        try {
            return URLDecoder.decode(string, "UTF-8").length() != string.length();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String urlDecode(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        if (bl) {
            string = string.replaceAll("%2F", "/");
            string = string.replaceAll("%3A", ":");
            string = string.replaceAll("%3F", "?");
            string = string.replaceAll("%3D", "=");
            string = string.replaceAll("%26", "&");
            string = string.replaceAll("%23", "#");
        } else {
            try {
                string = URLDecoder.decode(string, "UTF-8");
            }
            catch (Exception exception) {
                Log.exception(exception);
            }
        }
        return string;
    }

    public static String urlEncode(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (Exception exception) {
            Log.exception(exception);
            return string;
        }
    }

    public static String urlEncode_light(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                stringBuffer.append("%20");
                continue;
            }
            if (c >= '!' && c <= '&') {
                stringBuffer.append(c);
                continue;
            }
            if (c >= '(' && c <= ';') {
                stringBuffer.append(c);
                continue;
            }
            if (c == '=') {
                stringBuffer.append(c);
                continue;
            }
            if (c >= '?' && c <= '_') {
                stringBuffer.append(c);
                continue;
            }
            if (c >= 'a' && c <= '~') {
                stringBuffer.append(c);
                continue;
            }
            try {
                stringBuffer.append(URLEncoder.encode(String.valueOf(c), "UTF-8"));
                continue;
            }
            catch (Exception exception) {
                Log.exception(exception);
                return string;
            }
        }
        return stringBuffer.toString();
    }

    public static String urlTotalEncode(String string) {
        byte[] byArray = string.getBytes();
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            stringBuilder.append('%');
            String string2 = Integer.toHexString(by);
            stringBuilder.append(string2.substring(string2.length() - 2));
        }
        return stringBuilder + "";
    }

    public static String UTF8Decode(String string) {
        return Encoding.UTF8Decode(string, null);
    }

    public static String UTF8Decode(String string, String string2) {
        if (string == null) {
            return null;
        }
        try {
            if (string2 != null) {
                return new String(string.getBytes(string2), "UTF-8");
            }
            return new String(string.getBytes(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.exception(unsupportedEncodingException);
            return string;
        }
    }

    public static String UTF8Encode(String string) {
        try {
            return new String(string.getBytes("UTF-8"));
        }
        catch (Exception exception) {
            Log.exception(exception);
            return null;
        }
    }
}

