/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.io.IOException;
import java.io.ObjectInputStream;
import jd.config.Property;
import jd.controlling.AccountController;
import jd.plugins.AccountInfo;
import org.jdownloader.DomainInfo;
import org.jdownloader.controlling.UniqueSessionID;

public class Account
extends Property {
    private static final long serialVersionUID = -7578649066389032068L;
    private String user;
    private String pass;
    private boolean enabled = true;
    private boolean valid = true;
    private transient long tmpDisabledIntervalv3 = 600000L;
    private transient boolean tempDisabled = false;
    private transient long tmpDisabledTime = 0L;
    private transient UniqueSessionID ID = new UniqueSessionID();
    private String hoster = null;
    private AccountInfo accinfo = null;
    private boolean active;
    private long updatetime = 0L;
    private int maxDownloads = 0;
    private transient AccountController ac = null;

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    private static final String trim(String string) {
        return string == null ? null : string.trim();
    }

    public void setAccountController(AccountController accountController) {
        this.ac = accountController;
    }

    public AccountController getAccountController() {
        return this.ac;
    }

    public Account(String string, String string2) {
        this.user = Account.trim(string);
        this.pass = Account.trim(string2);
        this.setTmpDisabledIntervalv3(600000L);
    }

    public int getMaxSimultanDownloads() {
        return this.maxDownloads;
    }

    public void setMaxSimultanDownloads(int n) {
        this.maxDownloads = n < 0 ? -1 : n;
    }

    public String getPass() {
        return this.pass;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean bl) {
        this.valid = bl;
    }

    public long lastUpdateTime() {
        return this.updatetime;
    }

    public void setUpdateTime(long l) {
        this.updatetime = l;
    }

    public String getHoster() {
        return this.hoster;
    }

    public void setHoster(String string) {
        this.hoster = string;
    }

    public AccountInfo getAccountInfo() {
        return this.accinfo;
    }

    public void setAccountInfo(AccountInfo accountInfo) {
        this.accinfo = accountInfo;
    }

    public String getUser() {
        return this.user;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.tmpDisabledIntervalv3 = 600000L;
        this.tempDisabled = false;
        this.tmpDisabledTime = 0L;
        this.ID = new UniqueSessionID();
    }

    public UniqueSessionID getID() {
        return this.ID;
    }

    public boolean isTempDisabled() {
        if (this.tempDisabled && System.currentTimeMillis() - this.tmpDisabledTime > this.getTmpDisabledIntervalv3()) {
            this.tempDisabled = false;
        }
        return this.tempDisabled;
    }

    public void setEnabled(boolean bl) {
        if (this.enabled != bl) {
            this.enabled = bl;
            AccountInfo accountInfo = this.accinfo;
            if (bl && (!this.isValid() || accountInfo != null && accountInfo.isExpired())) {
                this.setUpdateTime(0L);
            }
            if (this.ac != null) {
                this.ac.throwUpdateEvent(null, this);
            }
        }
    }

    public void setPass(String string) {
        String string2 = Account.trim(string);
        if (!(this.pass == string2 || this.pass != null && this.pass.equals(string2))) {
            this.pass = string2;
            this.accinfo = null;
            this.setUpdateTime(0L);
            if (this.ac != null) {
                this.ac.throwUpdateEvent(null, this);
            }
        }
    }

    public void setTempDisabled(boolean bl) {
        if (this.tempDisabled != bl) {
            this.tmpDisabledTime = System.currentTimeMillis();
            this.tempDisabled = bl;
            if (this.ac != null) {
                this.ac.throwUpdateEvent(null, this);
            }
        }
    }

    public void setUser(String string) {
        String string2 = Account.trim(string);
        if (!(this.user == string2 || this.user != null && this.user.equals(string2))) {
            this.accinfo = null;
            this.setUpdateTime(0L);
            this.user = string2;
            if (this.ac != null) {
                this.ac.throwUpdateEvent(null, this);
            }
        }
    }

    @Override
    public String toString() {
        return this.user + ":" + this.pass + " " + this.enabled + " " + super.toString();
    }

    public long getTmpDisabledIntervalv3() {
        return this.tmpDisabledIntervalv3;
    }

    public void setTmpDisabledIntervalv3(long l) {
        this.tmpDisabledIntervalv3 = l;
    }

    public boolean equals(Account account) {
        if (account == null) {
            return false;
        }
        if (account == this) {
            return true;
        }
        if (this.user == null ? account.user != null : account.user == null || !this.user.equalsIgnoreCase(account.user)) {
            return false;
        }
        return !(this.pass == null ? account.pass != null : account.pass == null || !this.pass.equalsIgnoreCase(account.pass));
    }

    public DomainInfo getDomainInfo() {
        return DomainInfo.getInstance(this.getHoster());
    }
}

