/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.hoster;

import jd.PluginWrapper;
import jd.http.URLConnectionAdapter;
import jd.nutils.encoding.Encoding;
import jd.plugins.BrowserAdapter;
import jd.plugins.DownloadLink;
import jd.plugins.HostPlugin;
import jd.plugins.PluginException;
import jd.plugins.PluginForHost;
import jd.utils.locale.JDL;
import org.appwork.utils.formatter.SizeFormatter;

@HostPlugin(revision="$Revision: 15419 $", interfaceVersion=2, names={"soundcloud.com"}, urls={"http://(www\\.)?soundclouddecrypted\\.com/[a-z\\-_0-9]+/[a-z\\-_0-9]+"}, flags={0})
public class SoundcloudCom
extends PluginForHost {
    private String url;

    public SoundcloudCom(PluginWrapper pluginWrapper) {
        super(pluginWrapper);
    }

    @Override
    public void correctDownloadLink(DownloadLink downloadLink) {
        downloadLink.setUrlDownload(downloadLink.getDownloadURL().replace("soundclouddecrypted", "soundcloud"));
    }

    @Override
    public String getAGBLink() {
        return "http://soundcloud.com/terms-of-use";
    }

    @Override
    public int getMaxSimultanFreeDownloadNum() {
        return -1;
    }

    @Override
    public void handleFree(DownloadLink downloadLink) throws Exception {
        this.requestFileInformation(downloadLink);
        this.dl = BrowserAdapter.openDownload(this.br, downloadLink, this.url, true, 0);
        this.dl.startDownload();
    }

    @Override
    public DownloadLink.AvailableStatus requestFileInformation(DownloadLink downloadLink) throws Exception {
        this.setBrowserExclusive();
        this.br.getPage(downloadLink.getDownloadURL());
        if (this.br.containsHTML("Oops, looks like we can\\'t find that page")) {
            throw new PluginException(32);
        }
        String string = this.br.getRegex("<em>(.*?)</em>").getMatch(0);
        this.br.setFollowRedirects(true);
        if (string == null) {
            throw new PluginException(0x400000);
        }
        String string2 = this.br.getRegex("\"username\":\"(.*?)\"").getMatch(0);
        string = Encoding.htmlDecode(string.trim());
        String string3 = this.br.getRegex("title=\"Uploaded format\">(.*?)<").getMatch(0);
        if (string3 == null && (string3 = this.br.getRegex("class=\"file\\-type\">(.*?)</span>").getMatch(0)) == null) {
            string3 = "mp3";
        }
        if ((string2 = string2.trim()) != null && !string.contains(string2)) {
            string = string + " - " + string2;
        }
        string = string + "." + string3;
        if (!this.br.containsHTML("class=\"download pl\\-button\"")) {
            String[] stringArray = this.br.getRegex("\"uid\":\"(.*?)\".*?\"token\":\"(.*?)\"").getRow(0);
            this.url = "http://media.soundcloud.com/stream/" + stringArray[0] + "?stream_token=" + stringArray[1];
            URLConnectionAdapter uRLConnectionAdapter = this.br.openGetConnection(this.url);
            if (uRLConnectionAdapter.getContentType().contains("html")) {
                throw new PluginException(0x400000);
            }
            downloadLink.setDownloadSize(uRLConnectionAdapter.getLongContentLength());
            uRLConnectionAdapter.disconnect();
            downloadLink.getLinkStatus().setStatusText(JDL.L("plugins.hoster.SoundCloudCom.status.previewavailable", "Preview is downloadable"));
        } else {
            String string4 = this.br.getRegex("The file you're about to download has a size of (.*?)\"").getMatch(0);
            if (string4 != null) {
                downloadLink.setDownloadSize(SizeFormatter.getSize(string4));
            }
            this.url = downloadLink.getDownloadURL() + "/download";
            downloadLink.getLinkStatus().setStatusText(JDL.L("plugins.hoster.SoundCloudCom.status.downloadavailable", "Original file is downloadable"));
        }
        downloadLink.setFinalFileName(string);
        return DownloadLink.AvailableStatus.TRUE;
    }

    @Override
    public void reset() {
    }

    @Override
    public void resetDownloadlink(DownloadLink downloadLink) {
    }
}

