/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.hoster;

import java.util.HashMap;
import java.util.Map;
import jd.PluginWrapper;
import jd.config.ConfigEntry;
import jd.http.Browser;
import jd.http.Cookie;
import jd.http.Cookies;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;
import jd.parser.html.Form;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.BrowserAdapter;
import jd.plugins.DownloadLink;
import jd.plugins.HostPlugin;
import jd.plugins.PluginException;
import jd.plugins.PluginForDecrypt;
import jd.plugins.PluginForHost;
import jd.plugins.decrypter.TbCm;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

@HostPlugin(revision="$Revision: 16066 $", interfaceVersion=2, names={"youtube.com"}, urls={"httpJDYoutube://[\\w\\.\\-]*?youtube\\.com/(videoplayback\\?.+|get_video\\?.*?video_id=.+&.+(&fmt=\\d+)?)"}, flags={2})
public class Youtube
extends PluginForHost {
    private static final Object lock = new Object();
    private boolean prem = false;
    private static final String IDASFILENAME = "ISASFILENAME";
    private static final String ALLOW_MP3 = "ALLOW_MP3";
    private static final String ALLOW_MP4 = "ALLOW_MP4";
    private static final String ALLOW_WEBM = "ALLOW_WEBM";
    private static final String ALLOW_FLV = "ALLOW_FLV";
    private static final String ALLOW_3GP = "ALLOW_3GP";
    private static final String FAST_CHECK = "FAST_CHECK2";
    private static HashMap<Account, HashMap<String, String>> loginCookies = new HashMap();

    public static String unescape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    c = string.charAt(++i);
                    StringBuilder stringBuilder2 = null;
                    switch (c) {
                        case 'u': {
                            stringBuilder2 = new StringBuilder();
                            int n = ++i + 4;
                            while (i < n) {
                                c = string.charAt(i);
                                if (stringBuilder2.length() > 0 || c != '0') {
                                    stringBuilder2.append(c);
                                }
                                ++i;
                            }
                            --i;
                            stringBuilder.append((char)Long.parseLong(stringBuilder2.toString(), 16));
                            continue block7;
                        }
                        case 'x': {
                            stringBuilder2 = new StringBuilder();
                            int n = ++i + 2;
                            while (i < n) {
                                c = string.charAt(i);
                                stringBuilder2.append(c);
                                ++i;
                            }
                            --i;
                            stringBuilder.append((char)Long.parseLong(stringBuilder2.toString(), 16));
                            continue block7;
                        }
                    }
                    stringBuilder.append(c);
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public Youtube(PluginWrapper pluginWrapper) {
        super(pluginWrapper);
        this.enablePremium("http://www.youtube.com/login?next=/index");
        this.setConfigElements();
    }

    @Override
    public void correctDownloadLink(DownloadLink downloadLink) throws Exception {
        downloadLink.setUrlDownload(downloadLink.getDownloadURL().replaceFirst("httpJDYoutube", "http"));
    }

    @Override
    public AccountInfo fetchAccountInfo(Account account) throws Exception {
        AccountInfo accountInfo = new AccountInfo();
        try {
            this.login(account, this.br, true, true);
        }
        catch (PluginException pluginException) {
            account.setValid(false);
            return accountInfo;
        }
        accountInfo.setStatus(JDL.L("plugins.hoster.youtube.accountok", "Account is OK."));
        accountInfo.setValidUntil(-1L);
        account.setValid(true);
        return accountInfo;
    }

    @Override
    public String getAGBLink() {
        return "http://youtube.com/t/terms";
    }

    @Override
    public String getDescription() {
        return "JDownloader's YouTube Plugin helps downloading VideoClip from youtube.com. YouTube provides different video formats and qualities. JDownloader is able to extract audio after download, and save it as mp3 file. \r\n - Hear your favourite YouTube Clips on your MP3 Player.";
    }

    @Override
    public int getMaxSimultanFreeDownloadNum() {
        return 20;
    }

    @Override
    public void handleFree(DownloadLink downloadLink) throws Exception {
        this.setBrowserExclusive();
        this.prem = false;
        downloadLink.setProperty("valid", false);
        this.requestFileInformation(downloadLink);
        this.br.setDebug(true);
        this.dl = BrowserAdapter.openDownload(this.br, downloadLink, downloadLink.getDownloadURL(), true, 0);
        if (!this.dl.getConnection().isContentDisposition() && !this.dl.getConnection().getContentType().startsWith("video")) {
            downloadLink.setProperty("valid", false);
            this.dl.getConnection().disconnect();
            throw new PluginException(4);
        }
        this.logger.severe("Neembuu could not handle this link/filehost. Using default download system.");
        if (this.dl.startDownload()) {
            this.postprocess(downloadLink);
        }
    }

    @Override
    public void handlePremium(DownloadLink downloadLink, Account account) throws Exception {
        this.login(account, this.br, false, false);
        this.prem = true;
        this.requestFileInformation(downloadLink);
        this.br.setDebug(true);
        this.dl = BrowserAdapter.openDownload(this.br, downloadLink, downloadLink.getDownloadURL(), true, 0);
        if (!this.dl.getConnection().isContentDisposition() && !this.dl.getConnection().getContentType().startsWith("video")) {
            downloadLink.setProperty("valid", false);
            this.dl.getConnection().disconnect();
            throw new PluginException(4);
        }
        if (this.dl.startDownload()) {
            this.postprocess(downloadLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(Account account, Browser browser, boolean bl, boolean bl2) throws Exception {
        Object object = lock;
        synchronized (object) {
            if (browser == null) {
                browser = this.br;
            }
            try {
                String string;
                String[] stringArray;
                Object object2;
                browser.setDebug(true);
                this.setBrowserExclusive();
                if (!bl && loginCookies.containsKey(account) && (object2 = loginCookies.get(account)) != null && ((HashMap)object2).containsKey("LOGIN_INFO")) {
                    for (Map.Entry<String, String> entry : ((HashMap)object2).entrySet()) {
                        String string2 = entry.getKey();
                        String string3 = entry.getValue();
                        browser.setCookie("youtube.com", string2, string3);
                    }
                    return;
                }
                browser.setFollowRedirects(true);
                browser.getPage("http://www.youtube.com/");
                browser.getPage("https://www.google.com/accounts/ServiceLogin?uilel=3&service=youtube&passive=true&continue=http%3A%2F%2Fwww.youtube.com%2Fsignin%3Faction_handle_signin%3Dtrue%26nomobiletemp%3D1%26hl%3Den_US%26next%3D%252Findex&hl=en_US&ltmpl=sso");
                object2 = browser.getRegex("iframeUri: '(https.*?)'").getMatch(0);
                if (object2 != null) {
                    object2 = Youtube.unescape((String)object2);
                    browser.cloneBrowser().getPage((String)object2);
                }
                Form form = browser.getForm(0);
                form.put("pstMsg", "1");
                form.put("dnConn", "https%3A%2F%2Faccounts.youtube.com&continue=http%3A%2F%2Fwww.youtube.com%2Fsignin%3Faction_handle_signin%3Dtrue%26nomobiletemp%3D1%26hl%3Den_US%26next%3D%252F");
                form.put("Email", Encoding.urlEncode(account.getUser()));
                form.put("Passwd", Encoding.urlEncode(account.getPass()));
                form.put("GALX", browser.getCookie("http://www.google.com", "GALX"));
                form.put("timeStmp", "");
                form.put("secTok", "");
                form.put("rmShown", "1");
                form.put("signIn", "Anmelden");
                form.put("asts", "");
                browser.setFollowRedirects(false);
                String string4 = browser.getCookie("http://www.google.com", "GALX");
                if (string4 == null) {
                    throw new PluginException(0x400000);
                }
                browser.submitForm(form);
                if (browser.getRedirectLocation() == null) {
                    stringArray = Encoding.htmlDecode(browser.toString());
                    string = new Regex((String)stringArray, "url='(http://.*?)'").getMatch(0);
                    if (string == null) {
                        account.setValid(false);
                        throw new PluginException(256, 1L);
                    }
                    browser.getPage(string);
                }
                browser.getPage(browser.getRedirectLocation());
                if (browser.containsHTML("Google will check if this")) {
                    account.setValid(false);
                    throw new PluginException(256, 1L);
                }
                stringArray = browser.getRegex("DOMAIN_SETTINGS.*?uri: '(https.*?)'").getColumn(0);
                string = browser.getRegex("CONTINUE_URL = '(http.*?)'").getMatch(0);
                if (stringArray == null || string == null) {
                    account.setValid(false);
                    throw new PluginException(256, 1L);
                }
                for (String object3 : stringArray) {
                    browser.cloneBrowser().getPage(Youtube.unescape(object3));
                }
                browser.getPage(Youtube.unescape(string));
                if (browser.getRedirectLocation() != null) {
                    browser.getPage(browser.getRedirectLocation());
                }
                browser.getPage("http://www.youtube.com/index?hl=en");
                if (browser.getRedirectLocation() != null) {
                    browser.getPage(browser.getRedirectLocation());
                }
                if (browser.getCookie("http://www.youtube.com", "LOGIN_INFO") == null) {
                    account.setValid(false);
                    throw new PluginException(256, 1L);
                }
                HashMap hashMap = new HashMap();
                Cookies cookies = browser.getCookies("youtube.com");
                for (Cookie cookie : cookies.getCookies()) {
                    hashMap.put(cookie.getKey(), cookie.getValue());
                }
                loginCookies.put(account, hashMap);
            }
            catch (PluginException pluginException) {
                loginCookies.remove(account);
                throw pluginException;
            }
        }
    }

    private void postprocess(DownloadLink downloadLink) {
        if (downloadLink.getProperty("convertto") != null) {
            TbCm.DestinationFormat destinationFormat = TbCm.DestinationFormat.valueOf(downloadLink.getProperty("convertto").toString());
            TbCm.DestinationFormat destinationFormat2 = TbCm.DestinationFormat.VIDEOFLV;
            if (destinationFormat.equals((Object)TbCm.DestinationFormat.VIDEOWEBM) || destinationFormat.equals((Object)TbCm.DestinationFormat.VIDEOMP4) || destinationFormat.equals((Object)TbCm.DestinationFormat.VIDEO3GP)) {
                destinationFormat2 = destinationFormat;
            }
            if (destinationFormat.equals((Object)TbCm.DestinationFormat.AUDIOAAC)) {
                destinationFormat2 = TbCm.DestinationFormat.VIDEOMP4;
            }
            if (!TbCm.ConvertFile(downloadLink, destinationFormat2, destinationFormat)) {
                this.logger.severe("Video-Convert failed!");
            }
        }
    }

    @Override
    public DownloadLink.AvailableStatus requestFileInformation(DownloadLink downloadLink) throws Exception {
        if (downloadLink.getBooleanProperty("valid", true).booleanValue()) {
            downloadLink.setFinalFileName(downloadLink.getStringProperty("name", "video.tmp"));
            downloadLink.setDownloadSize((Long)downloadLink.getProperty("size", 0L));
            return DownloadLink.AvailableStatus.TRUE;
        }
        downloadLink.setFinalFileName(downloadLink.getStringProperty("name", "video.tmp"));
        downloadLink.setDownloadSize((Long)downloadLink.getProperty("size", 0L));
        PluginForDecrypt pluginForDecrypt = JDUtilities.getPluginForDecrypt("youtube.com");
        if (pluginForDecrypt == null) {
            throw new PluginException(0x400000, "cannot decrypt videolink");
        }
        if (downloadLink.getStringProperty("fmtNew", null) == null) {
            throw new PluginException(131072, "You have to add link again");
        }
        if (downloadLink.getStringProperty("videolink", null) == null) {
            throw new PluginException(131072, "You have to add link again");
        }
        HashMap<Integer, String[]> hashMap = ((TbCm)pluginForDecrypt).getLinks(downloadLink.getStringProperty("videolink", null), this.prem, this.br);
        if (hashMap.isEmpty()) {
            if (this.br.containsHTML("<div\\s+id=\"verify-age-actions\">")) {
                throw new PluginException(131072, "The entered account couldn't pass the age verification!");
            }
            throw new PluginException(32);
        }
        downloadLink.setUrlDownload(hashMap.get(downloadLink.getIntegerProperty("fmtNew", 0))[0]);
        return DownloadLink.AvailableStatus.TRUE;
    }

    @Override
    public void reset() {
    }

    @Override
    public void resetDownloadlink(DownloadLink downloadLink) {
        downloadLink.setFinalFileName(downloadLink.getStringProperty("name", "video.tmp"));
        downloadLink.setDownloadSize((Long)downloadLink.getProperty("size", 0L));
        downloadLink.setProperty("valid", false);
    }

    @Override
    public void resetPluginGlobals() {
    }

    private void setConfigElements() {
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), FAST_CHECK, JDL.L("plugins.hoster.youtube.fast", "Fast LinkCheck?")).setDefaultValue(false));
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), IDASFILENAME, JDL.L("plugins.hoster.youtube.idasfilename", "Use Video-ID as filename?")).setDefaultValue(false));
        this.getConfig().addEntry(new ConfigEntry(6));
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), ALLOW_WEBM, JDL.L("plugins.hoster.youtube.checkwebm", "Grab WEBM?")).setDefaultValue(true));
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), ALLOW_MP4, JDL.L("plugins.hoster.youtube.checkmp4", "Grab MP4?")).setDefaultValue(true));
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), ALLOW_MP3, JDL.L("plugins.hoster.youtube.checkmp3", "Grab MP3?")).setDefaultValue(true));
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), ALLOW_FLV, JDL.L("plugins.hoster.youtube.checkflv", "Grab FLV?")).setDefaultValue(true));
        this.getConfig().addEntry(new ConfigEntry(3, this.getPluginConfig(), ALLOW_3GP, JDL.L("plugins.hoster.youtube.check3gp", "Grab 3GP?")).setDefaultValue(true));
    }
}

