/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.controlling.JDLogger;

public final class JDHexUtils {
    static final byte[] HEX_CHAR_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    public static final String REGEX_FIND_ALL_HEX = "[[a-fA-F0-9]{2}]*?";
    public static final String REGEX_MATCH_ALL_HEX = "([[a-fA-F0-9]{2}]*?)";
    public static final String REGEX_HTTP_NEWLINE = JDHexUtils.getHexString("\r") + "{1}" + JDHexUtils.getHexString("\n") + "{1}";
    public static final Pattern PATTERN_JAVASCRIPT_HEX = Pattern.compile("\\\\x([a-f0-9]{2})", 2);

    private JDHexUtils() {
    }

    public static String toString(String string) {
        if (string == null) {
            return null;
        }
        return new String(JDHexUtils.getByteArray(string));
    }

    public static String decodeJavascriptHex(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = PATTERN_JAVASCRIPT_HEX.matcher(string);
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, JDHexUtils.toString(matcher.group(1)));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static byte[] getByteArray(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        byte[] byArray = new byte[(n + 1) / 2];
        boolean bl = true;
        byte by = 0;
        int n2 = 0;
        if (n % 2 == 1) {
            bl = false;
        }
        for (int i = 0; i < n; ++i) {
            int n3;
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') {
                n3 = c - 48;
            } else if (c >= 'A' && c <= 'F') {
                n3 = c - 65 + 10;
            } else if (c >= 'a' && c <= 'f') {
                n3 = c - 97 + 10;
            } else {
                throw new NumberFormatException("Invalid hex digit '" + c + "'.");
            }
            if (bl) {
                by = (byte)(n3 << 4);
            } else {
                by = (byte)(by + (byte)n3);
                byArray[n2++] = by;
            }
            bl = !bl;
        }
        return byArray;
    }

    public static String getHexString(byte[] byArray) {
        byte[] byArray2 = new byte[2 * byArray.length];
        int n = 0;
        for (byte by : byArray) {
            int n2 = by & 0xFF;
            byArray2[n++] = HEX_CHAR_TABLE[n2 >>> 4];
            byArray2[n++] = HEX_CHAR_TABLE[n2 & 0xF];
        }
        try {
            return new String(byArray2, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDLogger.exception(unsupportedEncodingException);
            return null;
        }
    }

    public static String getHexString(String string) {
        if (string == null) {
            return null;
        }
        try {
            byte[] byArray = string.getBytes("ASCII");
            byte[] byArray2 = new byte[2 * byArray.length];
            int n = 0;
            for (byte by : byArray) {
                int n2 = by & 0xFF;
                byArray2[n++] = HEX_CHAR_TABLE[n2 >>> 4];
                byArray2[n++] = HEX_CHAR_TABLE[n2 & 0xF];
            }
            return new String(byArray2, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDLogger.exception(unsupportedEncodingException);
            return null;
        }
    }
}

