/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.text.DecimalFormat;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jd.Launcher;
import jd.config.Configuration;
import jd.config.DatabaseConnector;
import jd.controlling.JDController;
import jd.controlling.JDLogger;
import jd.nutils.Executer;
import jd.nutils.Formatter;
import jd.nutils.io.JDIO;
import jd.plugins.PluginForDecrypt;
import jd.plugins.PluginForHost;
import org.appwork.utils.Application;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.plugins.controller.crawler.CrawlerPluginController;
import org.jdownloader.plugins.controller.crawler.LazyCrawlerPlugin;
import org.jdownloader.plugins.controller.host.HostPluginController;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;
import org.jdownloader.translate._JDT;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class JDUtilities {
    private static Configuration CONFIGURATION = null;
    private static DatabaseConnector DB_CONNECT = null;
    public static final int RUNTYPE_LOCAL = 1;
    public static final int RUNTYPE_LOCAL_JARED = 2;
    private static File JD_HOME = null;
    private static String REVISION;
    private static long REVISIONINT;

    public static void addToGridBag(Container container, Component component, int n, int n2, int n3, int n4, int n5, int n6, Insets insets, int n7, int n8) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
        gridBagConstraints.fill = n7;
        gridBagConstraints.anchor = n8;
        if (insets != null) {
            gridBagConstraints.insets = insets;
        }
        container.add(component, gridBagConstraints);
    }

    public static synchronized Configuration getConfiguration() {
        if (CONFIGURATION == null) {
            Object object = JDUtilities.getDatabaseConnector().getData("jdownloaderconfig");
            CONFIGURATION = object != null ? (Configuration)object : new Configuration();
        }
        return CONFIGURATION;
    }

    public static void setDB_CONNECT(DatabaseConnector databaseConnector) {
        DB_CONNECT = databaseConnector;
    }

    public static void setJDHomeDirectory(File file) {
        if (file == null) {
            return;
        }
        JD_HOME = file;
    }

    @Deprecated
    public static JDController getController() {
        return JDController.getInstance();
    }

    public static String getJACMethodsDirectory() {
        return "jd/captcha/methods/";
    }

    public static File getJDHomeDirectoryFromEnvironment() {
        if (JD_HOME != null) {
            return JD_HOME;
        }
        Application.setApplication(".jd_home");
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(Launcher.class.getName().replace(".", "/") + ".class");
        if (uRL == null) {
            throw new NullPointerException("jd/Main.class not found");
        }
        JD_HOME = new File(Application.getRoot(Launcher.class));
        if (!JD_HOME.exists()) {
            JD_HOME.mkdirs();
        }
        return JD_HOME;
    }

    public static String getJDTitle(int n) {
        StringBuilder stringBuilder = new StringBuilder("JDownloader");
        if (n > 0) {
            stringBuilder.append(new char[]{' ', '('});
            stringBuilder.append(_JDT._.gui_mainframe_title_updatemessage2(n));
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    public static String getPercent(long l, long l2) {
        return new DecimalFormat("0.00").format(100.0 * (double)l / (double)l2) + "%";
    }

    public static PluginForDecrypt getPluginForDecrypt(String string) {
        LazyCrawlerPlugin lazyCrawlerPlugin = CrawlerPluginController.getInstance().get(string);
        if (lazyCrawlerPlugin != null) {
            return (PluginForDecrypt)lazyCrawlerPlugin.getPrototype();
        }
        return null;
    }

    public static PluginForHost getPluginForHost(String string) {
        LazyHostPlugin lazyHostPlugin = HostPluginController.getInstance().get(string);
        if (lazyHostPlugin != null) {
            return (PluginForHost)lazyHostPlugin.getPrototype();
        }
        return null;
    }

    public static PluginForHost getNewPluginForHostInstance(String string) {
        LazyHostPlugin lazyHostPlugin = HostPluginController.getInstance().get(string);
        if (lazyHostPlugin != null) {
            return lazyHostPlugin.newInstance();
        }
        return null;
    }

    public static String getRevision() {
        return REVISION != null ? REVISION : (REVISION = JDUtilities.getRevisionNumber() + "");
    }

    public static long getRevisionNumber() {
        if (REVISIONINT != -1L) {
            return REVISIONINT;
        }
        int n = -1;
        try {
            n = Formatter.filterInt(JDIO.readFileToString(JDUtilities.getResourceFile("config/version.cfg")));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        long l = Formatter.getRevision("$Revision: 16116 $");
        REVISIONINT = Math.max(l, (long)n);
        return REVISIONINT;
    }

    public static int getRunType() {
        String string = Thread.currentThread().getContextClassLoader().getResource("jd") + "";
        return string.matches("jar\\:.*\\.jar\\!.*") ? 2 : 1;
    }

    public static File getResourceFile(String string) {
        return Application.getResource(string);
    }

    public static File getResourceFile(String string, boolean bl) {
        File file = JDUtilities.getResourceFile(string);
        if (file != null) {
            File file2;
            if (bl && (file2 = file.getParentFile()) != null && !file2.exists()) {
                file2.mkdirs();
            }
            return file;
        }
        return null;
    }

    public static String runCommand(String string, String[] stringArray, String string2, int n) {
        Executer executer = new Executer(string);
        executer.addParameters(stringArray);
        executer.setRunin(string2);
        executer.setWaitTimeout(n);
        executer.start();
        executer.waitTimeout();
        return executer.getOutputStream() + " \r\n " + executer.getErrorStream();
    }

    public static void setConfiguration(Configuration configuration) {
        CONFIGURATION = configuration;
    }

    public static String removeEndingPoints(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        while (string2.endsWith(".")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public static synchronized DatabaseConnector getDatabaseConnector() {
        if (DB_CONNECT != null) {
            return DB_CONNECT;
        }
        if (DB_CONNECT == null) {
            try {
                DB_CONNECT = new DatabaseConnector();
            }
            catch (Exception exception) {
                JDLogger.exception(exception);
                String string = JDUtilities.getJDHomeDirectoryFromEnvironment().getAbsolutePath() + "/config/";
                if (!(exception.getMessage().equals("Database broken!") && new File(string + "database.script").delete() && new File(string + "database.properties").delete())) {
                    // empty if block
                }
                try {
                    DB_CONNECT = new DatabaseConnector();
                }
                catch (Exception exception2) {
                    JDLogger.exception(exception2);
                    System.exit(1);
                }
            }
        }
        return DB_CONNECT;
    }

    public static Document parseXmlString(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(bl);
            InputSource inputSource = new InputSource(new StringReader(string));
            Document document = documentBuilderFactory.newDocumentBuilder().parse(inputSource);
            return document;
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
            return null;
        }
    }

    public static String createXmlString(Document document) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult streamResult = new StreamResult(new StringWriter());
            DOMSource dOMSource = new DOMSource(document);
            transformer.transform(dOMSource, streamResult);
            return streamResult.getWriter().toString();
        }
        catch (TransformerException transformerException) {
            JDLogger.exception(transformerException);
            return null;
        }
    }

    public static String getAttribute(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null || namedNodeMap.getNamedItem(string) == null) {
            return null;
        }
        return namedNodeMap.getNamedItem(string).getNodeValue();
    }

    @Deprecated
    public static void openExplorer(File file) {
        CrossSystem.openFile(file);
    }

    static {
        REVISIONINT = -1L;
    }
}

