/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.controlling;

import org.appwork.controlling.State;
import org.appwork.controlling.StateMachine;
import org.appwork.controlling.StateMachineInterface;
import org.appwork.utils.logging.Log;

public class SingleReachableState {
    private StateMachine stateMachine = new StateMachine(new StateMachineInterface(){

        @Override
        public StateMachine getStateMachine() {
            return SingleReachableState.this.stateMachine;
        }
    }, WAITING, REACHED);
    private static State WAITING = new State("WAITING");
    private static State REACHED = new State("REACHED");
    private String name;

    public SingleReachableState(String string) {
        this.name = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWhenReached(final Runnable runnable) {
        if (runnable == null) {
            return;
        }
        boolean bl = true;
        if (this.stateMachine != null) {
            SingleReachableState singleReachableState = this;
            synchronized (singleReachableState) {
                if (this.stateMachine == null) {
                    bl = true;
                } else {
                    bl = false;
                    this.stateMachine.executeOnceOnState(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                runnable.run();
                            }
                            catch (Throwable throwable) {
                                Log.exception(throwable);
                            }
                        }
                    }, REACHED);
                }
            }
        }
        if (bl) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                Log.exception(throwable);
            }
        }
    }

    public synchronized boolean isReached() {
        return this.stateMachine == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReached() {
        if (this.stateMachine == null) {
            return;
        }
        SingleReachableState singleReachableState = this;
        synchronized (singleReachableState) {
            if (this.stateMachine == null) {
                return;
            }
            this.stateMachine.setStatus(REACHED);
            this.stateMachine = null;
        }
    }

    public String toString() {
        return "SingleReachableState: " + this.name + " reached:" + (this.stateMachine == null);
    }

    static {
        WAITING.addChildren(REACHED);
    }
}

