/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.formatter;

import java.text.DecimalFormat;
import java.util.regex.Pattern;
import org.appwork.utils.Regex;
import org.appwork.utils.locale._AWU;

public class SizeFormatter {
    public static String formatBytes(long l) {
        long l2 = Math.abs(l);
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        if (l2 >= 0x10000000000L) {
            return _AWU.T.literally_tebibyte(decimalFormat.format((double)l / 1.099511627776E12));
        }
        if (l2 >= 0x40000000L) {
            return _AWU.T.literally_gibibyte(decimalFormat.format((double)l / 1.073741824E9));
        }
        if (l2 >= 0x100000L) {
            return _AWU.T.literally_mebibyte(decimalFormat.format((double)l / 1048576.0));
        }
        if (l2 >= 1024L) {
            return _AWU.T.literally_kibibyte(decimalFormat.format((double)l / 1024.0));
        }
        return _AWU.T.literally_byte(l);
    }

    public static Unit getBestUnit(long l) {
        long l2 = Math.abs(l);
        if (l2 >= 0x10000000000L) {
            return Unit.TB;
        }
        if (l2 >= 0x40000000L) {
            return Unit.GB;
        }
        if (l2 >= 0x100000L) {
            return Unit.MB;
        }
        if (l2 >= 1024L) {
            return Unit.KB;
        }
        return Unit.B;
    }

    public static long getSize(String string) {
        return SizeFormatter.getSize(string, true, false);
    }

    public static long getSize(String string, boolean bl, boolean bl2) {
        String[][] stringArray;
        boolean bl3 = false;
        if (bl2) {
            bl3 = Pattern.compile("\\D*\\-.*").matcher(string).matches();
        }
        int n = 1000;
        if (bl) {
            n = 1024;
        }
        if ((stringArray = new Regex(string, Pattern.compile("([\\d]+)[\\.|\\,|\\:]([\\d]+)", 2)).getMatches()) == null || stringArray.length == 0) {
            stringArray = new Regex(string, Pattern.compile("([\\d]+)", 2)).getMatches();
        }
        if (stringArray == null || stringArray.length == 0) {
            return -1L;
        }
        double d = 0.0;
        if (stringArray[0].length == 1) {
            d = Double.parseDouble(stringArray[0][0]);
        }
        if (stringArray[0].length == 2) {
            d = Double.parseDouble(stringArray[0][0] + "." + stringArray[0][1]);
        }
        if (Regex.matches((Object)string, Pattern.compile("(tb|tbyte|tig|tib)", 2))) {
            d *= (double)(n * n * n * n);
        } else if (Regex.matches((Object)string, Pattern.compile("(gb|gbyte|gig|gib)", 2))) {
            d *= (double)(n * n * n);
        } else if (Regex.matches((Object)string, Pattern.compile("(mb|mbyte|megabyte|mib)", 2))) {
            d *= (double)(n * n);
        } else if (Regex.matches((Object)string, Pattern.compile("(kb|kbyte|kilobyte|kib)", 2))) {
            d *= (double)n;
        }
        return bl3 ? -1L * Math.round(d) : Math.round(d);
    }

    public static long getSize(String string, boolean bl) {
        return SizeFormatter.getSize(string, bl, false);
    }

    public static enum Unit {
        TB(0x10000000000L),
        GB(0x40000000L),
        MB(0x100000L),
        KB(1024L),
        B(1L);

        private long bytes;

        private Unit(long l) {
            this.bytes = l;
        }

        public long getBytes() {
            return this.bytes;
        }
    }
}

