/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.locale;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storage;
import org.appwork.utils.Application;
import org.appwork.utils.locale.Translate;
import org.appwork.utils.logging.Log;

@Deprecated
public class Loc {
    public static final Storage CFG = JSonStorage.getStorage("Locale");
    private static HashMap<Integer, String> DATA = null;
    private static String DEFAULT_LOCALE_CACHE;
    private static final String FALLBACK_LOCALE = "en_GB";
    private static String locale;
    public static final String PROPERTY_LOCALE = "PROPERTY_LOCALE2";

    public static String _(Translate translate) {
        return translate.s();
    }

    public static String _(Translate translate, Object ... objectArray) {
        return translate.s(objectArray);
    }

    private static String getDefaultLocale() {
        if (DEFAULT_LOCALE_CACHE != null) {
            return DEFAULT_LOCALE_CACHE;
        }
        String string = System.getProperty("user.language").toLowerCase();
        String string2 = System.getProperty("user.country").toUpperCase();
        String[] stringArray = Loc.getLocales();
        if (stringArray.length == 0) {
            DEFAULT_LOCALE_CACHE = FALLBACK_LOCALE;
        }
        if (DEFAULT_LOCALE_CACHE == null) {
            for (String string3 : stringArray) {
                if (!string3.equals(string + "_" + string2)) continue;
                DEFAULT_LOCALE_CACHE = string3;
                break;
            }
        }
        if (DEFAULT_LOCALE_CACHE == null) {
            for (String string3 : stringArray) {
                if (!string3.equals(string)) continue;
                DEFAULT_LOCALE_CACHE = string3;
                break;
            }
        }
        if (DEFAULT_LOCALE_CACHE == null) {
            for (String string3 : stringArray) {
                if (!string3.startsWith(string + "_")) continue;
                DEFAULT_LOCALE_CACHE = string3;
                break;
            }
        }
        if (DEFAULT_LOCALE_CACHE == null) {
            for (String string3 : stringArray) {
                if (!string3.equals(FALLBACK_LOCALE)) continue;
                DEFAULT_LOCALE_CACHE = string3;
                break;
            }
        }
        if (DEFAULT_LOCALE_CACHE == null) {
            DEFAULT_LOCALE_CACHE = stringArray[0];
        }
        return DEFAULT_LOCALE_CACHE;
    }

    public static String getErrorRegex() {
        return Loc.L("system.error", ".*(error|failed).*");
    }

    public static String getLocale() {
        return locale;
    }

    public static String[] getLocales() {
        ArrayList<String> arrayList;
        block8: {
            arrayList = new ArrayList<String>();
            String[] stringArray = Application.getResource("languages/").list(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.endsWith(".loc");
                }
            });
            if (stringArray != null) {
                for (String string : stringArray) {
                    arrayList.add(string.substring(0, string.length() - 4));
                }
            }
            try {
                Object object = Application.getRessourceURL("languages/");
                if (object == null) break block8;
                Enumeration<URL> enumeration = Thread.currentThread().getContextClassLoader().getResources("languages/");
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    if (((URL)object).getProtocol().equalsIgnoreCase("jar")) {
                        JarEntry jarEntry;
                        String[] stringArray2 = ((URL)object).getPath();
                        int n = stringArray2.lastIndexOf(33);
                        String string = stringArray2.substring(0, n);
                        String string2 = stringArray2.substring(n + 2);
                        JarInputStream jarInputStream = new JarInputStream(new FileInputStream(new File(new URL(string).toURI())));
                        while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                            String string3 = jarEntry.getName();
                            if (!string3.startsWith(string2) || !string3.endsWith(".loc")) continue;
                            String string4 = new File(string3).getName();
                            string4 = string4.substring(0, string4.length() - 4);
                            arrayList.remove(string4);
                            arrayList.add(string4);
                        }
                        continue;
                    }
                    stringArray = new File(((URL)object).toURI()).list(new FilenameFilter(){

                        @Override
                        public boolean accept(File file, String string) {
                            return string.endsWith(".loc");
                        }
                    });
                    if (stringArray == null) continue;
                    for (String string2 : stringArray) {
                        arrayList.add(string2.substring(0, string2.length() - 4));
                    }
                }
            }
            catch (Exception exception) {
                Log.exception(exception);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public static URL getResourceURL(String string) throws MalformedURLException {
        File file = Application.getResource("languages/" + string + ".loc");
        URL uRL = Application.getRessourceURL("languages/" + string + ".loc");
        if (file.exists() && file.length() > 0L || uRL == null) {
            uRL = file.toURI().toURL();
        }
        return uRL;
    }

    public static String L(String string, String string2) {
        String string3;
        if (string == null || (string = string.trim()).length() == 0) {
            throw new IllegalArgumentException();
        }
        if (DATA == null) {
            Log.L.warning("No parsed localization found! Loading now from saved localization file!");
            try {
                Loc.setLocale(CFG.get(PROPERTY_LOCALE, FALLBACK_LOCALE));
            }
            catch (Exception exception) {
                Log.L.severe("Error while loading the stored localization name!");
                Loc.setLocale(FALLBACK_LOCALE);
            }
            if (DATA == null) {
                return string2 == null ? "Error in Loc! No loaded data!" : string2;
            }
        }
        if ((string3 = DATA.get(string.toLowerCase().hashCode())) == null) {
            DATA.put(string.toLowerCase().hashCode(), string2);
            return string2;
        }
        return string3;
    }

    public static String LF(String string, String string2, Object ... objectArray) {
        try {
            return String.format(Loc.L(string, string2), objectArray);
        }
        catch (Exception exception) {
            return "Error: " + string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseLocalization(URL uRL) throws IllegalArgumentException {
        if (uRL == null) {
            throw new IllegalArgumentException();
        }
        if (DATA != null) {
            Log.L.finer("Previous HashMap will be overwritten!");
        }
        DATA = new HashMap();
        BufferedReader bufferedReader = null;
        InputStreamReader inputStreamReader = null;
        InputStream inputStream = null;
        try {
            String string;
            inputStream = uRL.openStream();
            inputStreamReader = new InputStreamReader(inputStream, "UTF8");
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((string = bufferedReader.readLine()) != null) {
                int n;
                if (string.startsWith("#") || (n = string.indexOf(61)) <= 0) continue;
                String string2 = string.substring(0, n).toLowerCase().trim();
                String string3 = string.substring(n + 1).trim();
                string3 = string3.replace("\\n", "\n").replace("\\r", "\r");
                DATA.put(string2.hashCode(), string3);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException(fileNotFoundException);
        }
        catch (Exception exception) {
            Log.exception(exception);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Throwable throwable) {}
            try {
                inputStreamReader.close();
            }
            catch (Throwable throwable) {}
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static void setLocale(String string) {
        try {
            if (string == null) {
                string = CFG.get(PROPERTY_LOCALE, Loc.getDefaultLocale());
            }
            URL uRL = Loc.getResourceURL(string);
            locale = string;
            if (uRL != null) {
                String[] stringArray = string.split("_");
                if (stringArray.length == 1) {
                    Locale.setDefault(new Locale(stringArray[0]));
                } else {
                    Locale.setDefault(new Locale(stringArray[0], stringArray[1]));
                }
                CFG.put(PROPERTY_LOCALE, string);
                Loc.parseLocalization(uRL);
            } else {
                Log.L.info("The language " + string + " isn't available! Parsing default (" + FALLBACK_LOCALE + ".loc) one!");
                locale = Loc.getDefaultLocale();
                String[] stringArray = locale.split("_");
                Locale.setDefault(new Locale(stringArray[0], stringArray[1]));
                Loc.parseLocalization(Loc.getResourceURL(FALLBACK_LOCALE));
            }
        }
        catch (Exception exception) {
            Log.exception(exception);
        }
    }
}

