/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.locale;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.locale.Loc;
import org.appwork.utils.locale.Translate;
import org.appwork.utils.parser.SourceParser;

public class TranslateUtils {
    public static String checkTranslateFiles(SourceParser sourceParser, Class<?> clazz, boolean bl) throws Exception {
        String string = clazz.getName().replaceAll("\\.", "/") + ".java";
        final File file = new File(sourceParser.getSource(), string);
        if (!file.exists()) {
            throw new Exception("File " + file + " does not exist");
        }
        sourceParser.setFilter(new FilenameFilter(){

            @Override
            public boolean accept(File file2, String string) {
                return !new File(file2, string).equals(file);
            }
        });
        sourceParser.scan();
        String string2 = IO.readFileToString(file);
        Regex regex = new Regex(string2, "(.*?\\{)");
        String string3 = regex.getMatch(0);
        String string4 = new Regex(string2, "(//\\s*ENDOFENUMS.*)").getMatch(0);
        string2 = string2.replace(string3, "<pre>");
        if (string4 == null) {
            throw new Exception("Translate Enum must end with //ENDOFENUMS");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string3);
        for (Field field : clazz.getDeclaredFields()) {
            String string5;
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
            HashMap<File, String> hashMap = sourceParser.findOccurancesOf(field);
            if (hashMap.size() == 0) {
                System.out.println("Filtered: " + field);
                continue;
            }
            stringBuilder.append("\r\n");
            String string6 = new Regex(string2, field.getName() + "\\s*\\(\"[^\r^\n]*?(?<!\\\\)\"\\, \\d+\\)[\\,\\;]").getMatch(-1);
            if (string6 == null) {
                string6 = new Regex(string2, field.getName() + "\\s*\\(\"[^\r^\n]*?(?<!\\\\)\"\\)[\\,\\;]").getMatch(-1);
            }
            if (string6.contains("CHATPANEL_HISTORY_LASTWEEK")) {
                System.out.println("fdsf");
            }
            if ((string5 = new Regex(string2, "\\/\\*(.*?)\\*\\/\\s*" + Pattern.quote(string6)).getMatch(0)) != null) {
                if (string5.contains("/*")) {
                    string5 = TranslateUtils.handleMultiComment(string5);
                }
                if (string5.contains("Kontakt hinzuf\u00c3\u00bcgen")) {
                    System.out.println("fdsf");
                }
                stringBuilder.append("/*\r\n");
                stringBuilder.append(string5.trim());
                stringBuilder.append("\r\n*/\r\n");
                String string7 = new Regex(string2, "(\\/\\*.*?\\*\\/\\s*" + Pattern.quote(string6) + ")").getMatch(0);
                string2 = string2.replace(string7, "---\r\n" + string6);
            }
            stringBuilder.append(string6);
        }
        stringBuilder.append("");
        stringBuilder.append("\r\n");
        stringBuilder.append(string4);
        System.out.println(stringBuilder);
        if (bl) {
            file.delete();
            IO.writeStringToFile(file, stringBuilder.toString());
        }
        return stringBuilder.toString();
    }

    private static int countWildcards(String string) {
        int n = 0;
        int n2 = 0;
        while (n != -1) {
            if ((n = string.indexOf("%s", n)) == -1) continue;
            n += 2;
            ++n2;
        }
        return n2;
    }

    public static String createLocFile(String string, File[] fileArray, Class<?>[] classArray) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\r\n####  Translation: " + string + "\r\n");
        Loc.setLocale(string);
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz = classArray[i];
            File file = new File(fileArray[i], clazz.getName().replaceAll("\\.", "/") + ".java");
            String string2 = IO.readFileToString(file);
            string2 = new Regex(string2, "public\\s+enum.*?implements\\s+Translate\\s+\\{(.*)").getMatch(0);
            StringBuilder stringBuilder2 = new StringBuilder();
            StringBuilder stringBuilder3 = new StringBuilder();
            Translate[] translateArray = (Translate[])clazz.getMethod("values", new Class[0]).invoke(null, new Object[0]);
            stringBuilder.append("\r\n############################ " + clazz.getSimpleName() + " Entries: ");
            int n = 0;
            for (Translate translate : translateArray) {
                n = Math.max(TranslateUtils.getName(translate).length(), n);
            }
            for (Translate translate : translateArray) {
                String string3;
                String string4 = translate.getDefaultTranslation();
                String string5 = TranslateUtils.getName(translate);
                if (TranslateUtils.countWildcards(string4) != translate.getWildCardCount()) {
                    throw new Exception("Wrong wildcard count in defaulttranslation: " + string5 + "=" + translate.getDefaultTranslation() + " WCC: " + translate.getWildCardCount());
                }
                StringBuilder stringBuilder4 = stringBuilder;
                String string6 = new Regex(string2, string5 + "\\s*\\(\"[^\r^\n]*?(?<!\\\\)\"\\, \\d+\\)[\\,\\;]").getMatch(-1);
                System.out.println(string5);
                if (string6 == null) {
                    string6 = new Regex(string2, string5 + "\\s*\\(\"[^\r^\n]*?(?<!\\\\)\"\\)[\\,\\;]").getMatch(-1);
                }
                if (string6 == null) {
                    throw new Exception("SYNTAX line. PLease recompile");
                }
                String string7 = new Regex(string2, "\\/\\*(.*?)\\*\\/\\s*" + Pattern.quote(string6)).getMatch(0);
                if (string7 != null) {
                    string7 = string7.replaceAll("\\s*\\*\\s*", " ");
                    if ((string7 = new Regex(string7, "###" + string + ":([^\r^\n]+)").getMatch(0)) != null) {
                        string7 = string7.split("###")[0].trim();
                    }
                    string2 = string2.replace(new Regex(string2, "(\\/\\*.*?\\*\\/\\s*" + Pattern.quote(string6) + ")").getMatch(0), "---\r\n" + string6);
                }
                if ((string3 = Loc.L(clazz.getSimpleName() + ":::" + string5, string7 != null ? string7 : translate.getDefaultTranslation()).replace("\r", "\\r").replace("\n", "\\n")).equals(translate.getDefaultTranslation())) {
                    stringBuilder4 = stringBuilder3;
                }
                if (string3 == translate.getDefaultTranslation()) {
                    stringBuilder4 = stringBuilder2;
                }
                if (translate.getWildCardCount() > 0) {
                    stringBuilder4.append("\r\n######");
                    stringBuilder4.append(string5);
                    stringBuilder4.append("-wildcards: ");
                    stringBuilder4.append(translate.getWildCardCount());
                }
                stringBuilder4.append("\r\n" + clazz.getSimpleName() + ":::");
                stringBuilder4.append(string5);
                stringBuilder4.append("      ");
                for (int j = string5.length(); j < n; ++j) {
                    stringBuilder4.append(" ");
                }
                stringBuilder4.append(" = ");
                stringBuilder4.append(string3);
            }
            if (stringBuilder2.length() > 0) {
                stringBuilder.append("\r\n################" + clazz.getSimpleName() + " Untranslated: \r\n");
                stringBuilder.append((CharSequence)stringBuilder2);
            }
            if (stringBuilder3.length() <= 0) continue;
            stringBuilder.append("\r\n################" + clazz.getSimpleName() + " Equals default: \r\n");
            stringBuilder.append((CharSequence)stringBuilder3);
        }
        return stringBuilder.toString();
    }

    private static String getName(Translate translate) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
        for (Field field : translate.getClass().getDeclaredFields()) {
            Object object;
            if (!field.isEnumConstant() || (object = field.get(null)) != translate) continue;
            return field.getName();
        }
        return null;
    }

    private static String handleMultiComment(String string) {
        string = new Regex(string, ".*\\/\\*(.*)").getMatch(0);
        return string;
    }
}

