/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.logging;

import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.appwork.utils.Application;
import org.appwork.utils.logging.ExceptionDefaultLogLevel;
import org.appwork.utils.logging.FileLogFormatter;
import org.appwork.utils.logging.LogEventHandler;
import org.appwork.utils.logging.LogFormatter;
import org.appwork.utils.logging.LogToFileHandler;

public class Log {
    private static Logger LOGGER;
    public static Logger L;

    public static void exception(Level level, Throwable throwable) {
        try {
            StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
            int n = 0;
            while (stackTraceElementArray[n].getClassName().equals(Log.class.getName())) {
                ++n;
            }
            LogRecord logRecord = new LogRecord(level, level.getName() + " Exception occurred");
            logRecord.setThrown(throwable);
            logRecord.setSourceClassName(stackTraceElementArray[n].getClassName() + "." + stackTraceElementArray[n].getMethodName());
            logRecord.setSourceMethodName(stackTraceElementArray[n].getFileName() + ":" + stackTraceElementArray[n].getLineNumber());
            Log.getLogger().log(logRecord);
        }
        catch (Throwable throwable2) {
            L.log(level, level.getName() + " Exception occurred", throwable);
        }
    }

    public static void exception(Throwable throwable) {
        if (throwable == null) {
            throwable = new NullPointerException("e is null");
        }
        Level level = null;
        if (throwable instanceof ExceptionDefaultLogLevel) {
            level = ((ExceptionDefaultLogLevel)((Object)throwable)).getDefaultLogLevel();
        }
        if (level == null) {
            level = Level.SEVERE;
        }
        Log.exception(level, throwable);
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    static {
        Application.redirectOutputStreams();
        LOGGER = Logger.getLogger("org.appwork");
        LOGGER.setUseParentHandlers(false);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.ALL);
        consoleHandler.setFormatter(new LogFormatter());
        LOGGER.addHandler(consoleHandler);
        try {
            LogToFileHandler logToFileHandler = new LogToFileHandler();
            logToFileHandler.setFormatter(new FileLogFormatter());
            LOGGER.addHandler(logToFileHandler);
        }
        catch (Exception exception) {
            Log.exception(exception);
        }
        LOGGER.addHandler(LogEventHandler.getInstance());
        LOGGER.setLevel(Level.WARNING);
        L = LOGGER;
    }
}

