/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.io.IOException;
import java.io.OutputStream;

public class ChunkedOutputStream
extends OutputStream {
    private final OutputStream os;
    private final byte[] buffer;
    private int bufUsed = 0;
    boolean closed = false;

    public ChunkedOutputStream(OutputStream outputStream) {
        this(outputStream, 4096);
    }

    public ChunkedOutputStream(OutputStream outputStream, byte[] byArray) {
        this.os = outputStream;
        this.buffer = byArray;
    }

    public ChunkedOutputStream(OutputStream outputStream, int n) {
        this.os = outputStream;
        this.buffer = new byte[n];
    }

    private void _flush(boolean bl) throws IOException {
        if (!this.closed && (this.bufUsed > 0 || bl)) {
            byte[] byArray = Integer.toHexString(this.bufUsed).getBytes();
            this.os.write(byArray);
            this.os.write(13);
            this.os.write(10);
            if (this.bufUsed > 0 || bl) {
                if (this.bufUsed > 0) {
                    this.os.write(this.buffer, 0, this.bufUsed);
                }
                this.os.write(13);
                this.os.write(10);
            }
            this.bufUsed = 0;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.sendEOF();
            this.closed = true;
        }
        this.os.close();
    }

    @Override
    public synchronized void flush() throws IOException {
        this._flush(false);
        this.os.flush();
    }

    public synchronized void sendEOF() throws IOException {
        this._flush(false);
        this._flush(true);
        this.os.flush();
        this.closed = true;
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        if (this.bufUsed + n2 < this.buffer.length) {
            System.arraycopy(byArray, n, this.buffer, this.bufUsed, n2);
            this.bufUsed += n2;
        } else {
            byte[] byArray2 = Integer.toHexString(this.bufUsed + n2).getBytes();
            this.os.write(byArray2);
            this.os.write(13);
            this.os.write(10);
            if (this.bufUsed > 0) {
                this.os.write(this.buffer, 0, this.bufUsed);
                this.bufUsed = 0;
            }
            this.os.write(byArray, n, n2);
            this.os.write(13);
            this.os.write(10);
        }
    }

    @Override
    public synchronized void write(int n) throws IOException {
        if (this.bufUsed == this.buffer.length) {
            byte[] byArray = Integer.toHexString(this.buffer.length).getBytes();
            this.os.write(byArray);
            this.os.write(13);
            this.os.write(10);
            this.os.write(this.buffer);
            this.os.write(13);
            this.os.write(10);
            this.bufUsed = 0;
        }
        this.buffer[this.bufUsed++] = (byte)n;
    }
}

