/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import org.appwork.utils.Regex;
import org.appwork.utils.encoding.Base64;
import org.appwork.utils.logging.Log;

public class HTTPConnectionUtils {
    private static byte R = (byte)13;
    private static byte N = (byte)10;

    public static String getFileNameFromDispositionHeader(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        String string3 = string;
        String string4 = null;
        for (int i = 0; i < 2; ++i) {
            Object object;
            if (string3.contains("filename*")) {
                string3 = string3.replaceAll("filename=.*?;", "");
                object = new Regex(string3 = string3.replaceAll("filename\\*", "filename"), ".*?=[ \"']*(.+)''").getMatch(0);
                if (object == null) {
                    Log.L.severe("Content-Disposition: invalid format: " + string);
                    string4 = null;
                    return string4;
                }
                string4 = new Regex(string3 = string3.replaceAll((String)object + "''", ""), "filename.*?=[ ]*\"(.+)\"").getMatch(0);
                if (string4 == null) {
                    string4 = new Regex(string3, "filename.*?=[ ]*'(.+)'").getMatch(0);
                }
                if (string4 == null) {
                    string = string.replaceAll("=", "=\"") + "\"";
                    string3 = string = string.replaceAll(";\"", "\"");
                } else {
                    try {
                        string4 = URLDecoder.decode(string4, (String)object);
                    }
                    catch (Exception exception) {
                        Log.L.severe("Content-Disposition: could not decode filename: " + string);
                        string4 = null;
                        return string4;
                    }
                }
            } else if (new Regex(string3, "=\\?.*?\\?.*?\\?.*?\\?=").matches()) {
                object = new Regex(string3, "=\\?(.*?)\\?(.*?)\\?(.*?)\\?=").getMatches();
                if (((String[][])object).length == 1 && object[0].length == 3 && object[0][1].trim().equalsIgnoreCase("B")) {
                    try {
                        string4 = URLDecoder.decode(new String(Base64.decode(object[0][2].trim()), object[0][0].trim()), object[0][0].trim());
                    }
                    catch (Exception exception) {
                        Log.L.severe("Content-Disposition: could not decode filename: " + string);
                        string4 = null;
                        return string4;
                    }
                }
            } else if (new Regex(string3, "=\\?.*?\\?.*?\\?=").matches()) {
                object = new Regex(string3, "=\\?(.*?)\\?(.*?)\\?=").getMatches();
                if (((String[][])object).length == 1 && object[0].length == 2) {
                    try {
                        string3 = new String(object[0][1].trim().getBytes("ISO-8859-1"), object[0][0].trim());
                        continue;
                    }
                    catch (Exception exception) {
                        Log.L.severe("Content-Disposition: could not decode filename: " + string);
                        string4 = null;
                        return string4;
                    }
                }
            } else {
                string4 = new Regex(string3, "filename.*?=[ ]*\"(.+)\"").getMatch(0);
                if (string4 == null) {
                    string4 = new Regex(string3, "filename.*?=[ ]*'(.+)'").getMatch(0);
                }
                if (string4 == null) {
                    string = string.replaceAll("=", "=\"") + "\"";
                    string3 = string = string.replaceAll(";\"", "\"");
                }
            }
            if (string4 != null) break;
        }
        if (string4 != null && (string4 = string4.trim()).startsWith("\"")) {
            Log.L.info("Using Workaround for broken filename header!");
            string4 = string4.substring(1);
        }
        if (string4 == null) {
            Log.L.severe("Content-Disposition: could not parse header: " + string2);
        }
        return string4;
    }

    public static ByteBuffer readheader(InputStream inputStream, boolean bl) throws IOException {
        int n;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
        byte[] byArray = new byte[1];
        boolean bl2 = false;
        while ((n = inputStream.read(byArray)) >= 0) {
            int n2;
            if (byteBuffer.remaining() < 1) {
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.capacity() * 2);
                byteBuffer.flip();
                byteBuffer2.put(byteBuffer);
                byteBuffer = byteBuffer2;
            }
            if (n > 0) {
                byteBuffer.put(byArray);
            }
            if (bl) {
                if ((byteBuffer.position() < 1 || byteBuffer.get((n2 = byteBuffer.position()) - 1) != N) && (byteBuffer.position() < 2 || byteBuffer.get((n2 = byteBuffer.position()) - 2) != R || byteBuffer.get(n2 - 1) != N)) continue;
                break;
            }
            if (byteBuffer.position() < 4) continue;
            n2 = byteBuffer.position();
            bl2 = byteBuffer.get(n2 - 4) == R;
            bl2 &= byteBuffer.get(n2 - 3) == N;
            bl2 &= byteBuffer.get(n2 - 2) == R;
            if (!(bl2 &= byteBuffer.get(n2 - 1) == N)) continue;
        }
        byteBuffer.flip();
        return byteBuffer;
    }
}

