/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.appwork.utils.Regex;
import org.appwork.utils.encoding.Base64;
import org.appwork.utils.net.httpconnection.HTTPConnectionImpl;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.HTTPProxyException;
import org.appwork.utils.net.httpconnection.ProxyAuthException;
import org.appwork.utils.net.httpconnection.ProxyConnectException;
import org.appwork.utils.net.httpconnection.TrustALLSSLFactory;

public class HTTPProxyHTTPConnectionImpl
extends HTTPConnectionImpl {
    private int httpPort;
    private String httpHost;
    private StringBuilder proxyRequest;
    private InetSocketAddress proxyInetSocketAddress = null;

    public HTTPProxyHTTPConnectionImpl(URL uRL, HTTPProxy hTTPProxy) {
        super(uRL, hTTPProxy);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void connect() throws IOException {
        if (this.isConnected()) {
            return;
        }
        try {
            Object object;
            InetAddress[] inetAddressArray;
            if (this.proxy == null || !this.proxy.getType().equals((Object)HTTPProxy.TYPE.HTTP)) {
                throw new IOException("HTTPProxyHTTPConnection: invalid HTTP Proxy!");
            }
            if (this.proxy.getPass() != null && this.proxy.getPass().length() > 0 || this.proxy.getUser() != null && this.proxy.getUser().length() > 0) {
                inetAddressArray = this.proxy.getUser() == null ? "" : this.proxy.getUser();
                object = this.proxy.getPass() == null ? "" : this.proxy.getPass();
                this.requestProperties.put("Proxy-Authorization", "Basic " + new String(Base64.encodeToByte(((String)inetAddressArray + ":" + (String)object).getBytes(), false)));
            }
            inetAddressArray = null;
            inetAddressArray = InetAddress.getAllByName(this.proxy.getHost());
            object = null;
            long l = System.currentTimeMillis();
            for (InetAddress object2 : inetAddressArray) {
                this.httpSocket = new Socket();
                this.httpSocket.setSoTimeout(this.readTimeout);
                try {
                    l = System.currentTimeMillis();
                    this.proxyInetSocketAddress = new InetSocketAddress(object2, this.proxy.getPort());
                    this.httpSocket.connect(this.proxyInetSocketAddress, this.connectTimeout);
                    object = null;
                    break;
                }
                catch (IOException iOException) {
                    this.proxyInetSocketAddress = null;
                    try {
                        this.httpSocket.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    object = iOException;
                }
            }
            if (object != null) {
                throw new ProxyConnectException((Throwable)object, this.proxy);
            }
            this.requestTime = System.currentTimeMillis() - l;
            if (this.httpURL.getProtocol().startsWith("https")) {
                Object object2;
                void var8_15;
                this.proxyRequest = new StringBuilder();
                this.proxyRequest.append("CONNECT ");
                this.proxyRequest.append(this.httpURL.getHost() + ":" + (this.httpURL.getPort() != -1 ? this.httpURL.getPort() : this.httpURL.getDefaultPort()));
                this.proxyRequest.append(" HTTP/1.1\r\n");
                if (this.requestProperties.get("User-Agent") != null) {
                    this.proxyRequest.append("User-Agent: " + (String)this.requestProperties.get("User-Agent") + "\r\n");
                }
                if (this.requestProperties.get("Host") != null) {
                    this.proxyRequest.append("Host: " + (String)this.requestProperties.get("Host") + "\r\n");
                }
                if (this.requestProperties.get("Proxy-Authorization") != null) {
                    this.proxyRequest.append("Proxy-Authorization: " + (String)this.requestProperties.get("Proxy-Authorization") + "\r\n");
                }
                this.proxyRequest.append("\r\n");
                this.httpSocket.getOutputStream().write(this.proxyRequest.toString().getBytes("UTF-8"));
                this.httpSocket.getOutputStream().flush();
                Object object4 = HTTPConnectionUtils.readheader(this.httpSocket.getInputStream(), true);
                byte[] byArray = new byte[((Buffer)object4).limit()];
                ((ByteBuffer)object4).get(byArray);
                String string = new String(byArray, "ISO-8859-1").trim();
                this.proxyRequest.append(string + "\r\n");
                Object var8_13 = null;
                if (string.startsWith("HTTP")) {
                    String string2 = new Regex(string, "HTTP.*? (\\d+)").getMatch(0);
                }
                if (!"200".equals(var8_15)) {
                    try {
                        this.httpSocket.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if ("407".equals(var8_15)) {
                        throw new ProxyAuthException(this.proxy);
                    }
                    throw new ProxyConnectException(this.proxy);
                }
                while (((Buffer)(object4 = HTTPConnectionUtils.readheader(this.httpSocket.getInputStream(), true))).position() != 0) {
                    byArray = new byte[((Buffer)object4).limit()];
                    ((ByteBuffer)object4).get(byArray);
                    object2 = new String(byArray, "UTF-8");
                    this.proxyRequest.append((String)object2);
                }
                object2 = null;
                this.httpPort = this.httpURL.getPort();
                this.httpHost = this.httpURL.getHost();
                if (this.httpPort == -1) {
                    this.httpPort = this.httpURL.getDefaultPort();
                }
                try {
                    SSLSocketFactory sSLSocketFactory = TrustALLSSLFactory.getSSLFactoryTrustALL();
                    object2 = (SSLSocket)sSLSocketFactory.createSocket(this.httpSocket, this.httpHost, this.httpPort, true);
                    ((SSLSocket)object2).startHandshake();
                }
                catch (SSLHandshakeException sSLHandshakeException) {
                    try {
                        ((Socket)object2).close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        this.httpSocket.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw new IOException("HTTPProxyHTTPConnection: " + sSLHandshakeException, sSLHandshakeException);
                }
                this.httpSocket = object2;
                this.httpPath = new Regex(this.httpURL.toString(), "https?://.*?(/.+)").getMatch(0);
                if (this.httpPath == null) {
                    this.httpPath = "/";
                }
            } else {
                this.proxyRequest = new StringBuilder("DIRECT\r\n");
                this.httpPath = this.httpURL.toString();
            }
            this.sendRequest();
        }
        catch (IOException iOException) {
            try {
                this.disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (iOException instanceof HTTPProxyException) {
                throw iOException;
            }
            throw new ProxyConnectException(iOException, this.proxy);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        this.connectInputStream();
        if (this.getResponseCode() == 407) {
            throw new ProxyAuthException(this.proxy);
        }
        if (this.getResponseCode() == 504) {
            throw new ConnectException(this.getResponseCode() + " " + this.getResponseMessage());
        }
        return super.getInputStream();
    }

    @Override
    protected String getRequestInfo() {
        if (this.proxyRequest != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("-->HTTPProxy:").append(this.proxy.getHost() + ":" + this.proxy.getPort()).append("\r\n");
            if (this.proxyInetSocketAddress != null && this.proxyInetSocketAddress.getAddress() != null) {
                stringBuilder.append("-->HTTPProxyIP:").append(this.proxyInetSocketAddress.getAddress().getHostAddress()).append("\r\n");
            }
            stringBuilder.append("----------------CONNECTRequest(HTTP)------------\r\n");
            stringBuilder.append(this.proxyRequest.toString());
            stringBuilder.append("------------------------------------------------\r\n");
            stringBuilder.append(super.getRequestInfo());
            return stringBuilder.toString();
        }
        return super.getRequestInfo();
    }
}

