/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.controller.crawler;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import jd.JDInitFlags;
import jd.nutils.Formatter;
import jd.plugins.DecrypterPlugin;
import jd.plugins.PluginForDecrypt;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.utils.Application;
import org.appwork.utils.logging.Log;
import org.jdownloader.plugins.controller.PluginClassLoader;
import org.jdownloader.plugins.controller.PluginController;
import org.jdownloader.plugins.controller.PluginInfo;
import org.jdownloader.plugins.controller.crawler.AbstractCrawlerPlugin;
import org.jdownloader.plugins.controller.crawler.LazyCrawlerPlugin;

public class CrawlerPluginController
extends PluginController<PluginForDecrypt> {
    private static final CrawlerPluginController INSTANCE = new CrawlerPluginController();
    private List<LazyCrawlerPlugin> list = null;
    public static byte[] KEY = new byte[]{1, 3, 17, 1, 1, 84, 1, 1, 1, 1, 18, 1, 1, 1, 34, 1};

    public static CrawlerPluginController getInstance() {
        return INSTANCE;
    }

    private String getCache() {
        return "tmp/crawler.ejs";
    }

    private CrawlerPluginController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(boolean bl) {
        List<Object> list;
        block12: {
            list = new ArrayList();
            long l = System.currentTimeMillis();
            try {
                if (bl) {
                    try {
                        list = this.update();
                    }
                    catch (Throwable throwable) {
                        Log.L.severe("@CrawlerPluginController: update failed!");
                        Log.exception(throwable);
                    }
                    break block12;
                }
                try {
                    list = this.loadFromCache();
                }
                catch (Throwable throwable) {
                    Log.L.severe("@CrawlerPluginController: cache failed!");
                    Log.exception(throwable);
                }
                if (list.size() == 0) {
                    try {
                        list = this.update();
                    }
                    catch (Throwable throwable) {
                        Log.L.severe("@CrawlerPluginController: update failed!");
                        Log.exception(throwable);
                    }
                }
            }
            finally {
                Log.L.info("@CrawlerPluginController: init " + (System.currentTimeMillis() - l) + " :" + list.size());
            }
        }
        if (list.size() == 0) {
            Log.L.severe("@CrawlerPluginController: WTF, no plugins!");
        }
        this.list = list;
        System.gc();
    }

    private List<LazyCrawlerPlugin> loadFromCache() {
        ArrayList<AbstractCrawlerPlugin> arrayList = JSonStorage.restoreFrom(Application.getResource(this.getCache()), false, KEY, new TypeRef<ArrayList<AbstractCrawlerPlugin>>(){}, new ArrayList());
        ArrayList<LazyCrawlerPlugin> arrayList2 = new ArrayList<LazyCrawlerPlugin>(arrayList.size());
        PluginClassLoader.PluginClassLoaderChild pluginClassLoaderChild = PluginClassLoader.getInstance().getChild();
        for (AbstractCrawlerPlugin abstractCrawlerPlugin : arrayList) {
            arrayList2.add(new LazyCrawlerPlugin(abstractCrawlerPlugin, null, pluginClassLoaderChild));
        }
        return arrayList2;
    }

    private List<LazyCrawlerPlugin> update() throws MalformedURLException {
        ArrayList<LazyCrawlerPlugin> arrayList = new ArrayList<LazyCrawlerPlugin>();
        ArrayList<AbstractCrawlerPlugin> arrayList2 = new ArrayList<AbstractCrawlerPlugin>();
        PluginClassLoader.PluginClassLoaderChild pluginClassLoaderChild = PluginClassLoader.getInstance().getChild();
        for (PluginInfo pluginInfo : this.scan("jd/plugins/decrypter")) {
            String string = pluginInfo.getClazz().getSimpleName();
            DecrypterPlugin decrypterPlugin = pluginInfo.getClazz().getAnnotation(DecrypterPlugin.class);
            if (decrypterPlugin != null) {
                try {
                    long l = Formatter.getRevision(decrypterPlugin.revision());
                    String[] stringArray = decrypterPlugin.names();
                    String[] stringArray2 = decrypterPlugin.urls();
                    if (stringArray.length == 0) {
                        stringArray2 = (String[])pluginInfo.getClazz().getDeclaredMethod("getAnnotationUrls", new Class[0]).invoke(null, new Object[0]);
                        stringArray = (String[])pluginInfo.getClazz().getDeclaredMethod("getAnnotationNames", new Class[0]).invoke(null, new Object[0]);
                    }
                    if (stringArray2.length != stringArray.length) {
                        throw new WTFException("names.length != patterns.length");
                    }
                    if (stringArray.length == 0) {
                        throw new WTFException("names.length=0");
                    }
                    for (int i = 0; i < stringArray.length; ++i) {
                        try {
                            AbstractCrawlerPlugin abstractCrawlerPlugin = new AbstractCrawlerPlugin(new String(pluginInfo.getClazz().getSimpleName()));
                            abstractCrawlerPlugin.setDisplayName(new String(stringArray[i]));
                            abstractCrawlerPlugin.setPattern(new String(stringArray2[i]));
                            abstractCrawlerPlugin.setVersion(l);
                            LazyCrawlerPlugin lazyCrawlerPlugin = new LazyCrawlerPlugin(abstractCrawlerPlugin, null, pluginClassLoaderChild);
                            arrayList.add(lazyCrawlerPlugin);
                            arrayList2.add(abstractCrawlerPlugin);
                            Log.L.finest("@CrawlerPlugin ok:" + string + " " + stringArray[i]);
                            continue;
                        }
                        catch (Throwable throwable) {
                            Log.L.severe("@CrawlerPlugin failed:" + string + " " + stringArray[i]);
                            Log.exception(throwable);
                        }
                    }
                    continue;
                }
                catch (Throwable throwable) {
                    Log.L.severe("@CrawlerPlugin failed:" + string);
                    Log.exception(throwable);
                    continue;
                }
            }
            Log.L.severe("@CrawlerPlugin missing:" + string);
        }
        this.save(arrayList2);
        return arrayList;
    }

    private void save(List<AbstractCrawlerPlugin> list) {
        JSonStorage.saveTo(Application.getResource(this.getCache()), false, KEY, JSonStorage.serializeToJson(list));
    }

    public List<LazyCrawlerPlugin> list() {
        this.lazyInit();
        return this.list;
    }

    public void setList(List<LazyCrawlerPlugin> list) {
        if (list == null) {
            return;
        }
        this.list = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit() {
        if (this.list != null) {
            return;
        }
        CrawlerPluginController crawlerPluginController = this;
        synchronized (crawlerPluginController) {
            if (this.list != null) {
                return;
            }
            this.init(JDInitFlags.REFRESH_CACHE || JDInitFlags.SWITCH_RETURNED_FROM_UPDATE);
        }
    }

    public LazyCrawlerPlugin get(String string) {
        this.lazyInit();
        for (LazyCrawlerPlugin lazyCrawlerPlugin : this.list) {
            if (!lazyCrawlerPlugin.getDisplayName().equalsIgnoreCase(string)) continue;
            return lazyCrawlerPlugin;
        }
        return null;
    }
}

