/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp3;

import com.frostwire.mp3.BufferTools;
import com.frostwire.mp3.InvalidDataException;

public abstract class AbstractID3v2FrameData {
    boolean unsynchronisation;

    public AbstractID3v2FrameData(boolean bl) {
        this.unsynchronisation = bl;
    }

    protected void synchroniseAndUnpackFrameData(byte[] byArray) throws InvalidDataException {
        if (this.unsynchronisation && BufferTools.sizeSynchronisationWouldSubtract(byArray) > 0) {
            byte[] byArray2 = BufferTools.synchroniseBuffer(byArray);
            this.unpackFrameData(byArray2);
        } else {
            this.unpackFrameData(byArray);
        }
    }

    protected byte[] packAndUnsynchroniseFrameData() {
        byte[] byArray = this.packFrameData();
        if (this.unsynchronisation && BufferTools.sizeUnsynchronisationWouldAdd(byArray) > 0) {
            return BufferTools.unsynchroniseBuffer(byArray);
        }
        return byArray;
    }

    protected byte[] toBytes() {
        return this.packAndUnsynchroniseFrameData();
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractID3v2FrameData)) {
            return false;
        }
        AbstractID3v2FrameData abstractID3v2FrameData = (AbstractID3v2FrameData)object;
        return this.unsynchronisation == abstractID3v2FrameData.unsynchronisation;
    }

    protected abstract void unpackFrameData(byte[] var1) throws InvalidDataException;

    protected abstract byte[] packFrameData();

    protected abstract int getLength();
}

