/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp3;

import com.frostwire.mp3.BufferTools;
import com.frostwire.mp3.EncodedText;
import com.frostwire.mp3.ID3v1Genres;
import com.frostwire.mp3.ID3v2;
import com.frostwire.mp3.ID3v2CommentFrameData;
import com.frostwire.mp3.ID3v2Frame;
import com.frostwire.mp3.ID3v2FrameSet;
import com.frostwire.mp3.ID3v2ObseleteFrame;
import com.frostwire.mp3.ID3v2ObseletePictureFrameData;
import com.frostwire.mp3.ID3v2PictureFrameData;
import com.frostwire.mp3.ID3v2TagFactory;
import com.frostwire.mp3.ID3v2TextFrameData;
import com.frostwire.mp3.ID3v2UrlFrameData;
import com.frostwire.mp3.InvalidDataException;
import com.frostwire.mp3.NoSuchTagException;
import com.frostwire.mp3.NotSupportedException;
import com.frostwire.mp3.UnsupportedTagException;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractID3v2Tag
implements ID3v2 {
    public static final String ID_IMAGE = "APIC";
    public static final String ID_ENCODER = "TENC";
    public static final String ID_URL = "WXXX";
    public static final String ID_COPYRIGHT = "TCOP";
    public static final String ID_ORIGINAL_ARTIST = "TOPE";
    public static final String ID_COMPOSER = "TCOM";
    public static final String ID_COMMENT = "COMM";
    public static final String ID_GENRE = "TCON";
    public static final String ID_YEAR = "TYER";
    public static final String ID_ALBUM = "TALB";
    public static final String ID_TITLE = "TIT2";
    public static final String ID_ARTIST = "TPE1";
    public static final String ID_TRACK = "TRCK";
    public static final String ID_IMAGE_OBSELETE = "PIC";
    public static final String ID_ENCODER_OBSELETE = "TEN";
    public static final String ID_URL_OBSELETE = "WXX";
    public static final String ID_COPYRIGHT_OBSELETE = "TCR";
    public static final String ID_ORIGINAL_ARTIST_OBSELETE = "TOA";
    public static final String ID_COMPOSER_OBSELETE = "TCM";
    public static final String ID_COMMENT_OBSELETE = "COM";
    public static final String ID_GENRE_OBSELETE = "TCO";
    public static final String ID_YEAR_OBSELETE = "TYE";
    public static final String ID_ALBUM_OBSELETE = "TAL";
    public static final String ID_TITLE_OBSELETE = "TT2";
    public static final String ID_ARTIST_OBSELETE = "TP1";
    public static final String ID_TRACK_OBSELETE = "TRK";
    protected static final String TAG = "ID3";
    protected static final String FOOTER_TAG = "3DI";
    protected static final int HEADER_LENGTH = 10;
    protected static final int FOOTER_LENGTH = 10;
    protected static final int MAJOR_VERSION_OFFSET = 3;
    protected static final int MINOR_VERSION_OFFSET = 4;
    protected static final int FLAGS_OFFSET = 5;
    protected static final int DATA_LENGTH_OFFSET = 6;
    protected static final int FOOTER_BIT = 4;
    protected static final int EXPERIMENTAL_BIT = 5;
    protected static final int EXTENDED_HEADER_BIT = 6;
    protected static final int COMPRESSION_BIT = 6;
    protected static final int UNSYNCHRONISATION_BIT = 7;
    protected static final int PADDING_LENGTH = 256;
    private static final String ITUNES_COMMENT_DESCRIPTION = "iTunNORM";
    protected boolean unsynchronisation = false;
    protected boolean extendedHeader = false;
    protected boolean experimental = false;
    protected boolean footer = false;
    protected boolean compression = false;
    protected boolean padding = false;
    protected String version = null;
    private int dataLength = 0;
    private int extendedHeaderLength;
    private byte[] extendedHeaderData;
    private boolean obseleteFormat = false;
    private final Map<String, ID3v2FrameSet> frameSets = new TreeMap<String, ID3v2FrameSet>();

    public AbstractID3v2Tag() {
    }

    public AbstractID3v2Tag(byte[] byArray) throws NoSuchTagException, UnsupportedTagException, InvalidDataException {
        this(byArray, false);
    }

    public AbstractID3v2Tag(byte[] byArray, boolean bl) throws NoSuchTagException, UnsupportedTagException, InvalidDataException {
        this.obseleteFormat = bl;
        this.unpackTag(byArray);
    }

    private void unpackTag(byte[] byArray) throws NoSuchTagException, UnsupportedTagException, InvalidDataException {
        ID3v2TagFactory.sanityCheckTag(byArray);
        int n = this.unpackHeader(byArray);
        try {
            if (this.extendedHeader) {
                n = this.unpackExtendedHeader(byArray, n);
            }
            int n2 = this.dataLength;
            if (this.footer) {
                n2 -= 10;
            }
            n = this.unpackFrames(byArray, n, n2);
            if (this.footer) {
                n = this.unpackFooter(byArray, this.dataLength);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new InvalidDataException("Premature end of tag", arrayIndexOutOfBoundsException);
        }
    }

    private int unpackHeader(byte[] byArray) throws UnsupportedTagException, InvalidDataException {
        byte by = byArray[3];
        byte by2 = byArray[4];
        this.version = by + "." + by2;
        if (by != 2 && by != 3 && by != 4) {
            throw new UnsupportedTagException("Unsupported version " + this.version);
        }
        this.unpackFlags(byArray);
        if ((byArray[5] & 0xF) != 0) {
            throw new UnsupportedTagException("Unrecognised bits in header");
        }
        this.dataLength = BufferTools.unpackSynchsafeInteger(byArray[6], byArray[7], byArray[8], byArray[9]);
        if (this.dataLength < 1) {
            throw new InvalidDataException("Zero size tag");
        }
        return 10;
    }

    protected abstract void unpackFlags(byte[] var1);

    private int unpackExtendedHeader(byte[] byArray, int n) {
        this.extendedHeaderLength = BufferTools.unpackSynchsafeInteger(byArray[n], byArray[n + 1], byArray[n + 2], byArray[n + 3]) + 4;
        this.extendedHeaderData = BufferTools.copyBuffer(byArray, n + 4, this.extendedHeaderLength);
        return this.extendedHeaderLength;
    }

    protected int unpackFrames(byte[] byArray, int n, int n2) {
        int n3;
        ID3v2Frame iD3v2Frame;
        for (n3 = n; n3 <= n2; n3 += iD3v2Frame.getLength()) {
            try {
                iD3v2Frame = this.createFrame(byArray, n3);
                this.addFrame(iD3v2Frame, false);
                continue;
            }
            catch (InvalidDataException invalidDataException) {
                break;
            }
        }
        return n3;
    }

    private void addFrame(ID3v2Frame iD3v2Frame, boolean bl) {
        ID3v2FrameSet iD3v2FrameSet = this.frameSets.get(iD3v2Frame.getId());
        if (iD3v2FrameSet == null) {
            iD3v2FrameSet = new ID3v2FrameSet(iD3v2Frame.getId());
            iD3v2FrameSet.addFrame(iD3v2Frame);
            this.frameSets.put(iD3v2Frame.getId(), iD3v2FrameSet);
        } else if (bl) {
            iD3v2FrameSet.clear();
            iD3v2FrameSet.addFrame(iD3v2Frame);
        } else {
            iD3v2FrameSet.addFrame(iD3v2Frame);
        }
    }

    protected ID3v2Frame createFrame(byte[] byArray, int n) throws InvalidDataException {
        if (this.obseleteFormat) {
            return new ID3v2ObseleteFrame(byArray, n);
        }
        return new ID3v2Frame(byArray, n);
    }

    protected ID3v2Frame createFrame(String string, byte[] byArray) {
        if (this.obseleteFormat) {
            return new ID3v2ObseleteFrame(string, byArray);
        }
        return new ID3v2Frame(string, byArray);
    }

    private int unpackFooter(byte[] byArray, int n) throws InvalidDataException {
        if (!FOOTER_TAG.equals(BufferTools.byteBufferToString(byArray, n, FOOTER_TAG.length()))) {
            throw new InvalidDataException("Invalid footer");
        }
        return 10;
    }

    @Override
    public byte[] toBytes() throws NotSupportedException {
        byte[] byArray = new byte[this.getLength()];
        this.packTag(byArray);
        return byArray;
    }

    public void packTag(byte[] byArray) throws NotSupportedException {
        int n = this.packHeader(byArray, 0);
        if (this.extendedHeader) {
            n = this.packExtendedHeader(byArray, n);
        }
        n = this.packFrames(byArray, n);
        if (this.footer) {
            n = this.packFooter(byArray, this.dataLength);
        }
    }

    private int packHeader(byte[] byArray, int n) {
        byte by;
        BufferTools.stringIntoByteBuffer(TAG, 0, TAG.length(), byArray, n);
        String[] stringArray = this.version.split("\\.");
        if (stringArray.length > 0) {
            byArray[n + 3] = by = Byte.parseByte(stringArray[0]);
        }
        if (stringArray.length > 1) {
            byArray[n + 4] = by = Byte.parseByte(stringArray[1]);
        }
        this.packFlags(byArray, n);
        BufferTools.packSynchsafeInteger(this.getDataLength(), byArray, n + 6);
        return n + 10;
    }

    protected abstract void packFlags(byte[] var1, int var2);

    private int packExtendedHeader(byte[] byArray, int n) {
        BufferTools.packSynchsafeInteger(this.extendedHeaderLength, byArray, n);
        BufferTools.copyIntoByteBuffer(this.extendedHeaderData, 0, this.extendedHeaderData.length, byArray, n + 4);
        return n + 4 + this.extendedHeaderData.length;
    }

    public int packFrames(byte[] byArray, int n) throws NotSupportedException {
        int n2 = this.packSpecifiedFrames(byArray, n, null, ID_IMAGE);
        n2 = this.packSpecifiedFrames(byArray, n2, ID_IMAGE, null);
        return n2;
    }

    private int packSpecifiedFrames(byte[] byArray, int n, String string, String string2) throws NotSupportedException {
        for (ID3v2FrameSet iD3v2FrameSet : this.frameSets.values()) {
            if (string != null && !string.equals(iD3v2FrameSet.getId()) || string2 != null && string2.equals(iD3v2FrameSet.getId())) continue;
            for (ID3v2Frame iD3v2Frame : iD3v2FrameSet.getFrames()) {
                if (iD3v2Frame.getDataLength() <= 0) continue;
                byte[] byArray2 = iD3v2Frame.toBytes();
                BufferTools.copyIntoByteBuffer(byArray2, 0, byArray2.length, byArray, n);
                n += byArray2.length;
            }
        }
        return n;
    }

    private int packFooter(byte[] byArray, int n) {
        byte by;
        BufferTools.stringIntoByteBuffer(FOOTER_TAG, 0, FOOTER_TAG.length(), byArray, n);
        String[] stringArray = this.version.split(".");
        if (stringArray.length > 0) {
            byArray[n + 3] = by = Byte.parseByte(stringArray[0]);
        }
        if (stringArray.length > 1) {
            byArray[n + 4] = by = Byte.parseByte(stringArray[0]);
        }
        this.packFlags(byArray, n);
        BufferTools.packSynchsafeInteger(this.getDataLength(), byArray, n + 6);
        return n + 10;
    }

    private int calculateDataLength() {
        int n = 0;
        if (this.extendedHeader) {
            n += this.extendedHeaderLength;
        }
        if (this.footer) {
            n += 10;
        } else if (this.padding) {
            n += 256;
        }
        for (ID3v2FrameSet iD3v2FrameSet : this.frameSets.values()) {
            for (ID3v2Frame iD3v2Frame : iD3v2FrameSet.getFrames()) {
                n += iD3v2Frame.getLength();
            }
        }
        return n;
    }

    protected boolean useFrameUnsynchronisation() {
        return false;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    private void invalidateDataLength() {
        this.dataLength = 0;
    }

    @Override
    public int getDataLength() {
        if (this.dataLength == 0) {
            this.dataLength = this.calculateDataLength();
        }
        return this.dataLength;
    }

    @Override
    public int getLength() {
        return this.getDataLength() + 10;
    }

    @Override
    public Map<String, ID3v2FrameSet> getFrameSets() {
        return this.frameSets;
    }

    @Override
    public boolean getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(boolean bl) {
        if (this.padding != bl) {
            this.invalidateDataLength();
            this.padding = bl;
        }
    }

    @Override
    public boolean hasFooter() {
        return this.footer;
    }

    @Override
    public void setFooter(boolean bl) {
        if (this.footer != bl) {
            this.invalidateDataLength();
            this.footer = bl;
        }
    }

    @Override
    public boolean hasUnsynchronisation() {
        return this.unsynchronisation;
    }

    @Override
    public void setUnsynchronisation(boolean bl) {
        if (this.unsynchronisation != bl) {
            this.invalidateDataLength();
            this.unsynchronisation = bl;
        }
    }

    @Override
    public boolean getObseleteFormat() {
        return this.obseleteFormat;
    }

    @Override
    public String getTrack() {
        ID3v2TextFrameData iD3v2TextFrameData = this.obseleteFormat ? this.extractTextFrameData(ID_TRACK_OBSELETE) : this.extractTextFrameData(ID_TRACK);
        if (iD3v2TextFrameData != null && iD3v2TextFrameData.getText() != null) {
            return iD3v2TextFrameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setTrack(String string) {
        if (string != null && string.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData iD3v2TextFrameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(0, string));
            this.addFrame(this.createFrame(ID_TRACK, iD3v2TextFrameData.toBytes()), true);
        }
    }

    @Override
    public String getArtist() {
        ID3v2TextFrameData iD3v2TextFrameData = this.obseleteFormat ? this.extractTextFrameData(ID_ARTIST_OBSELETE) : this.extractTextFrameData(ID_ARTIST);
        if (iD3v2TextFrameData != null && iD3v2TextFrameData.getText() != null) {
            return iD3v2TextFrameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setArtist(String string) {
        if (string != null && string.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData iD3v2TextFrameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(0, string));
            this.addFrame(this.createFrame(ID_ARTIST, iD3v2TextFrameData.toBytes()), true);
        }
    }

    @Override
    public String getTitle() {
        ID3v2TextFrameData iD3v2TextFrameData = this.obseleteFormat ? this.extractTextFrameData(ID_TITLE_OBSELETE) : this.extractTextFrameData(ID_TITLE);
        if (iD3v2TextFrameData != null && iD3v2TextFrameData.getText() != null) {
            return iD3v2TextFrameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setTitle(String string) {
        if (string != null && string.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData iD3v2TextFrameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(0, string));
            this.addFrame(this.createFrame(ID_TITLE, iD3v2TextFrameData.toBytes()), true);
        }
    }

    @Override
    public String getAlbum() {
        ID3v2TextFrameData iD3v2TextFrameData = this.obseleteFormat ? this.extractTextFrameData(ID_ALBUM_OBSELETE) : this.extractTextFrameData(ID_ALBUM);
        if (iD3v2TextFrameData != null && iD3v2TextFrameData.getText() != null) {
            return iD3v2TextFrameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setAlbum(String string) {
        if (string != null && string.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData iD3v2TextFrameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(0, string));
            this.addFrame(this.createFrame(ID_ALBUM, iD3v2TextFrameData.toBytes()), true);
        }
    }

    @Override
    public String getYear() {
        ID3v2TextFrameData iD3v2TextFrameData = this.obseleteFormat ? this.extractTextFrameData(ID_YEAR_OBSELETE) : this.extractTextFrameData(ID_YEAR);
        if (iD3v2TextFrameData != null && iD3v2TextFrameData.getText() != null) {
            return iD3v2TextFrameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setYear(String string) {
        if (string != null && string.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData iD3v2TextFrameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(0, string));
            this.addFrame(this.createFrame(ID_YEAR, iD3v2TextFrameData.toBytes()), true);
        }
    }

    @Override
    public int getGenre() {
        ID3v2TextFrameData iD3v2TextFrameData = this.obseleteFormat ? this.extractTextFrameData(ID_GENRE_OBSELETE) : this.extractTextFrameData(ID_GENRE);
        if (iD3v2TextFrameData == null || iD3v2TextFrameData.getText() == null) {
            return -1;
        }
        String string = iD3v2TextFrameData.getText().toString();
        if (string == null || string.length() == 0) {
            return -1;
        }
        try {
            return this.extractGenreNumber(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = this.extractGenreDescription(string);
            if (string2 != null && string2.length() > 0) {
                for (int i = 0; i < ID3v1Genres.GENRES.length; ++i) {
                    if (ID3v1Genres.GENRES[i].compareToIgnoreCase(string2) != 0) continue;
                    return i;
                }
            }
            return -1;
        }
    }

    @Override
    public void setGenre(int n) {
        if (n >= 0) {
            String string;
            this.invalidateDataLength();
            try {
                string = ID3v1Genres.GENRES[n];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string = "";
            }
            String string2 = "(" + Integer.toString(n) + ")" + string;
            ID3v2TextFrameData iD3v2TextFrameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(0, string2));
            this.addFrame(this.createFrame(ID_GENRE, iD3v2TextFrameData.toBytes()), true);
        }
    }

    @Override
    public String getGenreDescription() {
        String string;
        String string2;
        int n = this.getGenre();
        if (n >= 0) {
            try {
                return ID3v1Genres.GENRES[n];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }
        ID3v2TextFrameData iD3v2TextFrameData = this.obseleteFormat ? this.extractTextFrameData(ID_GENRE_OBSELETE) : this.extractTextFrameData(ID_GENRE);
        if (iD3v2TextFrameData != null && iD3v2TextFrameData.getText() != null && (string2 = iD3v2TextFrameData.getText().toString()) != null && string2.length() > 0 && (string = this.extractGenreDescription(string2)) != null & string.length() > 0) {
            return string;
        }
        return null;
    }

    protected int extractGenreNumber(String string) throws NumberFormatException {
        int n;
        String string2 = string.trim();
        if (string2.length() > 0 && string2.charAt(0) == '(' && (n = string2.indexOf(41)) > 0) {
            return Integer.parseInt(string2.substring(1, n));
        }
        return Integer.parseInt(string2);
    }

    protected String extractGenreDescription(String string) throws NumberFormatException {
        String string2 = string.trim();
        if (string2.length() > 0) {
            int n;
            if (string2.charAt(0) == '(' && (n = string2.indexOf(41)) > 0) {
                return string2.substring(n + 1);
            }
            return string2;
        }
        return null;
    }

    @Override
    public String getComment() {
        ID3v2CommentFrameData iD3v2CommentFrameData = this.obseleteFormat ? this.extractCommentFrameData(ID_COMMENT_OBSELETE, false) : this.extractCommentFrameData(ID_COMMENT, false);
        if (iD3v2CommentFrameData != null && iD3v2CommentFrameData.getComment() != null) {
            return iD3v2CommentFrameData.getComment().toString();
        }
        return null;
    }

    @Override
    public void setComment(String string) {
        if (string != null && string.length() > 0) {
            this.invalidateDataLength();
            ID3v2CommentFrameData iD3v2CommentFrameData = new ID3v2CommentFrameData(this.useFrameUnsynchronisation(), "eng", null, new EncodedText(0, string));
            this.addFrame(this.createFrame(ID_COMMENT, iD3v2CommentFrameData.toBytes()), true);
        }
    }

    @Override
    public String getItunesComment() {
        ID3v2CommentFrameData iD3v2CommentFrameData = this.obseleteFormat ? this.extractCommentFrameData(ID_COMMENT_OBSELETE, true) : this.extractCommentFrameData(ID_COMMENT, true);
        if (iD3v2CommentFrameData != null && iD3v2CommentFrameData.getComment() != null) {
            return iD3v2CommentFrameData.getComment().toString();
        }
        return null;
    }

    @Override
    public void setItunesComment(String string) {
        if (string != null && string.length() > 0) {
            this.invalidateDataLength();
            ID3v2CommentFrameData iD3v2CommentFrameData = new ID3v2CommentFrameData(this.useFrameUnsynchronisation(), ITUNES_COMMENT_DESCRIPTION, null, new EncodedText(0, string));
            this.addFrame(this.createFrame(ID_COMMENT, iD3v2CommentFrameData.toBytes()), true);
        }
    }

    @Override
    public String getComposer() {
        ID3v2TextFrameData iD3v2TextFrameData = this.obseleteFormat ? this.extractTextFrameData(ID_COMPOSER_OBSELETE) : this.extractTextFrameData(ID_COMPOSER);
        if (iD3v2TextFrameData != null && iD3v2TextFrameData.getText() != null) {
            return iD3v2TextFrameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setComposer(String string) {
        if (string != null && string.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData iD3v2TextFrameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(0, string));
            this.addFrame(this.createFrame(ID_COMPOSER, iD3v2TextFrameData.toBytes()), true);
        }
    }

    @Override
    public String getOriginalArtist() {
        ID3v2TextFrameData iD3v2TextFrameData = this.obseleteFormat ? this.extractTextFrameData(ID_ORIGINAL_ARTIST_OBSELETE) : this.extractTextFrameData(ID_ORIGINAL_ARTIST);
        if (iD3v2TextFrameData != null && iD3v2TextFrameData.getText() != null) {
            return iD3v2TextFrameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setOriginalArtist(String string) {
        if (string != null && string.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData iD3v2TextFrameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(0, string));
            this.addFrame(this.createFrame(ID_ORIGINAL_ARTIST, iD3v2TextFrameData.toBytes()), true);
        }
    }

    @Override
    public String getCopyright() {
        ID3v2TextFrameData iD3v2TextFrameData = this.obseleteFormat ? this.extractTextFrameData(ID_COPYRIGHT_OBSELETE) : this.extractTextFrameData(ID_COPYRIGHT);
        if (iD3v2TextFrameData != null && iD3v2TextFrameData.getText() != null) {
            return iD3v2TextFrameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setCopyright(String string) {
        if (string != null && string.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData iD3v2TextFrameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(0, string));
            this.addFrame(this.createFrame(ID_COPYRIGHT, iD3v2TextFrameData.toBytes()), true);
        }
    }

    @Override
    public String getUrl() {
        ID3v2UrlFrameData iD3v2UrlFrameData = this.obseleteFormat ? this.extractUrlFrameData(ID_URL_OBSELETE) : this.extractUrlFrameData(ID_URL);
        if (iD3v2UrlFrameData != null) {
            return iD3v2UrlFrameData.getUrl();
        }
        return null;
    }

    @Override
    public void setUrl(String string) {
        if (string != null && string.length() > 0) {
            this.invalidateDataLength();
            ID3v2UrlFrameData iD3v2UrlFrameData = new ID3v2UrlFrameData(this.useFrameUnsynchronisation(), null, string);
            this.addFrame(this.createFrame(ID_URL, iD3v2UrlFrameData.toBytes()), true);
        }
    }

    @Override
    public String getEncoder() {
        ID3v2TextFrameData iD3v2TextFrameData = this.obseleteFormat ? this.extractTextFrameData(ID_ENCODER_OBSELETE) : this.extractTextFrameData(ID_ENCODER);
        if (iD3v2TextFrameData != null && iD3v2TextFrameData.getText() != null) {
            return iD3v2TextFrameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setEncoder(String string) {
        if (string != null && string.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData iD3v2TextFrameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(0, string));
            this.addFrame(this.createFrame(ID_ENCODER, iD3v2TextFrameData.toBytes()), true);
        }
    }

    @Override
    public byte[] getAlbumImage() {
        ID3v2PictureFrameData iD3v2PictureFrameData = this.obseleteFormat ? this.createPictureFrameData(ID_IMAGE_OBSELETE) : this.createPictureFrameData(ID_IMAGE);
        if (iD3v2PictureFrameData != null) {
            return iD3v2PictureFrameData.getImageData();
        }
        return null;
    }

    @Override
    public void setAlbumImage(byte[] byArray, String string) {
        if (byArray != null && byArray.length > 0 && string != null && string.length() > 0) {
            this.invalidateDataLength();
            ID3v2PictureFrameData iD3v2PictureFrameData = new ID3v2PictureFrameData(this.useFrameUnsynchronisation(), string, 0, null, byArray);
            this.addFrame(this.createFrame(ID_IMAGE, iD3v2PictureFrameData.toBytes()), true);
        }
    }

    @Override
    public String getAlbumImageMimeType() {
        ID3v2PictureFrameData iD3v2PictureFrameData = this.obseleteFormat ? this.createPictureFrameData(ID_IMAGE_OBSELETE) : this.createPictureFrameData(ID_IMAGE);
        if (iD3v2PictureFrameData != null && iD3v2PictureFrameData.getMimeType() != null) {
            return iD3v2PictureFrameData.getMimeType();
        }
        return null;
    }

    @Override
    public void clearFrameSet(String string) {
        if (this.frameSets.remove(string) != null) {
            this.invalidateDataLength();
        }
    }

    private ID3v2TextFrameData extractTextFrameData(String string) {
        ID3v2FrameSet iD3v2FrameSet = this.frameSets.get(string);
        if (iD3v2FrameSet != null) {
            ID3v2Frame iD3v2Frame = iD3v2FrameSet.getFrames().get(0);
            try {
                ID3v2TextFrameData iD3v2TextFrameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), iD3v2Frame.getData());
                return iD3v2TextFrameData;
            }
            catch (InvalidDataException invalidDataException) {
                // empty catch block
            }
        }
        return null;
    }

    private ID3v2UrlFrameData extractUrlFrameData(String string) {
        ID3v2FrameSet iD3v2FrameSet = this.frameSets.get(string);
        if (iD3v2FrameSet != null) {
            ID3v2Frame iD3v2Frame = iD3v2FrameSet.getFrames().get(0);
            try {
                ID3v2UrlFrameData iD3v2UrlFrameData = new ID3v2UrlFrameData(this.useFrameUnsynchronisation(), iD3v2Frame.getData());
                return iD3v2UrlFrameData;
            }
            catch (InvalidDataException invalidDataException) {
                // empty catch block
            }
        }
        return null;
    }

    private ID3v2CommentFrameData extractCommentFrameData(String string, boolean bl) {
        ID3v2FrameSet iD3v2FrameSet = this.frameSets.get(string);
        if (iD3v2FrameSet != null) {
            for (ID3v2Frame iD3v2Frame : iD3v2FrameSet.getFrames()) {
                try {
                    ID3v2CommentFrameData iD3v2CommentFrameData = new ID3v2CommentFrameData(this.useFrameUnsynchronisation(), iD3v2Frame.getData());
                    if (!bl && iD3v2CommentFrameData.getDescription().toString().startsWith("iTun")) continue;
                    if (bl && ITUNES_COMMENT_DESCRIPTION.equals(iD3v2CommentFrameData.getDescription().toString())) {
                        return iD3v2CommentFrameData;
                    }
                    if (bl) continue;
                    return iD3v2CommentFrameData;
                }
                catch (InvalidDataException invalidDataException) {
                }
            }
        }
        return null;
    }

    private ID3v2PictureFrameData createPictureFrameData(String string) {
        ID3v2FrameSet iD3v2FrameSet = this.frameSets.get(string);
        if (iD3v2FrameSet != null) {
            ID3v2Frame iD3v2Frame = iD3v2FrameSet.getFrames().get(0);
            try {
                ID3v2PictureFrameData iD3v2PictureFrameData = this.obseleteFormat ? new ID3v2ObseletePictureFrameData(this.useFrameUnsynchronisation(), iD3v2Frame.getData()) : new ID3v2PictureFrameData(this.useFrameUnsynchronisation(), iD3v2Frame.getData());
                return iD3v2PictureFrameData;
            }
            catch (InvalidDataException invalidDataException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractID3v2Tag)) {
            return false;
        }
        if (super.equals(object)) {
            return true;
        }
        AbstractID3v2Tag abstractID3v2Tag = (AbstractID3v2Tag)object;
        if (this.unsynchronisation != abstractID3v2Tag.unsynchronisation) {
            return false;
        }
        if (this.extendedHeader != abstractID3v2Tag.extendedHeader) {
            return false;
        }
        if (this.experimental != abstractID3v2Tag.experimental) {
            return false;
        }
        if (this.footer != abstractID3v2Tag.footer) {
            return false;
        }
        if (this.compression != abstractID3v2Tag.compression) {
            return false;
        }
        if (this.dataLength != abstractID3v2Tag.dataLength) {
            return false;
        }
        if (this.extendedHeaderLength != abstractID3v2Tag.extendedHeaderLength) {
            return false;
        }
        if (this.version == null) {
            if (abstractID3v2Tag.version != null) {
                return false;
            }
        } else {
            if (abstractID3v2Tag.version == null) {
                return false;
            }
            if (!this.version.equals(abstractID3v2Tag.version)) {
                return false;
            }
        }
        if (this.frameSets == null) {
            if (abstractID3v2Tag.frameSets != null) {
                return false;
            }
        } else {
            if (abstractID3v2Tag.frameSets == null) {
                return false;
            }
            if (!((Object)this.frameSets).equals(abstractID3v2Tag.frameSets)) {
                return false;
            }
        }
        return true;
    }
}

