/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp3;

public class BufferTools {
    public static String byteBufferToString(byte[] byArray, int n, int n2) {
        if (n2 < 1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            char c = byArray[n + i] >= 0 ? (char)byArray[n + i] : (char)(byArray[n + i] + 256);
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static byte[] stringToByteBuffer(String string, int n, int n2) {
        String string2 = string.substring(n, n + n2);
        byte[] byArray = string2.getBytes();
        return byArray;
    }

    public static void stringIntoByteBuffer(String string, int n, int n2, byte[] byArray, int n3) {
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(n + i);
            byte by = c < '\u0080' ? (byte)c : (byte)(c - 256);
            byArray[n3 + i] = by;
        }
    }

    public static String trimStringRight(String string) {
        char c;
        int n;
        for (n = string.length() - 1; n >= 0 && (c = string.charAt(n)) <= ' '; --n) {
        }
        if (n == string.length() - 1) {
            return string;
        }
        if (n < 0) {
            return "";
        }
        return string.substring(0, n + 1);
    }

    public static String padStringRight(String string, int n, char c) {
        if (string.length() >= n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.length() < n) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static boolean checkBit(byte by, int n) {
        return (by & 1 << n) != 0;
    }

    public static byte setBit(byte by, int n, boolean bl) {
        byte by2 = bl ? (byte)(by | 1 << n) : (byte)(by & ~(1 << n));
        return by2;
    }

    public static int shiftByte(byte by, int n) {
        int n2 = by & 0xFF;
        if (n < 0) {
            return n2 << -n;
        }
        if (n > 0) {
            return n2 >> n;
        }
        return n2;
    }

    public static int unpackInteger(byte by, byte by2, byte by3, byte by4) {
        int n = by4 & 0xFF;
        n += BufferTools.shiftByte(by3, -8);
        n += BufferTools.shiftByte(by2, -16);
        return n += BufferTools.shiftByte(by, -24);
    }

    public static byte[] packInteger(int n) {
        byte[] byArray = new byte[4];
        byArray[3] = (byte)(n & 0xFF);
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[1] = (byte)(n >> 16 & 0xFF);
        byArray[0] = (byte)(n >> 24 & 0xFF);
        return byArray;
    }

    public static int unpackSynchsafeInteger(byte by, byte by2, byte by3, byte by4) {
        int n = by4 & 0x7F;
        n += BufferTools.shiftByte((byte)(by3 & 0x7F), -7);
        n += BufferTools.shiftByte((byte)(by2 & 0x7F), -14);
        return n += BufferTools.shiftByte((byte)(by & 0x7F), -21);
    }

    public static byte[] packSynchsafeInteger(int n) {
        byte[] byArray = new byte[4];
        BufferTools.packSynchsafeInteger(n, byArray, 0);
        return byArray;
    }

    public static void packSynchsafeInteger(int n, byte[] byArray, int n2) {
        byArray[n2 + 3] = (byte)(n & 0x7F);
        byArray[n2 + 2] = (byte)(n >> 7 & 0x7F);
        byArray[n2 + 1] = (byte)(n >> 14 & 0x7F);
        byArray[n2 + 0] = (byte)(n >> 21 & 0x7F);
    }

    public static byte[] copyBuffer(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray2[i] = byArray[n + i];
        }
        return byArray2;
    }

    public static void copyIntoByteBuffer(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        for (int i = n; i < n2; ++i) {
            byArray2[n3 + i] = byArray[i];
        }
    }

    public static int sizeUnsynchronisationWouldAdd(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length - 1; ++i) {
            if (byArray[i] != -1 || (byArray[i + 1] & 0xFFFFFFE0) != -32 && byArray[i + 1] != 0) continue;
            ++n;
        }
        if (byArray.length > 0 && byArray[byArray.length - 1] == -1) {
            ++n;
        }
        return n;
    }

    public static byte[] unsynchroniseBuffer(byte[] byArray) {
        int n = BufferTools.sizeUnsynchronisationWouldAdd(byArray);
        if (n == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length + n];
        int n2 = 0;
        for (int i = 0; i < byArray.length - 1; ++i) {
            byArray2[n2++] = byArray[i];
            if (byArray[i] != -1 || (byArray[i + 1] & 0xFFFFFFE0) != -32 && byArray[i + 1] != 0) continue;
            byArray2[n2++] = 0;
        }
        byArray2[n2++] = byArray[byArray.length - 1];
        if (byArray[byArray.length - 1] == -1) {
            byArray2[n2++] = 0;
        }
        return byArray2;
    }

    public static int sizeSynchronisationWouldSubtract(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length - 2; ++i) {
            if (byArray[i] != -1 || byArray[i + 1] != 0 || (byArray[i + 2] & 0xFFFFFFE0) != -32 && byArray[i + 2] != 0) continue;
            ++n;
        }
        if (byArray.length > 1 && byArray[byArray.length - 2] == -1 && byArray[byArray.length - 1] == 0) {
            ++n;
        }
        return n;
    }

    public static byte[] synchroniseBuffer(byte[] byArray) {
        int n = BufferTools.sizeSynchronisationWouldSubtract(byArray);
        if (n == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length - n];
        int n2 = 0;
        for (int i = 0; i < byArray2.length - 1; ++i) {
            byArray2[i] = byArray[n2];
            if (byArray[n2] == -1 && byArray[n2 + 1] == 0 && ((byArray[n2 + 2] & 0xFFFFFFE0) == -32 || byArray[n2 + 2] == 0)) {
                ++n2;
            }
            ++n2;
        }
        byArray2[byArray2.length - 1] = byArray[n2];
        return byArray2;
    }

    public static String substitute(String string, String string2, String string3) {
        if (string2.length() < 1 || string.indexOf(string2) < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(string2, n2)) >= 0) {
            if (n2 > n) {
                stringBuffer.append(string.substring(n, n2));
            }
            if (string3 != null) {
                stringBuffer.append(string3);
            }
            n = n2 + string2.length();
            ++n2;
        }
        if (n < string.length()) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    public static String asciiOnly(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < ' ' || c > '~') {
                stringBuffer.append('?');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

