/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp3;

import com.frostwire.mp3.BufferTools;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;

public class EncodedText {
    public static final byte TEXT_ENCODING_ISO_8859_1 = 0;
    public static final byte TEXT_ENCODING_UTF_16 = 1;
    public static final byte TEXT_ENCODING_UTF_16BE = 2;
    public static final byte TEXT_ENCODING_UTF_8 = 3;
    public static final String CHARSET_ISO_8859_1 = "ISO-8859-1";
    public static final String CHARSET_UTF_16 = "UTF-16";
    public static final String CHARSET_UTF_16BE = "UTF-16BE";
    public static final String CHARSET_UTF_8 = "UTF-8";
    private static final String[] characterSets = new String[]{"ISO-8859-1", "UTF-16", "UTF-16BE", "UTF-8"};
    private byte[] value;
    private byte textEncoding;

    public EncodedText(byte by, byte[] byArray) {
        this.textEncoding = by;
        this.value = byArray;
    }

    public EncodedText(byte by, String string) {
        this.textEncoding = by;
        this.value = EncodedText.stringToUnicodeBytes(string, this.characterSetForTextEncoding(by));
    }

    private String characterSetForTextEncoding(byte by) {
        try {
            return characterSets[by];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid text encoding " + by);
        }
    }

    public byte getTextEncoding() {
        return this.textEncoding;
    }

    public void setTextEncoding(byte by) {
        this.textEncoding = by;
    }

    public byte[] toBytes() {
        return this.value;
    }

    public String toString() {
        return EncodedText.unicodeBytesToString(this.value, this.characterSetForTextEncoding(this.textEncoding));
    }

    public String getCharacterSet() {
        return this.characterSetForTextEncoding(this.textEncoding);
    }

    public boolean equals(Object object) {
        if (!(object instanceof EncodedText)) {
            return false;
        }
        if (super.equals(object)) {
            return true;
        }
        EncodedText encodedText = (EncodedText)object;
        if (this.textEncoding != encodedText.textEncoding) {
            return false;
        }
        return Arrays.equals(this.value, encodedText.value);
    }

    public static String unicodeBytesToString(byte[] byArray, String string) {
        Charset charset = Charset.forName(string);
        CharsetDecoder charsetDecoder = charset.newDecoder();
        try {
            CharBuffer charBuffer = charsetDecoder.decode(ByteBuffer.wrap(byArray));
            String string2 = charBuffer.toString();
            int n = string2.indexOf(0);
            if (n == -1) {
                return string2;
            }
            return string2.substring(0, n);
        }
        catch (CharacterCodingException characterCodingException) {
            return null;
        }
    }

    public static byte[] stringToUnicodeBytes(String string, String string2) {
        Charset charset = Charset.forName(string2);
        CharsetEncoder charsetEncoder = charset.newEncoder();
        try {
            ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(string));
            return BufferTools.copyBuffer(byteBuffer.array(), 0, byteBuffer.limit());
        }
        catch (CharacterCodingException characterCodingException) {
            return null;
        }
    }
}

