/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp3;

import com.frostwire.mp3.BufferTools;
import com.frostwire.mp3.ID3v1;
import com.frostwire.mp3.ID3v1Genres;
import com.frostwire.mp3.NoSuchTagException;
import java.util.Arrays;

public class ID3v1Tag
implements ID3v1 {
    public static final int TAG_LENGTH = 128;
    private static final String VERSION_0 = "0";
    private static final String VERSION_1 = "1";
    private static final String TAG = "TAG";
    private static final int TITLE_OFFSET = 3;
    private static final int TITLE_LENGTH = 30;
    private static final int ARTIST_OFFSET = 33;
    private static final int ARTIST_LENGTH = 30;
    private static final int ALBUM_OFFSET = 63;
    private static final int ALBUM_LENGTH = 30;
    private static final int YEAR_OFFSET = 93;
    private static final int YEAR_LENGTH = 4;
    private static final int COMMENT_OFFSET = 97;
    private static final int COMMENT_LENGTH_V1_0 = 30;
    private static final int COMMENT_LENGTH_V1_1 = 28;
    private static final int TRACK_MARKER_OFFSET = 125;
    private static final int TRACK_OFFSET = 126;
    private static final int GENRE_OFFSET = 127;
    private String track = null;
    private String artist = null;
    private String title = null;
    private String album = null;
    private String year = null;
    private int genre = -1;
    private String comment = null;

    public ID3v1Tag() {
    }

    public ID3v1Tag(byte[] byArray) throws NoSuchTagException {
        this.unpackTag(byArray);
    }

    private void unpackTag(byte[] byArray) throws NoSuchTagException {
        this.sanityCheckTag(byArray);
        this.title = BufferTools.trimStringRight(BufferTools.byteBufferToString(byArray, 3, 30));
        this.artist = BufferTools.trimStringRight(BufferTools.byteBufferToString(byArray, 33, 30));
        this.album = BufferTools.trimStringRight(BufferTools.byteBufferToString(byArray, 63, 30));
        this.year = BufferTools.trimStringRight(BufferTools.byteBufferToString(byArray, 93, 4));
        this.genre = byArray[127] & 0xFF;
        if (this.genre == 255) {
            this.genre = -1;
        }
        if (byArray[125] != 0) {
            this.comment = BufferTools.trimStringRight(BufferTools.byteBufferToString(byArray, 97, 30));
            this.track = null;
        } else {
            this.comment = BufferTools.trimStringRight(BufferTools.byteBufferToString(byArray, 97, 28));
            byte by = byArray[126];
            this.track = by == 0 ? "" : Integer.toString(by);
        }
    }

    private void sanityCheckTag(byte[] byArray) throws NoSuchTagException {
        if (byArray.length != 128) {
            throw new NoSuchTagException("Buffer length wrong");
        }
        if (!TAG.equals(BufferTools.byteBufferToString(byArray, 0, TAG.length()))) {
            throw new NoSuchTagException();
        }
    }

    @Override
    public byte[] toBytes() {
        byte[] byArray = new byte[128];
        this.packTag(byArray);
        return byArray;
    }

    public void toBytes(byte[] byArray) {
        this.packTag(byArray);
    }

    public void packTag(byte[] byArray) {
        Arrays.fill(byArray, (byte)0);
        BufferTools.stringIntoByteBuffer(TAG, 0, 3, byArray, 0);
        this.packField(byArray, this.title, 30, 3);
        this.packField(byArray, this.artist, 30, 33);
        this.packField(byArray, this.album, 30, 63);
        this.packField(byArray, this.year, 4, 93);
        byArray[127] = this.genre < 128 ? (byte)this.genre : (byte)(this.genre - 256);
        if (this.track == null) {
            this.packField(byArray, this.comment, 30, 97);
        } else {
            this.packField(byArray, this.comment, 28, 97);
            String string = this.numericsOnly(this.track);
            if (string.length() > 0) {
                int n = Integer.parseInt(string.toString());
                byArray[126] = n < 128 ? (byte)n : (byte)(n - 256);
            }
        }
    }

    private void packField(byte[] byArray, String string, int n, int n2) {
        if (string != null) {
            BufferTools.stringIntoByteBuffer(string, 0, Math.min(string.length(), n), byArray, n2);
        }
    }

    private String numericsOnly(String string) {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length() && (c = string.charAt(i)) >= '0' && c <= '9'; ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    @Override
    public String getVersion() {
        if (this.track == null) {
            return VERSION_0;
        }
        return VERSION_1;
    }

    @Override
    public String getTrack() {
        return this.track;
    }

    @Override
    public void setTrack(String string) {
        this.track = string;
    }

    @Override
    public String getArtist() {
        return this.artist;
    }

    @Override
    public void setArtist(String string) {
        this.artist = string;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String string) {
        this.title = string;
    }

    @Override
    public String getAlbum() {
        return this.album;
    }

    @Override
    public void setAlbum(String string) {
        this.album = string;
    }

    @Override
    public String getYear() {
        return this.year;
    }

    @Override
    public void setYear(String string) {
        this.year = string;
    }

    @Override
    public int getGenre() {
        return this.genre;
    }

    @Override
    public void setGenre(int n) {
        this.genre = n;
    }

    @Override
    public String getGenreDescription() {
        try {
            return ID3v1Genres.GENRES[this.genre];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "Unknown";
        }
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String string) {
        this.comment = string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ID3v1Tag)) {
            return false;
        }
        if (super.equals(object)) {
            return true;
        }
        ID3v1Tag iD3v1Tag = (ID3v1Tag)object;
        if (this.genre != iD3v1Tag.genre) {
            return false;
        }
        if (this.track == null) {
            if (iD3v1Tag.track != null) {
                return false;
            }
        } else {
            if (iD3v1Tag.track == null) {
                return false;
            }
            if (!this.track.equals(iD3v1Tag.track)) {
                return false;
            }
        }
        if (this.artist == null) {
            if (iD3v1Tag.artist != null) {
                return false;
            }
        } else {
            if (iD3v1Tag.artist == null) {
                return false;
            }
            if (!this.artist.equals(iD3v1Tag.artist)) {
                return false;
            }
        }
        if (this.title == null) {
            if (iD3v1Tag.title != null) {
                return false;
            }
        } else {
            if (iD3v1Tag.title == null) {
                return false;
            }
            if (!this.title.equals(iD3v1Tag.title)) {
                return false;
            }
        }
        if (this.album == null) {
            if (iD3v1Tag.album != null) {
                return false;
            }
        } else {
            if (iD3v1Tag.album == null) {
                return false;
            }
            if (!this.album.equals(iD3v1Tag.album)) {
                return false;
            }
        }
        if (this.year == null) {
            if (iD3v1Tag.year != null) {
                return false;
            }
        } else {
            if (iD3v1Tag.year == null) {
                return false;
            }
            if (!this.year.equals(iD3v1Tag.year)) {
                return false;
            }
        }
        if (this.comment == null) {
            if (iD3v1Tag.comment != null) {
                return false;
            }
        } else {
            if (iD3v1Tag.comment == null) {
                return false;
            }
            if (!this.comment.equals(iD3v1Tag.comment)) {
                return false;
            }
        }
        return true;
    }
}

