/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp3;

import com.frostwire.mp3.AbstractID3v2Tag;
import com.frostwire.mp3.BufferTools;
import com.frostwire.mp3.InvalidDataException;
import com.frostwire.mp3.NoSuchTagException;
import com.frostwire.mp3.UnsupportedTagException;

public class ID3v23Tag
extends AbstractID3v2Tag {
    public static final String VERSION = "3.0";

    public ID3v23Tag() {
        this.version = VERSION;
    }

    public ID3v23Tag(byte[] byArray) throws NoSuchTagException, UnsupportedTagException, InvalidDataException {
        super(byArray);
    }

    @Override
    protected void unpackFlags(byte[] byArray) {
        this.unsynchronisation = BufferTools.checkBit(byArray[5], 7);
        this.extendedHeader = BufferTools.checkBit(byArray[5], 6);
        this.experimental = BufferTools.checkBit(byArray[5], 5);
    }

    @Override
    protected void packFlags(byte[] byArray, int n) {
        byArray[n + 5] = BufferTools.setBit(byArray[n + 5], 7, this.unsynchronisation);
        byArray[n + 5] = BufferTools.setBit(byArray[n + 5], 6, this.extendedHeader);
        byArray[n + 5] = BufferTools.setBit(byArray[n + 5], 5, this.experimental);
    }
}

