/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp3;

import com.frostwire.mp3.AbstractID3v2FrameData;
import com.frostwire.mp3.BufferTools;
import com.frostwire.mp3.EncodedText;
import com.frostwire.mp3.InvalidDataException;

public class ID3v2CommentFrameData
extends AbstractID3v2FrameData {
    private static final String DEFAULT_LANGUAGE = "eng";
    private String language;
    private EncodedText description;
    private EncodedText comment;

    public ID3v2CommentFrameData(boolean bl) {
        super(bl);
    }

    public ID3v2CommentFrameData(boolean bl, String string, EncodedText encodedText, EncodedText encodedText2) {
        super(bl);
        this.language = string;
        this.description = encodedText;
        this.comment = encodedText2;
    }

    public ID3v2CommentFrameData(boolean bl, byte[] byArray) throws InvalidDataException {
        super(bl);
        this.synchroniseAndUnpackFrameData(byArray);
    }

    @Override
    protected void unpackFrameData(byte[] byArray) throws InvalidDataException {
        int n;
        this.language = BufferTools.byteBufferToString(byArray, 1, 3);
        for (n = 4; n < byArray.length && byArray[n] != 0; ++n) {
        }
        this.description = new EncodedText(byArray[0], BufferTools.copyBuffer(byArray, 4, n - 4));
        int n2 = 0;
        for (int i = n + 1; i < byArray.length && byArray[i] != 0; ++i) {
            ++n2;
        }
        this.comment = new EncodedText(byArray[0], BufferTools.copyBuffer(byArray, n + 1, n2));
    }

    @Override
    protected byte[] packFrameData() {
        byte[] byArray = new byte[this.getLength()];
        byArray[0] = this.comment != null ? this.comment.getTextEncoding() : (byte)0;
        String string = this.language == null ? DEFAULT_LANGUAGE : (this.language.length() > 3 ? this.language.substring(0, 3) : BufferTools.padStringRight(this.language, 3, ' '));
        BufferTools.stringIntoByteBuffer(string, 0, 3, byArray, 1);
        int n = 0;
        if (this.description != null && this.description.toBytes().length > 0) {
            n = this.description.toBytes().length;
            BufferTools.copyIntoByteBuffer(this.description.toBytes(), 0, n, byArray, 4);
        }
        byArray[n + 4] = 0;
        if (this.comment != null && this.comment.toBytes().length > 0) {
            BufferTools.copyIntoByteBuffer(this.comment.toBytes(), 0, this.comment.toBytes().length, byArray, n + 5);
        }
        return byArray;
    }

    @Override
    protected int getLength() {
        int n = 5;
        if (this.description != null) {
            n += this.description.toBytes().length;
        }
        if (this.comment != null) {
            n += this.comment.toBytes().length;
        }
        return n;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public EncodedText getComment() {
        return this.comment;
    }

    public void setComment(EncodedText encodedText) {
        this.comment = encodedText;
    }

    public EncodedText getDescription() {
        return this.description;
    }

    public void setDescription(EncodedText encodedText) {
        this.description = encodedText;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ID3v2CommentFrameData)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ID3v2CommentFrameData iD3v2CommentFrameData = (ID3v2CommentFrameData)object;
        if (this.language == null) {
            if (iD3v2CommentFrameData.language != null) {
                return false;
            }
        } else {
            if (iD3v2CommentFrameData.language == null) {
                return false;
            }
            if (!this.language.equals(iD3v2CommentFrameData.language)) {
                return false;
            }
        }
        if (this.description == null) {
            if (iD3v2CommentFrameData.description != null) {
                return false;
            }
        } else {
            if (iD3v2CommentFrameData.description == null) {
                return false;
            }
            if (!this.description.equals(iD3v2CommentFrameData.description)) {
                return false;
            }
        }
        if (this.comment == null) {
            if (iD3v2CommentFrameData.comment != null) {
                return false;
            }
        } else {
            if (iD3v2CommentFrameData.comment == null) {
                return false;
            }
            if (!this.comment.equals(iD3v2CommentFrameData.comment)) {
                return false;
            }
        }
        return true;
    }
}

