/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp3;

import com.frostwire.mp3.BufferTools;
import com.frostwire.mp3.ID3v2Frame;
import com.frostwire.mp3.InvalidDataException;
import com.frostwire.mp3.NotSupportedException;

public class ID3v2ObseleteFrame
extends ID3v2Frame {
    private static final int HEADER_LENGTH = 6;
    private static final int ID_OFFSET = 0;
    private static final int ID_LENGTH = 3;
    protected static final int DATA_LENGTH_OFFSET = 3;

    public ID3v2ObseleteFrame(byte[] byArray, int n) throws InvalidDataException {
        super(byArray, n);
    }

    public ID3v2ObseleteFrame(String string, byte[] byArray) {
        super(string, byArray);
    }

    @Override
    protected int unpackHeader(byte[] byArray, int n) {
        this.id = BufferTools.byteBufferToString(byArray, n + 0, 3);
        this.unpackDataLength(byArray, n);
        return n + 6;
    }

    @Override
    protected void unpackDataLength(byte[] byArray, int n) {
        this.dataLength = BufferTools.unpackInteger((byte)0, byArray[n + 3], byArray[n + 3 + 1], byArray[n + 3 + 2]);
    }

    @Override
    public void packFrame(byte[] byArray, int n) throws NotSupportedException {
        throw new NotSupportedException("Packing Obselete frames is not supported");
    }

    @Override
    public int getLength() {
        return this.dataLength + 6;
    }
}

