/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp3;

import com.frostwire.mp3.AbstractID3v2FrameData;
import com.frostwire.mp3.BufferTools;
import com.frostwire.mp3.EncodedText;
import com.frostwire.mp3.InvalidDataException;
import java.util.Arrays;

public class ID3v2PictureFrameData
extends AbstractID3v2FrameData {
    protected String mimeType;
    protected byte pictureType;
    protected EncodedText description;
    protected byte[] imageData;

    public ID3v2PictureFrameData(boolean bl) {
        super(bl);
    }

    public ID3v2PictureFrameData(boolean bl, String string, byte by, EncodedText encodedText, byte[] byArray) {
        super(bl);
        this.mimeType = string;
        this.pictureType = by;
        this.description = encodedText;
        this.imageData = byArray;
    }

    public ID3v2PictureFrameData(boolean bl, byte[] byArray) throws InvalidDataException {
        super(bl);
        this.synchroniseAndUnpackFrameData(byArray);
    }

    @Override
    protected void unpackFrameData(byte[] byArray) throws InvalidDataException {
        int n;
        int n2;
        for (n2 = 1; n2 < byArray.length && byArray[n2] != 0; ++n2) {
        }
        this.mimeType = BufferTools.byteBufferToString(byArray, 1, n2 - 1);
        this.pictureType = byArray[n2 + 1];
        for (n = n2 += 2; n < byArray.length && byArray[n] != 0; ++n) {
        }
        this.description = new EncodedText(byArray[0], BufferTools.copyBuffer(byArray, n2, n - n2));
        this.imageData = BufferTools.copyBuffer(byArray, n + 1, byArray.length - n - 1);
    }

    @Override
    protected byte[] packFrameData() {
        byte[] byArray = new byte[this.getLength()];
        byArray[0] = this.description != null ? this.description.getTextEncoding() : (byte)0;
        int n = 0;
        if (this.mimeType != null && this.mimeType.length() > 0) {
            n = this.mimeType.length();
            BufferTools.stringIntoByteBuffer(this.mimeType, 0, n, byArray, 1);
        }
        byArray[n + 1] = 0;
        byArray[n + 2] = this.pictureType;
        int n2 = 0;
        if (this.description != null && this.description.toBytes().length > 0) {
            n2 = this.description.toBytes().length;
            BufferTools.copyIntoByteBuffer(this.description.toBytes(), 0, n2, byArray, n + 3);
        }
        byArray[n + n2 + 3] = 0;
        if (this.imageData != null && this.imageData.length > 0) {
            BufferTools.copyIntoByteBuffer(this.imageData, 0, this.imageData.length, byArray, n + n2 + 4);
        }
        return byArray;
    }

    @Override
    protected int getLength() {
        int n = 4;
        if (this.mimeType != null) {
            n += this.mimeType.length();
        }
        if (this.description != null) {
            n += this.description.toBytes().length;
        }
        if (this.imageData != null) {
            n += this.imageData.length;
        }
        return n;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String string) {
        this.mimeType = string;
    }

    public byte getPictureType() {
        return this.pictureType;
    }

    public void setPictureType(byte by) {
        this.pictureType = by;
    }

    public EncodedText getDescription() {
        return this.description;
    }

    public void setDescription(EncodedText encodedText) {
        this.description = encodedText;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public void setImageData(byte[] byArray) {
        this.imageData = byArray;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ID3v2PictureFrameData)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ID3v2PictureFrameData iD3v2PictureFrameData = (ID3v2PictureFrameData)object;
        if (this.pictureType != iD3v2PictureFrameData.pictureType) {
            return false;
        }
        if (this.mimeType == null) {
            if (iD3v2PictureFrameData.mimeType != null) {
                return false;
            }
        } else {
            if (iD3v2PictureFrameData.mimeType == null) {
                return false;
            }
            if (!this.mimeType.equals(iD3v2PictureFrameData.mimeType)) {
                return false;
            }
        }
        if (this.description == null) {
            if (iD3v2PictureFrameData.description != null) {
                return false;
            }
        } else {
            if (iD3v2PictureFrameData.description == null) {
                return false;
            }
            if (!this.description.equals(iD3v2PictureFrameData.description)) {
                return false;
            }
        }
        if (this.imageData == null) {
            if (iD3v2PictureFrameData.imageData != null) {
                return false;
            }
        } else {
            if (iD3v2PictureFrameData.imageData == null) {
                return false;
            }
            if (!Arrays.equals(this.imageData, iD3v2PictureFrameData.imageData)) {
                return false;
            }
        }
        return true;
    }
}

