/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp3;

import com.frostwire.mp3.AbstractID3v2FrameData;
import com.frostwire.mp3.BufferTools;
import com.frostwire.mp3.EncodedText;
import com.frostwire.mp3.InvalidDataException;

public class ID3v2TextFrameData
extends AbstractID3v2FrameData {
    protected EncodedText text;

    public ID3v2TextFrameData(boolean bl) {
        super(bl);
    }

    public ID3v2TextFrameData(boolean bl, EncodedText encodedText) {
        super(bl);
        this.text = encodedText;
    }

    public ID3v2TextFrameData(boolean bl, byte[] byArray) throws InvalidDataException {
        super(bl);
        this.synchroniseAndUnpackFrameData(byArray);
    }

    @Override
    protected void unpackFrameData(byte[] byArray) throws InvalidDataException {
        this.text = new EncodedText(byArray[0], BufferTools.copyBuffer(byArray, 1, byArray.length - 1));
    }

    @Override
    protected byte[] packFrameData() {
        byte[] byArray = new byte[this.getLength()];
        byArray[0] = this.text != null ? this.text.getTextEncoding() : (byte)0;
        if (this.text != null && this.text.toBytes().length > 0) {
            BufferTools.copyIntoByteBuffer(this.text.toBytes(), 0, this.text.toBytes().length, byArray, 1);
        }
        return byArray;
    }

    @Override
    protected int getLength() {
        int n = 1;
        if (this.text != null) {
            n += this.text.toBytes().length;
        }
        return n;
    }

    public EncodedText getText() {
        return this.text;
    }

    public void setText(EncodedText encodedText) {
        this.text = encodedText;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ID3v2TextFrameData)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ID3v2TextFrameData iD3v2TextFrameData = (ID3v2TextFrameData)object;
        if (this.text == null) {
            if (iD3v2TextFrameData.text != null) {
                return false;
            }
        } else {
            if (iD3v2TextFrameData.text == null) {
                return false;
            }
            if (!this.text.equals(iD3v2TextFrameData.text)) {
                return false;
            }
        }
        return true;
    }
}

