/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp3;

import com.frostwire.mp3.AbstractID3v2FrameData;
import com.frostwire.mp3.BufferTools;
import com.frostwire.mp3.EncodedText;
import com.frostwire.mp3.InvalidDataException;

public class ID3v2UrlFrameData
extends AbstractID3v2FrameData {
    protected String url;
    protected EncodedText description;

    public ID3v2UrlFrameData(boolean bl) {
        super(bl);
    }

    public ID3v2UrlFrameData(boolean bl, EncodedText encodedText, String string) {
        super(bl);
        this.description = encodedText;
        this.url = string;
    }

    public ID3v2UrlFrameData(boolean bl, byte[] byArray) throws InvalidDataException {
        super(bl);
        this.synchroniseAndUnpackFrameData(byArray);
    }

    @Override
    protected void unpackFrameData(byte[] byArray) throws InvalidDataException {
        int n;
        for (n = 1; n < byArray.length && byArray[n] != 0; ++n) {
        }
        this.description = new EncodedText(byArray[0], BufferTools.copyBuffer(byArray, 1, n - 1));
        int n2 = 0;
        for (int i = n + 1; i < byArray.length && byArray[i] != 0; ++i) {
            ++n2;
        }
        this.url = BufferTools.byteBufferToString(byArray, n + 1, n2);
    }

    @Override
    protected byte[] packFrameData() {
        byte[] byArray = new byte[this.getLength()];
        byArray[0] = this.description != null ? this.description.getTextEncoding() : (byte)0;
        int n = 0;
        if (this.description != null && this.description.toBytes().length > 0) {
            n = this.description.toBytes().length;
            BufferTools.copyIntoByteBuffer(this.description.toBytes(), 0, n, byArray, 1);
        }
        byArray[n + 1] = 0;
        if (this.url != null && this.url.length() > 0) {
            BufferTools.stringIntoByteBuffer(this.url, 0, this.url.length(), byArray, n + 2);
        }
        return byArray;
    }

    @Override
    protected int getLength() {
        int n = 2;
        if (this.description != null) {
            n += this.description.toBytes().length;
        }
        if (this.url != null) {
            n += this.url.length();
        }
        return n;
    }

    public EncodedText getDescription() {
        return this.description;
    }

    public void setDescription(EncodedText encodedText) {
        this.description = encodedText;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ID3v2UrlFrameData)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ID3v2UrlFrameData iD3v2UrlFrameData = (ID3v2UrlFrameData)object;
        if (this.url == null) {
            if (iD3v2UrlFrameData.url != null) {
                return false;
            }
        } else {
            if (iD3v2UrlFrameData.url == null) {
                return false;
            }
            if (!this.url.equals(iD3v2UrlFrameData.url)) {
                return false;
            }
        }
        if (this.description == null) {
            if (iD3v2UrlFrameData.description != null) {
                return false;
            }
        } else {
            if (iD3v2UrlFrameData.description == null) {
                return false;
            }
            if (!this.description.equals(iD3v2UrlFrameData.description)) {
                return false;
            }
        }
        return true;
    }
}

