/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.BoxParser;
import com.frostwire.mp4.CastUtils;
import com.frostwire.mp4.ChannelHelper;
import com.frostwire.mp4.Hex;
import com.frostwire.mp4.IsoFile;
import com.frostwire.mp4.IsoTypeWriter;
import com.frostwire.mp4.boxes.Box;
import com.frostwire.mp4.boxes.ContainerBox;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Logger;

public abstract class AbstractBox
implements Box {
    private static Logger LOG = Logger.getLogger(AbstractBox.class.getName());
    protected String type;
    private byte[] userType;
    private ContainerBox parent;
    private ByteBuffer content;
    private ByteBuffer deadBytes = null;

    protected AbstractBox(String string) {
        this.type = string;
    }

    protected AbstractBox(String string, byte[] byArray) {
        this.type = string;
        this.userType = byArray;
    }

    protected abstract long getContentSize();

    protected abstract void getContent(ByteBuffer var1);

    protected abstract void _parseDetails(ByteBuffer var1);

    @Override
    public void parse(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer, long l, BoxParser boxParser) throws IOException {
        if (readableByteChannel instanceof FileChannel && l > 0x100000L) {
            this.content = ((FileChannel)readableByteChannel).map(FileChannel.MapMode.READ_ONLY, ((FileChannel)readableByteChannel).position(), l);
            ((FileChannel)readableByteChannel).position(((FileChannel)readableByteChannel).position() + l);
        } else {
            assert (l < Integer.MAX_VALUE);
            this.content = ChannelHelper.readFully(readableByteChannel, l);
        }
    }

    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(CastUtils.l2i(this.getSize()));
        this.getHeader(byteBuffer);
        if (this.content == null) {
            this.getContent(byteBuffer);
            if (this.deadBytes != null) {
                this.deadBytes.rewind();
                while (this.deadBytes.remaining() > 0) {
                    byteBuffer.put(this.deadBytes);
                }
            }
        } else {
            this.content.rewind();
            byteBuffer.put(this.content);
        }
        byteBuffer.rewind();
        writableByteChannel.write(byteBuffer);
    }

    public final synchronized void parseDetails() {
        if (this.content != null) {
            ByteBuffer byteBuffer = this.content;
            this.content = null;
            byteBuffer.rewind();
            this._parseDetails(byteBuffer);
            if (byteBuffer.remaining() > 0) {
                this.deadBytes = byteBuffer.slice();
            }
            assert (this.verify(byteBuffer));
        }
    }

    protected void setDeadBytes(ByteBuffer byteBuffer) {
        this.deadBytes = byteBuffer;
    }

    @Override
    public long getSize() {
        long l = this.content == null ? this.getContentSize() : (long)this.content.limit();
        l += (long)(8 + (l >= 0xFFFFFFF8L ? 8 : 0) + ("uuid".equals(this.getType()) ? 16 : 0));
        return l += (long)(this.deadBytes == null ? 0 : this.deadBytes.limit());
    }

    @Override
    public String getType() {
        return this.type;
    }

    public byte[] getUserType() {
        return this.userType;
    }

    @Override
    public ContainerBox getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ContainerBox containerBox) {
        this.parent = containerBox;
    }

    public IsoFile getIsoFile() {
        return this.parent.getIsoFile();
    }

    public boolean isParsed() {
        return this.content == null;
    }

    private boolean verify(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(CastUtils.l2i(this.getContentSize() + (long)(this.deadBytes != null ? this.deadBytes.limit() : 0)));
        this.getContent(byteBuffer2);
        if (this.deadBytes != null) {
            this.deadBytes.rewind();
            while (this.deadBytes.remaining() > 0) {
                byteBuffer2.put(this.deadBytes);
            }
        }
        byteBuffer.rewind();
        byteBuffer2.rewind();
        if (byteBuffer.remaining() != byteBuffer2.remaining()) {
            LOG.severe("remaining differs " + byteBuffer.remaining() + " vs. " + byteBuffer2.remaining());
            return false;
        }
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit() - 1;
        int n3 = byteBuffer2.limit() - 1;
        while (n2 >= n) {
            byte by;
            byte by2 = byteBuffer.get(n2);
            if (by2 != (by = byteBuffer2.get(n3))) {
                LOG.severe("buffers differ at " + n2 + ": " + by2 + "/" + by);
                byte[] byArray = new byte[byteBuffer.remaining()];
                byte[] byArray2 = new byte[byteBuffer2.remaining()];
                byteBuffer.get(byArray);
                byteBuffer2.get(byArray2);
                System.err.println(Hex.encodeHex(byArray));
                System.err.println(Hex.encodeHex(byArray2));
                return false;
            }
            --n2;
            --n3;
        }
        return true;
    }

    private boolean isSmallBox() {
        return (this.content == null ? this.getContentSize() + (long)(this.deadBytes != null ? this.deadBytes.limit() : 0) + 8L : (long)this.content.limit()) < 0x100000000L;
    }

    private void getHeader(ByteBuffer byteBuffer) {
        if (this.isSmallBox()) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.getSize());
            byteBuffer.put(IsoFile.fourCCtoBytes(this.getType()));
        } else {
            IsoTypeWriter.writeUInt32(byteBuffer, 1L);
            byteBuffer.put(IsoFile.fourCCtoBytes(this.getType()));
            IsoTypeWriter.writeUInt64(byteBuffer, this.getSize());
        }
        if ("uuid".equals(this.getType())) {
            byteBuffer.put(this.getUserType());
        }
    }
}

