/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.AbstractBox;
import com.frostwire.mp4.BoxParser;
import com.frostwire.mp4.CastUtils;
import com.frostwire.mp4.ChannelHelper;
import com.frostwire.mp4.IsoFile;
import com.frostwire.mp4.IsoTypeReader;
import com.frostwire.mp4.IsoTypeWriter;
import com.frostwire.mp4.boxes.Box;
import com.frostwire.mp4.boxes.ContainerBox;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Logger;

public abstract class AbstractBoxParser
implements BoxParser {
    private static Logger LOG = Logger.getLogger(AbstractBoxParser.class.getName());

    public abstract Box createBox(String var1, byte[] var2, String var3);

    @Override
    public Box parseBox(ReadableByteChannel readableByteChannel, ContainerBox containerBox) throws IOException {
        long l;
        Object object;
        ByteBuffer byteBuffer = ChannelHelper.readFully(readableByteChannel, 8L);
        long l2 = IsoTypeReader.readUInt32(byteBuffer);
        if (l2 < 8L && l2 > 1L) {
            LOG.severe("Plausibility check failed: size < 8 (size = " + l2 + "). Stop parsing!");
            return null;
        }
        String string = IsoTypeReader.read4cc(byteBuffer);
        byte[] byArray = null;
        if (l2 == 1L) {
            object = ByteBuffer.allocate(8);
            readableByteChannel.read((ByteBuffer)object);
            ((ByteBuffer)object).rewind();
            l2 = IsoTypeReader.readUInt64((ByteBuffer)object);
            l = l2 - 16L;
        } else if (l2 == 0L) {
            if (!(readableByteChannel instanceof FileChannel)) {
                throw new RuntimeException("Only FileChannel inputs may use size == 0 (box reaches to the end of file)");
            }
            l2 = ((FileChannel)readableByteChannel).size() - ((FileChannel)readableByteChannel).position() - 8L;
            l = l2 - 8L;
        } else {
            l = l2 - 8L;
        }
        if ("uuid".equals(string)) {
            object = ByteBuffer.allocate(16);
            readableByteChannel.read((ByteBuffer)object);
            ((ByteBuffer)object).rewind();
            byArray = ((ByteBuffer)object).array();
            l -= 16L;
        }
        object = this.createBox(string, byArray, containerBox.getType());
        object.setParent(containerBox);
        LOG.finest("Parsing " + object.getType());
        if (CastUtils.l2i(l2 - l) == 8) {
            byteBuffer.rewind();
        } else if (CastUtils.l2i(l2 - l) == 16) {
            byteBuffer = ByteBuffer.allocate(16);
            IsoTypeWriter.writeUInt32(byteBuffer, 1L);
            byteBuffer.put(IsoFile.fourCCtoBytes(string));
            IsoTypeWriter.writeUInt64(byteBuffer, l2);
        } else if (CastUtils.l2i(l2 - l) == 24) {
            byteBuffer = ByteBuffer.allocate(24);
            IsoTypeWriter.writeUInt32(byteBuffer, l2);
            byteBuffer.put(IsoFile.fourCCtoBytes(string));
            byteBuffer.put(byArray);
        } else if (CastUtils.l2i(l2 - l) == 32) {
            byteBuffer = ByteBuffer.allocate(32);
            IsoTypeWriter.writeUInt32(byteBuffer, l2);
            byteBuffer.put(IsoFile.fourCCtoBytes(string));
            IsoTypeWriter.writeUInt64(byteBuffer, l2);
            byteBuffer.put(byArray);
        } else {
            throw new RuntimeException("I didn't expect that");
        }
        object.parse(readableByteChannel, byteBuffer, l, this);
        if (object instanceof AbstractBox) {
            ((AbstractBox)object).parseDetails();
        }
        assert (l2 == object.getSize()) : "Reconstructed Size is not x to the number of parsed bytes! (" + object.getType() + ")" + " Actual Box size: " + l2 + " Calculated size: " + object.getSize();
        return object;
    }
}

