/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.AbstractBox;
import com.frostwire.mp4.BoxParser;
import com.frostwire.mp4.ByteBufferByteChannel;
import com.frostwire.mp4.boxes.Box;
import com.frostwire.mp4.boxes.ContainerBox;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public abstract class AbstractContainerBox
extends AbstractBox
implements ContainerBox {
    private static Logger LOG = Logger.getLogger(AbstractContainerBox.class.getName());
    protected List<Box> boxes = new LinkedList<Box>();
    protected BoxParser boxParser;

    @Override
    protected long getContentSize() {
        long l = 0L;
        for (Box box : this.boxes) {
            l += box.getSize();
        }
        return l;
    }

    public AbstractContainerBox(String string) {
        super(string);
    }

    @Override
    public List<Box> getBoxes() {
        return Collections.unmodifiableList(this.boxes);
    }

    @Override
    public void setBoxes(List<Box> list) {
        this.boxes = new LinkedList<Box>(list);
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz) {
        return this.getBoxes(clazz, false);
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz, boolean bl) {
        ArrayList<Box> arrayList = new ArrayList<Box>(2);
        for (Box box : this.boxes) {
            if (clazz.isInstance(box)) {
                arrayList.add(box);
            }
            if (!bl || !(box instanceof ContainerBox)) continue;
            arrayList.addAll(((ContainerBox)box).getBoxes(clazz, bl));
        }
        return arrayList;
    }

    public void addBox(Box box) {
        box.setParent(this);
        this.boxes.add(box);
    }

    public void removeBox(Box box) {
        this.boxes.remove(box);
    }

    @Override
    public void parse(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer, long l, BoxParser boxParser) throws IOException {
        super.parse(readableByteChannel, byteBuffer, l, boxParser);
        this.boxParser = boxParser;
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseChildBoxes(byteBuffer);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName()).append("[");
        for (int i = 0; i < this.boxes.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(";");
            }
            stringBuilder.append(this.boxes.get(i).toString());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public long getNumOfBytesToFirstChild() {
        return 8L;
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeChildBoxes(byteBuffer);
    }

    protected final void parseChildBoxes(ByteBuffer byteBuffer) {
        try {
            while (byteBuffer.remaining() >= 8) {
                this.boxes.add(this.boxParser.parseBox(new ByteBufferByteChannel(byteBuffer), this));
            }
            if (byteBuffer.remaining() != 0) {
                this.setDeadBytes(byteBuffer.slice());
                LOG.warning("Something's wrong with the sizes. There are dead bytes in a container box.");
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    protected final void writeChildBoxes(ByteBuffer byteBuffer) {
        ByteBufferByteChannel byteBufferByteChannel = new ByteBufferByteChannel(byteBuffer);
        for (Box box : this.boxes) {
            try {
                box.getBox(byteBufferByteChannel);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Cannot happen to me", iOException);
            }
        }
    }
}

