/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.CastUtils;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.WritableByteChannel;

public class ChannelHelper {
    public static ByteBuffer readFully(ReadableByteChannel readableByteChannel, long l) throws IOException {
        if (readableByteChannel instanceof FileChannel && l > 0x100000L) {
            MappedByteBuffer mappedByteBuffer = ((FileChannel)readableByteChannel).map(FileChannel.MapMode.READ_ONLY, ((FileChannel)readableByteChannel).position(), l);
            ((FileChannel)readableByteChannel).position(((FileChannel)readableByteChannel).position() + l);
            return mappedByteBuffer;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(CastUtils.l2i(l));
        ChannelHelper.readFully(readableByteChannel, byteBuffer, byteBuffer.limit());
        byteBuffer.rewind();
        assert ((long)byteBuffer.limit() == l);
        return byteBuffer;
    }

    public static void readFully(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) throws IOException {
        ChannelHelper.readFully(readableByteChannel, byteBuffer, byteBuffer.remaining());
    }

    public static int readFully(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer, int n) throws IOException {
        int n2;
        int n3 = 0;
        while (-1 != (n2 = readableByteChannel.read(byteBuffer)) && (n3 += n2) != n) {
        }
        if (n2 == -1) {
            throw new EOFException("End of file. No more boxes.");
        }
        return n3;
    }

    public static void writeFully(WritableByteChannel writableByteChannel, ByteBuffer byteBuffer) throws IOException {
        do {
            int n;
            if ((n = writableByteChannel.write(byteBuffer)) >= 0) continue;
            throw new EOFException();
        } while (byteBuffer.hasRemaining());
    }

    public static void close(SelectionKey selectionKey) {
        try {
            selectionKey.channel().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

