/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.AbstractFullBox;
import com.frostwire.mp4.BoxParser;
import com.frostwire.mp4.ByteBufferByteChannel;
import com.frostwire.mp4.boxes.Box;
import com.frostwire.mp4.boxes.ContainerBox;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public abstract class FullContainerBox
extends AbstractFullBox
implements ContainerBox {
    protected List<Box> boxes = new LinkedList<Box>();
    private static Logger LOG = Logger.getLogger(FullContainerBox.class.getName());
    BoxParser boxParser;

    @Override
    public void setBoxes(List<Box> list) {
        this.boxes = new LinkedList<Box>(list);
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz) {
        return this.getBoxes(clazz, false);
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz, boolean bl) {
        ArrayList<Box> arrayList = new ArrayList<Box>(2);
        for (Box box : this.boxes) {
            if (clazz == box.getClass()) {
                arrayList.add(box);
            }
            if (!bl || !(box instanceof ContainerBox)) continue;
            arrayList.addAll(((ContainerBox)box).getBoxes(clazz, bl));
        }
        return arrayList;
    }

    @Override
    protected long getContentSize() {
        long l = 4L;
        for (Box box : this.boxes) {
            l += box.getSize();
        }
        return l;
    }

    public void addBox(Box box) {
        this.boxes.add(box);
    }

    public void removeBox(Box box) {
        this.boxes.remove(box);
    }

    public FullContainerBox(String string) {
        super(string);
    }

    @Override
    public List<Box> getBoxes() {
        return this.boxes;
    }

    @Override
    public void parse(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer, long l, BoxParser boxParser) throws IOException {
        super.parse(readableByteChannel, byteBuffer, l, boxParser);
        this.boxParser = boxParser;
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        this.parseChildBoxes(byteBuffer);
    }

    protected final void parseChildBoxes(ByteBuffer byteBuffer) {
        try {
            while (byteBuffer.remaining() >= 8) {
                this.boxes.add(this.boxParser.parseBox(new ByteBufferByteChannel(byteBuffer), this));
            }
            if (byteBuffer.remaining() != 0) {
                this.setDeadBytes(byteBuffer.slice());
                LOG.severe("Some sizes are wrong");
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName()).append("[");
        for (int i = 0; i < this.boxes.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(";");
            }
            stringBuilder.append(this.boxes.get(i).toString());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        this.writeChildBoxes(byteBuffer);
    }

    protected final void writeChildBoxes(ByteBuffer byteBuffer) {
        ByteBufferByteChannel byteBufferByteChannel = new ByteBufferByteChannel(byteBuffer);
        for (Box box : this.boxes) {
            try {
                box.getBox(byteBufferByteChannel);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Cannot happen.", iOException);
            }
        }
    }

    @Override
    public long getNumOfBytesToFirstChild() {
        long l = 0L;
        for (Box box : this.boxes) {
            l += box.getSize();
        }
        return this.getSize() - l;
    }
}

