/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.AbstractBoxParser;
import com.frostwire.mp4.AbstractContainerBox;
import com.frostwire.mp4.BoxParser;
import com.frostwire.mp4.PropertyBoxParserImpl;
import com.frostwire.mp4.boxes.Box;
import com.frostwire.mp4.boxes.MovieBox;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class IsoFile
extends AbstractContainerBox {
    protected BoxParser boxParser = new PropertyBoxParserImpl(new String[0]);
    ReadableByteChannel byteChannel;

    public IsoFile() {
        super("");
    }

    public IsoFile(ReadableByteChannel readableByteChannel) throws IOException {
        super("");
        this.byteChannel = readableByteChannel;
        this.boxParser = this.createBoxParser();
        this.parse();
    }

    public IsoFile(ReadableByteChannel readableByteChannel, BoxParser boxParser) throws IOException {
        super("");
        this.byteChannel = readableByteChannel;
        this.boxParser = boxParser;
        this.parse();
    }

    protected BoxParser createBoxParser() {
        return new PropertyBoxParserImpl(new String[0]);
    }

    @Override
    public void _parseDetails(ByteBuffer byteBuffer) {
    }

    public void parse(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer, long l, AbstractBoxParser abstractBoxParser) throws IOException {
        throw new IOException("This method is not meant to be called. Use #parse() directly.");
    }

    private void parse() throws IOException {
        boolean bl = false;
        while (!bl) {
            try {
                Box box = this.boxParser.parseBox(this.byteChannel, this);
                if (box != null) {
                    this.boxes.add(box);
                    continue;
                }
                bl = true;
            }
            catch (EOFException eOFException) {
                bl = true;
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("IsoFile[");
        if (this.boxes == null) {
            stringBuilder.append("unparsed");
        } else {
            for (int i = 0; i < this.boxes.size(); ++i) {
                if (i > 0) {
                    stringBuilder.append(";");
                }
                stringBuilder.append(((Box)this.boxes.get(i)).toString());
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static byte[] fourCCtoBytes(String string) {
        byte[] byArray = new byte[4];
        if (string != null) {
            for (int i = 0; i < Math.min(4, string.length()); ++i) {
                byArray[i] = (byte)string.charAt(i);
            }
        }
        return byArray;
    }

    public static String bytesToFourCC(byte[] byArray) {
        byte[] byArray2 = new byte[]{0, 0, 0, 0};
        if (byArray != null) {
            System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, 4));
        }
        try {
            return new String(byArray2, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error("Required character encoding is missing", unsupportedEncodingException);
        }
    }

    @Override
    public long getNumOfBytesToFirstChild() {
        return 0L;
    }

    @Override
    public long getSize() {
        long l = 0L;
        for (Box box : this.boxes) {
            l += box.getSize();
        }
        return l;
    }

    @Override
    public IsoFile getIsoFile() {
        return this;
    }

    public MovieBox getMovieBox() {
        for (Box box : this.boxes) {
            if (!(box instanceof MovieBox)) continue;
            return (MovieBox)box;
        }
        return null;
    }

    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        for (Box box : this.boxes) {
            if (writableByteChannel instanceof FileChannel) {
                long l = ((FileChannel)writableByteChannel).position();
                box.getBox(writableByteChannel);
                long l2 = ((FileChannel)writableByteChannel).position() - l;
                assert (l2 == box.getSize());
                continue;
            }
            box.getBox(writableByteChannel);
        }
    }
}

