/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.Utf8;
import java.nio.ByteBuffer;

public final class IsoTypeWriter {
    public static void writeUInt64(ByteBuffer byteBuffer, long l) {
        IsoTypeWriter.writeUInt32(byteBuffer, l >> 32 & 0xFFFFFFFFL);
        IsoTypeWriter.writeUInt32(byteBuffer, l & 0xFFFFFFFFL);
    }

    public static void writeUInt32(ByteBuffer byteBuffer, long l) {
        assert (l >= 0L && l <= 0x100000000L) : "The given long is not in the range of uint32 (" + l + ")";
        IsoTypeWriter.writeUInt16(byteBuffer, (int)(l >> 16 & 0xFFFFL));
        IsoTypeWriter.writeUInt16(byteBuffer, (int)l & 0xFFFF);
    }

    public static void writeUInt32BE(ByteBuffer byteBuffer, long l) {
        assert (l >= 0L && l <= 0x100000000L) : "The given long is not in the range of uint32 (" + l + ")";
        IsoTypeWriter.writeUInt16BE(byteBuffer, (int)l & 0xFFFF);
        IsoTypeWriter.writeUInt16BE(byteBuffer, (int)(l >> 16 & 0xFFFFL));
    }

    public static void writeUInt24(ByteBuffer byteBuffer, int n) {
        IsoTypeWriter.writeUInt16(byteBuffer, (n &= 0xFFFFFF) >> 8);
        IsoTypeWriter.writeUInt8(byteBuffer, n);
    }

    public static void writeUInt16(ByteBuffer byteBuffer, int n) {
        IsoTypeWriter.writeUInt8(byteBuffer, (n &= 0xFFFF) >> 8);
        IsoTypeWriter.writeUInt8(byteBuffer, n & 0xFF);
    }

    public static void writeUInt16BE(ByteBuffer byteBuffer, int n) {
        IsoTypeWriter.writeUInt8(byteBuffer, (n &= 0xFFFF) & 0xFF);
        IsoTypeWriter.writeUInt8(byteBuffer, n >> 8);
    }

    public static void writeUInt8(ByteBuffer byteBuffer, int n) {
        byteBuffer.put(IsoTypeWriter.int2byte(n));
    }

    public static void writeFixedPont1616(ByteBuffer byteBuffer, double d) {
        int n = (int)(d * 65536.0);
        byteBuffer.put((byte)((n & 0xFF000000) >> 24));
        byteBuffer.put((byte)((n & 0xFF0000) >> 16));
        byteBuffer.put((byte)((n & 0xFF00) >> 8));
        byteBuffer.put((byte)(n & 0xFF));
    }

    public static void writeFixedPont88(ByteBuffer byteBuffer, double d) {
        short s = (short)(d * 256.0);
        byteBuffer.put((byte)((s & 0xFF00) >> 8));
        byteBuffer.put((byte)(s & 0xFF));
    }

    public static byte int2byte(int n) {
        return (byte)((n &= 0xFF) > 127 ? n - 256 : n);
    }

    public static void writeIso639(ByteBuffer byteBuffer, String string) {
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            n += string.getBytes()[i] - 96 << (2 - i) * 5;
        }
        IsoTypeWriter.writeUInt16(byteBuffer, n);
    }

    public static void writeUtf8String(ByteBuffer byteBuffer, String string) {
        byteBuffer.put(Utf8.convert(string));
        IsoTypeWriter.writeUInt8(byteBuffer, 0);
    }
}

