/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.Track;
import java.util.LinkedList;
import java.util.List;

public class Movie {
    List<Track> tracks = new LinkedList<Track>();

    public List<Track> getTracks() {
        return this.tracks;
    }

    public void setTracks(List<Track> list) {
        this.tracks = list;
    }

    public void addTrack(Track track) {
        if (this.getTrackByTrackId(track.getTrackMetaData().getTrackId()) != null) {
            track.getTrackMetaData().setTrackId(this.getNextTrackId());
        }
        this.tracks.add(track);
    }

    public String toString() {
        String string = "Movie{ ";
        for (Track track : this.tracks) {
            string = string + "track_" + track.getTrackMetaData().getTrackId() + " (" + track.getHandler() + ") ";
        }
        string = string + '}';
        return string;
    }

    public long getNextTrackId() {
        long l = 0L;
        for (Track track : this.tracks) {
            l = l < track.getTrackMetaData().getTrackId() ? track.getTrackMetaData().getTrackId() : l;
        }
        return ++l;
    }

    public Track getTrackByTrackId(long l) {
        for (Track track : this.tracks) {
            if (track.getTrackMetaData().getTrackId() != l) continue;
            return track;
        }
        return null;
    }

    public long getTimescale() {
        long l = this.getTracks().iterator().next().getTrackMetaData().getTimescale();
        for (Track track : this.getTracks()) {
            l = Movie.gcd(track.getTrackMetaData().getTimescale(), l);
        }
        return l;
    }

    public static long gcd(long l, long l2) {
        if (l2 == 0L) {
            return l;
        }
        return Movie.gcd(l2, l % l2);
    }
}

