/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.AbstractTrack;
import com.frostwire.mp4.CastUtils;
import com.frostwire.mp4.DateHelper;
import com.frostwire.mp4.TrackMetaData;
import com.frostwire.mp4.boxes.AbstractMediaHeaderBox;
import com.frostwire.mp4.boxes.CompositionTimeToSample;
import com.frostwire.mp4.boxes.MediaHeaderBox;
import com.frostwire.mp4.boxes.SampleDependencyTypeBox;
import com.frostwire.mp4.boxes.SampleDescriptionBox;
import com.frostwire.mp4.boxes.SampleTableBox;
import com.frostwire.mp4.boxes.SubSampleInformationBox;
import com.frostwire.mp4.boxes.TimeToSampleBox;
import com.frostwire.mp4.boxes.TrackBox;
import com.frostwire.mp4.boxes.TrackHeaderBox;
import com.frostwire.mp4.boxes.fragment.MovieExtendsBox;
import com.frostwire.mp4.boxes.fragment.MovieFragmentBox;
import com.frostwire.mp4.boxes.fragment.TrackFragmentBox;
import com.frostwire.mp4.boxes.fragment.TrackRunBox;
import com.frostwire.mp4.boxes.mdat.SampleList;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class Mp4TrackImpl
extends AbstractTrack {
    private List<ByteBuffer> samples;
    private SampleDescriptionBox sampleDescriptionBox;
    private List<TimeToSampleBox.Entry> decodingTimeEntries;
    private List<CompositionTimeToSample.Entry> compositionTimeEntries;
    private long[] syncSamples;
    private List<SampleDependencyTypeBox.Entry> sampleDependencies;
    private TrackMetaData trackMetaData = new TrackMetaData();
    private String handler;
    private AbstractMediaHeaderBox mihd;

    public Mp4TrackImpl(TrackBox trackBox) {
        this.samples = new SampleList(trackBox);
        SampleTableBox sampleTableBox = trackBox.getMediaBox().getMediaInformationBox().getSampleTableBox();
        this.handler = trackBox.getMediaBox().getHandlerBox().getHandlerType();
        this.mihd = trackBox.getMediaBox().getMediaInformationBox().getMediaHeaderBox();
        this.sampleDescriptionBox = sampleTableBox.getSampleDescriptionBox();
        if (trackBox.getParent().getBoxes(MovieExtendsBox.class).size() > 0) {
            this.decodingTimeEntries = new LinkedList<TimeToSampleBox.Entry>();
            this.compositionTimeEntries = new LinkedList<CompositionTimeToSample.Entry>();
            this.sampleDependencies = new LinkedList<SampleDependencyTypeBox.Entry>();
            for (MovieFragmentBox abstractBox2 : trackBox.getIsoFile().getBoxes(MovieFragmentBox.class)) {
                List<TrackFragmentBox> list = abstractBox2.getBoxes(TrackFragmentBox.class);
                for (TrackFragmentBox trackFragmentBox : list) {
                    if (trackFragmentBox.getTrackFragmentHeaderBox().getTrackId() != trackBox.getTrackHeaderBox().getTrackId()) continue;
                    List<TrackRunBox> list2 = trackFragmentBox.getBoxes(TrackRunBox.class);
                    for (TrackRunBox trackRunBox : list2) {
                        for (TrackRunBox.Entry entry : trackRunBox.getEntries()) {
                            Object object;
                            if (trackRunBox.isSampleDurationPresent()) {
                                if (this.decodingTimeEntries.size() == 0 || this.decodingTimeEntries.get(this.decodingTimeEntries.size() - 1).getDelta() != entry.getSampleDuration()) {
                                    this.decodingTimeEntries.add(new TimeToSampleBox.Entry(1L, entry.getSampleDuration()));
                                } else {
                                    object = this.decodingTimeEntries.get(this.decodingTimeEntries.size() - 1);
                                    ((TimeToSampleBox.Entry)object).setCount(((TimeToSampleBox.Entry)object).getCount() + 1L);
                                }
                            }
                            if (!trackRunBox.isSampleCompositionTimeOffsetPresent()) continue;
                            if (this.compositionTimeEntries.size() == 0 || this.compositionTimeEntries.get(this.compositionTimeEntries.size() - 1).getOffset() != entry.getSampleCompositionTimeOffset()) {
                                this.compositionTimeEntries.add(new CompositionTimeToSample.Entry(1, CastUtils.l2i(entry.getSampleCompositionTimeOffset())));
                                continue;
                            }
                            object = this.compositionTimeEntries.get(this.compositionTimeEntries.size() - 1);
                            ((CompositionTimeToSample.Entry)object).setCount(((CompositionTimeToSample.Entry)object).getCount() + 1);
                        }
                    }
                }
            }
        } else {
            this.decodingTimeEntries = sampleTableBox.getTimeToSampleBox().getEntries();
            if (sampleTableBox.getCompositionTimeToSample() != null) {
                this.compositionTimeEntries = sampleTableBox.getCompositionTimeToSample().getEntries();
            }
            if (sampleTableBox.getSyncSampleBox() != null) {
                this.syncSamples = sampleTableBox.getSyncSampleBox().getSampleNumber();
            }
            if (sampleTableBox.getSampleDependencyTypeBox() != null) {
                this.sampleDependencies = sampleTableBox.getSampleDependencyTypeBox().getEntries();
            }
        }
        MediaHeaderBox mediaHeaderBox = trackBox.getMediaBox().getMediaHeaderBox();
        TrackHeaderBox trackHeaderBox = trackBox.getTrackHeaderBox();
        this.setEnabled(trackHeaderBox.isEnabled());
        this.setInMovie(trackHeaderBox.isInMovie());
        this.setInPoster(trackHeaderBox.isInPoster());
        this.setInPreview(trackHeaderBox.isInPreview());
        this.trackMetaData.setTrackId(trackHeaderBox.getTrackId());
        this.trackMetaData.setCreationTime(DateHelper.convert(mediaHeaderBox.getCreationTime()));
        this.trackMetaData.setLanguage(mediaHeaderBox.getLanguage());
        this.trackMetaData.setModificationTime(DateHelper.convert(mediaHeaderBox.getModificationTime()));
        this.trackMetaData.setTimescale(mediaHeaderBox.getTimescale());
        this.trackMetaData.setHeight(trackHeaderBox.getHeight());
        this.trackMetaData.setWidth(trackHeaderBox.getWidth());
        this.trackMetaData.setLayer(trackHeaderBox.getLayer());
    }

    @Override
    public List<ByteBuffer> getSamples() {
        return this.samples;
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.sampleDescriptionBox;
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        return this.decodingTimeEntries;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return this.compositionTimeEntries;
    }

    @Override
    public long[] getSyncSamples() {
        return this.syncSamples;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return this.sampleDependencies;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    @Override
    public String getHandler() {
        return this.handler;
    }

    @Override
    public AbstractMediaHeaderBox getMediaHeaderBox() {
        return this.mihd;
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return null;
    }

    public String toString() {
        return "Mp4TrackImpl{handler='" + this.handler + '\'' + '}';
    }
}

